/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui.editors;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.DelayedRefreshJob;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.tasks.ui.editors.ContextWrapper;
import org.eclipse.mylyn.internal.context.tasks.ui.editors.InvisibleContextElementsPart;
import org.eclipse.mylyn.internal.context.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.context.tasks.ui.editors.ScalableInterestFilter;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.views.ContextNodeOpenListener;
import org.eclipse.mylyn.internal.tasks.ui.context.AttachContextHandler;
import org.eclipse.mylyn.internal.tasks.ui.context.ClearContextHandler;
import org.eclipse.mylyn.internal.tasks.ui.context.CopyContextHandler;
import org.eclipse.mylyn.internal.tasks.ui.context.RetrieveContextHandler;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.navigator.CommonViewer;

public class ContextEditorFormPage
extends FormPage {
    private static final int SCALE_STEPS = 14;
    public static final String ID_VIEWER = "org.eclipse.mylyn.context.ui.navigator.context";
    private ScrolledForm form;
    private Composite sectionClient;
    private FormToolkit toolkit;
    private CommonViewer commonViewer;
    private ScalableInterestFilter interestFilter;
    private Scale doiScale;
    private ITask task;
    private final AbstractContextListener CONTEXT_LISTENER = new AbstractContextListener(){

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case ACTIVATED: {
                    if (!ContextEditorFormPage.this.isActiveTask()) break;
                    ContextEditorFormPage.this.context.setWrappedContext(ContextCorePlugin.getContextManager().getActiveContext());
                    ContextEditorFormPage.this.refresh();
                    break;
                }
                case DEACTIVATED: {
                    if (!ContextEditorFormPage.this.context.isForSameTaskAs(event.getContext())) break;
                    ContextEditorFormPage.this.context.setWrappedContext(ContextCorePlugin.getContextStore().loadContext(ContextEditorFormPage.this.task.getHandleIdentifier()));
                    break;
                }
                case CLEARED: {
                    if (!ContextEditorFormPage.this.context.isForSameTaskAs(event.getContextHandle())) break;
                    ContextEditorFormPage.this.context.setWrappedContext(ContextCorePlugin.getContextStore().loadContext(ContextEditorFormPage.this.task.getHandleIdentifier()));
                    ContextEditorFormPage.this.refresh();
                    break;
                }
                case INTEREST_CHANGED: 
                case LANDMARKS_ADDED: 
                case LANDMARKS_REMOVED: 
                case ELEMENTS_DELETED: {
                    if (!ContextEditorFormPage.this.context.isForSameTaskAs(event.getContext())) break;
                    ContextEditorFormPage.this.context.setWrappedContext(event.getContext());
                    ContextEditorFormPage.this.refresh(event.getElements());
                }
            }
        }
    };
    private ContextEditorDelayedRefreshJob refreshJob;
    private InvisibleContextElementsPart invisiblePart;
    private ContextWrapper context;

    public ContextEditorFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ContextCore.getContextManager().addListener(this.CONTEXT_LISTENER);
        this.task = ((TaskEditorInput)this.getEditorInput()).getTask();
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        this.context = this.isActiveTask() ? new ContextWrapper(ContextCorePlugin.getContextManager().getActiveContext(), this.task) : new ContextWrapper(ContextCorePlugin.getContextStore().loadContext(this.task.getHandleIdentifier()), this.task);
        this.form.getBody().setLayout((Layout)new FillLayout());
        Composite composite = new Composite(this.form.getBody(), 0){

            public Point computeSize(int widhtHint, int heigtHint, boolean changed) {
                Rectangle clientArea = this.getClientArea();
                return super.computeSize(widhtHint, clientArea.height, changed);
            }
        };
        this.toolkit.adapt(composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createActionsSection(composite);
        this.createContentSection(composite);
        this.form.reflow(true);
    }

    public void dispose() {
        super.dispose();
        this.disposeRefreshJob();
        ContextCore.getContextManager().removeListener(this.CONTEXT_LISTENER);
        if (this.invisiblePart != null) {
            this.invisiblePart.dispose();
            this.invisiblePart = null;
        }
    }

    private void createActionsSection(Composite composite) {
        Section section = this.toolkit.createSection(composite, 320);
        section.setText(Messages.ContextEditorFormPage_Actions);
        section.setLayout((Layout)new GridLayout());
        GridData sectionGridData = new GridData(2);
        sectionGridData.widthHint = 80;
        section.setLayoutData((Object)sectionGridData);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        sectionClient.setLayoutData((Object)new GridData());
        ImageHyperlink filterImage = this.toolkit.createImageHyperlink(sectionClient, 0);
        filterImage.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FILTER));
        filterImage.setToolTipText(Messages.ContextEditorFormPage_Show_All_Elements);
        filterImage.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                ContextEditorFormPage.this.doiScale.setSelection(0);
                ContextEditorFormPage.this.interestFilter.setThreshold(-2.147483648E9);
                ContextEditorFormPage.this.refresh();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.doiScale = new Scale(sectionClient, 0x800000);
        GridData scaleGridData = new GridData(768);
        scaleGridData.heightHint = 36;
        scaleGridData.widthHint = 80;
        this.doiScale.setLayoutData((Object)scaleGridData);
        this.doiScale.setPageIncrement(1);
        this.doiScale.setMinimum(0);
        this.doiScale.setSelection(7);
        this.doiScale.setMaximum(14);
        this.doiScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextEditorFormPage.this.updateFilterThreshold();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (AttachmentUtil.canUploadAttachment((ITask)this.task)) {
            Label attachImage = this.toolkit.createLabel(sectionClient, "");
            attachImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_ATTACH));
            attachImage.setEnabled(this.task != null);
            Hyperlink attachHyperlink = this.toolkit.createHyperlink(sectionClient, Messages.ContextEditorFormPage_Attach_context_, 0);
            attachHyperlink.setEnabled(this.task != null);
            attachHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    AttachContextHandler.run((ITask)ContextEditorFormPage.this.task);
                }
            });
        }
        if (AttachmentUtil.canDownloadAttachment((ITask)this.task)) {
            Label retrieveImage = this.toolkit.createLabel(sectionClient, "");
            retrieveImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_RETRIEVE));
            retrieveImage.setEnabled(this.task != null);
            Hyperlink retrieveHyperlink = this.toolkit.createHyperlink(sectionClient, Messages.ContextEditorFormPage_Retrieve_Context_, 0);
            retrieveHyperlink.setEnabled(this.task != null);
            retrieveHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    RetrieveContextHandler.run((ITask)ContextEditorFormPage.this.task);
                }
            });
        }
        Label copyImage = this.toolkit.createLabel(sectionClient, "");
        copyImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_COPY));
        Hyperlink copyHyperlink = this.toolkit.createHyperlink(sectionClient, Messages.ContextEditorFormPage_Copy_Context_to_, 0);
        copyHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                CopyContextHandler.run((ITask)ContextEditorFormPage.this.task);
            }
        });
        Label clearImage = this.toolkit.createLabel(sectionClient, "");
        clearImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_CLEAR));
        Hyperlink clearHyperlink = this.toolkit.createHyperlink(sectionClient, Messages.ContextEditorFormPage_RemoveAll, 0);
        clearHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ClearContextHandler.run((ITask)ContextEditorFormPage.this.task);
            }
        });
        section.setExpanded(true);
    }

    protected void updateFilterThreshold() {
        if (this.doiScale.getSelection() == 0) {
            this.interestFilter.setThreshold(-2.147483648E9);
        } else if (this.doiScale.getSelection() == 14) {
            this.interestFilter.setThreshold(2.147483647E9);
        } else {
            double setting = this.doiScale.getSelection() - 7;
            double threshold = Math.signum(setting) * Math.pow(Math.exp(Math.abs(setting)), 1.5);
            this.interestFilter.setThreshold(threshold);
        }
        this.refresh();
    }

    private void refresh() {
        this.createRefreshJob();
        if (this.refreshJob != null) {
            this.refreshJob.refresh();
        }
    }

    private synchronized void createRefreshJob() {
        if (this.commonViewer == null) {
            return;
        }
        if (this.refreshJob == null) {
            this.refreshJob = new ContextEditorDelayedRefreshJob((StructuredViewer)this.commonViewer, "refresh viewer");
        }
    }

    private void refresh(List<IInteractionElement> elements) {
        this.createRefreshJob();
        if (this.refreshJob != null) {
            this.refreshJob.refreshElements(elements.toArray());
        }
    }

    private void createContentSection(Composite composite) {
        Section section = this.toolkit.createSection(composite, 320);
        section.setText(Messages.ContextEditorFormPage_Elements);
        section.setLayoutData((Object)new GridData(1808));
        this.sectionClient = this.toolkit.createComposite((Composite)section);
        this.sectionClient.setLayout((Layout)new FillLayout());
        section.setClient((Control)this.sectionClient);
        this.createToolBar(section);
        this.doiScale.setEnabled(true);
        this.doiScale.setSelection(7);
        if (this.commonViewer == null) {
            this.createViewer(this.sectionClient);
        }
        if (this.invisiblePart != null) {
            this.invisiblePart.setCommonViewer(this.commonViewer);
        }
        this.updateFilterThreshold();
        this.sectionClient.layout();
        this.toolkit.createLabel(composite, "  ");
        this.invisiblePart = new InvisibleContextElementsPart(this.commonViewer, this.context);
        Control invisibleControl = this.invisiblePart.createControl(this.toolkit, composite);
        GridDataFactory.fillDefaults().applyTo(invisibleControl);
    }

    private void createToolBar(Section section) {
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setBackground(null);
        section.setTextClient((Control)composite);
        ToolBarManager manager = new ToolBarManager(0x800000);
        manager.add((IAction)new Action(Messages.ContextEditorFormPage_Collapse_All, CommonImages.COLLAPSE_ALL_SMALL){

            public void run() {
                if (ContextEditorFormPage.this.commonViewer != null && ContextEditorFormPage.this.commonViewer.getTree() != null && !ContextEditorFormPage.this.commonViewer.getTree().isDisposed()) {
                    ContextEditorFormPage.this.commonViewer.collapseAll();
                }
            }
        });
        manager.add((IAction)new Action(Messages.ContextEditorFormPage_Expand_All, CommonImages.EXPAND_ALL_SMALL){

            public void run() {
                if (ContextEditorFormPage.this.commonViewer != null && ContextEditorFormPage.this.commonViewer.getTree() != null && !ContextEditorFormPage.this.commonViewer.getTree().isDisposed()) {
                    ContextEditorFormPage.this.commonViewer.expandAll();
                }
            }
        });
        manager.createControl(composite);
    }

    private synchronized void disposeRefreshJob() {
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
            this.refreshJob = null;
        }
    }

    private boolean isActiveTask() {
        return this.task.equals(TasksUi.getTaskActivityManager().getActiveTask());
    }

    private void createViewer(Composite parent) {
        this.commonViewer = new CommonViewer(ID_VIEWER, parent, 770);
        this.commonViewer.setUseHashlookup(true);
        this.interestFilter = new ScalableInterestFilter(this.context);
        this.commonViewer.addFilter((ViewerFilter)this.interestFilter);
        this.commonViewer.addOpenListener((IOpenListener)new ContextNodeOpenListener(this.commonViewer, (IInteractionContext)this.context));
        try {
            this.commonViewer.getControl().setRedraw(false);
            ContextUiPlugin.forceFlatLayoutOfJavaContent((CommonViewer)this.commonViewer);
            this.commonViewer.setInput((Object)this.getSite().getPage().getInput());
            this.hookContextMenu();
            this.commonViewer.expandAll();
        }
        finally {
            this.commonViewer.getControl().setRedraw(true);
        }
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu"){
            private final IMenuListener listener;
            {
                this.listener = new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        ContextEditorFormPage.this.fillContextMenu(manager);
                    }
                };
                this.addMenuListener(this.listener);
            }

            public void addMenuListener(IMenuListener listener) {
                super.removeMenuListener(this.listener);
                super.addMenuListener(listener);
                super.addMenuListener(this.listener);
            }
        };
        Menu menu = menuManager.createContextMenu(this.commonViewer.getControl());
        this.commonViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.commonViewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public ISelection getSelection() {
        if (this.getSite() != null && this.getSite().getSelectionProvider() != null) {
            return this.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    private class ContextEditorDelayedRefreshJob
    extends DelayedRefreshJob {
        public ContextEditorDelayedRefreshJob(StructuredViewer treeViewer, String name) {
            super(treeViewer, name);
        }

        protected void doRefresh(Object[] items) {
            if (ContextEditorFormPage.this.commonViewer != null && !ContextEditorFormPage.this.commonViewer.getTree().isDisposed()) {
                ContextEditorFormPage.this.commonViewer.refresh();
                if (items != null) {
                    Object[] objectArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        this.updateExpansionState(item);
                        ++n2;
                    }
                } else {
                    this.updateExpansionState(null);
                }
            }
            if (ContextEditorFormPage.this.invisiblePart != null) {
                ContextEditorFormPage.this.invisiblePart.updateInvisibleElementsSection();
            }
        }

        protected void updateExpansionState(Object item) {
            if (ContextEditorFormPage.this.commonViewer != null && !ContextEditorFormPage.this.commonViewer.getTree().isDisposed()) {
                try {
                    ContextEditorFormPage.this.commonViewer.getTree().setRedraw(false);
                    if (item == null) {
                        ContextEditorFormPage.this.commonViewer.expandAll();
                    } else if (item != null && item instanceof IInteractionElement) {
                        IInteractionElement node = (IInteractionElement)item;
                        AbstractContextStructureBridge structureBridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
                        Object objectToRefresh = structureBridge.getObjectForHandle(node.getHandleIdentifier());
                        if (objectToRefresh != null) {
                            ContextEditorFormPage.this.commonViewer.expandToLevel(objectToRefresh, -1);
                        }
                    }
                }
                finally {
                    ContextEditorFormPage.this.commonViewer.getTree().setRedraw(true);
                }
            }
        }
    }
}

