/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.conversion;

import java.util.HashMap;
import java.util.Map;
import org.mvel2.ConversionHandler;
import org.mvel2.conversion.Converter;

public class StringArrayCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    static {
        CNV.put(Object[].class, new Converter(){

            public Object convert(Object o) {
                Object[] old = (Object[])o;
                String[] n = new String[old.length];
                int i = 0;
                while (i < old.length) {
                    n[i] = String.valueOf(old[i]);
                    ++i;
                }
                return n;
            }
        });
    }

    public Object convertFrom(Object in) {
        if (in.getClass().isArray()) {
            Object[] old = (Object[])in;
            String[] n = new String[old.length];
            int i = 0;
            while (i < old.length) {
                n[i] = String.valueOf(old[i]);
                ++i;
            }
            return n;
        }
        return new String[]{String.valueOf(in)};
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }
}

