/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.mvel2.ConversionHandler;
import org.mvel2.conversion.BigDecimalCH;
import org.mvel2.conversion.BigIntegerCH;
import org.mvel2.conversion.BooleanCH;
import org.mvel2.conversion.ByteCH;
import org.mvel2.conversion.CharArrayCH;
import org.mvel2.conversion.CharCH;
import org.mvel2.conversion.DoubleCH;
import org.mvel2.conversion.FloatCH;
import org.mvel2.conversion.IntArrayCH;
import org.mvel2.conversion.IntegerCH;
import org.mvel2.conversion.ListCH;
import org.mvel2.conversion.LongCH;
import org.mvel2.conversion.ObjectCH;
import org.mvel2.conversion.PrimArrayHandler;
import org.mvel2.conversion.SetCH;
import org.mvel2.conversion.ShortCH;
import org.mvel2.conversion.StringArrayCH;
import org.mvel2.conversion.StringCH;
import org.mvel2.util.FastList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataConversion {
    private static final Map<Class, ConversionHandler> CONVERTERS = new HashMap<Class, ConversionHandler>(76, 0.5f);

    static {
        ConversionHandler ch = new IntegerCH();
        CONVERTERS.put(Integer.class, ch);
        CONVERTERS.put(Integer.TYPE, ch);
        ch = new ShortCH();
        CONVERTERS.put(Short.class, ch);
        CONVERTERS.put(Short.TYPE, ch);
        ch = new LongCH();
        CONVERTERS.put(Long.class, ch);
        CONVERTERS.put(Long.TYPE, ch);
        ch = new CharCH();
        CONVERTERS.put(Character.class, ch);
        CONVERTERS.put(Character.TYPE, ch);
        ch = new ByteCH();
        CONVERTERS.put(Byte.class, ch);
        CONVERTERS.put(Byte.TYPE, ch);
        ch = new FloatCH();
        CONVERTERS.put(Float.class, ch);
        CONVERTERS.put(Float.TYPE, ch);
        ch = new DoubleCH();
        CONVERTERS.put(Double.class, ch);
        CONVERTERS.put(Double.TYPE, ch);
        ch = new BooleanCH();
        CONVERTERS.put(Boolean.class, ch);
        CONVERTERS.put(Boolean.TYPE, ch);
        CONVERTERS.put(String.class, new StringCH());
        CONVERTERS.put(Object.class, new ObjectCH());
        ch = new CharArrayCH();
        CONVERTERS.put(char[].class, ch);
        CONVERTERS.put(Character[].class, ch);
        CONVERTERS.put(String[].class, new StringArrayCH());
        CONVERTERS.put(Integer[].class, new IntArrayCH());
        CONVERTERS.put(int[].class, new PrimArrayHandler(int[].class));
        CONVERTERS.put(long[].class, new PrimArrayHandler(long[].class));
        CONVERTERS.put(double[].class, new PrimArrayHandler(double[].class));
        CONVERTERS.put(float[].class, new PrimArrayHandler(float[].class));
        CONVERTERS.put(short[].class, new PrimArrayHandler(short[].class));
        CONVERTERS.put(boolean[].class, new PrimArrayHandler(boolean[].class));
        CONVERTERS.put(BigDecimal.class, new BigDecimalCH());
        CONVERTERS.put(BigInteger.class, new BigIntegerCH());
        ch = new ListCH();
        CONVERTERS.put(List.class, ch);
        CONVERTERS.put(FastList.class, ch);
        CONVERTERS.put(ArrayList.class, ch);
        CONVERTERS.put(LinkedList.class, ch);
        ch = new SetCH();
        CONVERTERS.put(Set.class, ch);
        CONVERTERS.put(HashSet.class, ch);
        CONVERTERS.put(LinkedHashSet.class, ch);
        CONVERTERS.put(TreeSet.class, ch);
    }

    public static boolean canConvert(Class toType, Class convertFrom) {
        return CONVERTERS.containsKey(toType) && CONVERTERS.get(toType).canConvertFrom(convertFrom) || toType.isAssignableFrom(convertFrom);
    }

    public static <T> T convert(Object in, Class<T> toType) {
        if (in == null) {
            return null;
        }
        if (toType == in.getClass() || toType.isAssignableFrom(in.getClass())) {
            return (T)in;
        }
        return (T)CONVERTERS.get(toType).convertFrom(in);
    }

    public static void addConversionHandler(Class type, ConversionHandler handler) {
        CONVERTERS.put(type, handler);
    }
}

