/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.os.linux;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wb.os.linux";
    private static Activator m_plugin;
    private static final Map<String, Image> m_nameToIconMap;

    static {
        m_nameToIconMap = Maps.newHashMap();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        m_plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        m_plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return m_plugin;
    }

    public static InputStream getFile(String path) {
        try {
            URL url = new URL(Activator.getInstallURL(), path);
            return url.openStream();
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
    }

    public static URL getInstallURL() {
        return Activator.getInstallUrl((Plugin)Activator.getDefault());
    }

    private static URL getInstallUrl(Plugin plugin) {
        return plugin.getBundle().getEntry("/");
    }

    public static Image getImage(String path) {
        Image image = m_nameToIconMap.get(path);
        if (image == null) {
            InputStream is = Activator.getFile("icons/" + path);
            try {
                image = new Image((Device)Display.getCurrent(), is);
                m_nameToIconMap.put(path, image);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return image;
    }
}

