/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRoot;
import org.eclipse.wst.common.componentcore.internal.impl.WorkbenchComponentImpl;
import org.eclipse.wst.common.componentcore.internal.resources.ResourceTimestampMappings;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public abstract class VirtualResource
implements IVirtualResource {
    protected static final IResource[] NO_RESOURCES = null;
    private final IProject componentProject;
    private final IPath runtimePath;
    private int hashCode;
    private String toString;
    private static final String EMPTY_STRING = "";
    private IVirtualComponent component;
    private String resourceType;
    private final ResourceTimestampMappings mapping = new ResourceTimestampMappings();

    protected VirtualResource(IProject aComponentProject, IPath aRuntimePath) {
        this.componentProject = aComponentProject;
        this.runtimePath = aRuntimePath;
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        if ((updateFlags & 0x400) == 0) {
            this.doDeleteRealResources(updateFlags, monitor);
        }
        this.doDeleteMetaModel(updateFlags, monitor);
    }

    protected void doDeleteMetaModel(int updateFlags, IProgressMonitor monitor) {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent aComponent = moduleCore.getComponent();
            ComponentResource[] resources = aComponent.findResourcesByRuntimePath(this.getRuntimePath());
            aComponent.getResources().removeAll(Arrays.asList(resources));
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(monitor);
                moduleCore.dispose();
            }
        }
    }

    protected abstract void doDeleteRealResources(int var1, IProgressMonitor var2) throws CoreException;

    public boolean exists() {
        IResource[] resources = this.getUnderlyingResources();
        if (resources == null || resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] == null || !resources[i].exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getFileExtension() {
        String name = this.getName();
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        if (dot == name.length() - 1) {
            return EMPTY_STRING;
        }
        return name.substring(dot + 1);
    }

    public IPath getWorkspaceRelativePath() {
        return this.getProject().getFullPath().append(this.getProjectRelativePath());
    }

    public IPath getRuntimePath() {
        return this.runtimePath;
    }

    public IPath[] getProjectRelativePaths() {
        WorkbenchComponent aComponent = this.getReadOnlyComponent();
        if (aComponent != null) {
            ResourceTreeRoot root = ResourceTreeRoot.getDeployResourceTreeRoot(aComponent);
            ComponentResource[] componentResources = null;
            if (root != null) {
                IPath defaultSrcRoot;
                IPath[] estimatedPaths = null;
                IPath searchPath = null;
                do {
                    IPath iPath = searchPath = searchPath == null ? this.getRuntimePath() : searchPath.removeLastSegments(1);
                    if (!searchPath.isAbsolute()) continue;
                    searchPath = searchPath.makeRelative();
                } while ((estimatedPaths = this.findBestMatches(componentResources = root.findModuleResources(searchPath, 0), defaultSrcRoot = ((WorkbenchComponentImpl)aComponent).getDefaultSourceRoot())).length == 0 && this.canSearchContinue(componentResources, searchPath));
                if (estimatedPaths == null || estimatedPaths.length == 0) {
                    return new IPath[]{this.getRuntimePath()};
                }
                return estimatedPaths;
            }
        }
        return new IPath[]{this.getRuntimePath()};
    }

    public IPath getProjectRelativePath() {
        WorkbenchComponent aComponent;
        if (this.getRuntimePath().equals((Object)new Path("/")) && (aComponent = this.getReadOnlyComponent()) != null && ((WorkbenchComponentImpl)aComponent).getDefaultSourceRoot() != null) {
            return ((WorkbenchComponentImpl)aComponent).getDefaultSourceRoot();
        }
        return this.getProjectRelativePaths()[0];
    }

    private boolean canSearchContinue(ComponentResource[] componentResources, IPath searchPath) {
        return searchPath.segmentCount() > 0;
    }

    private IPath[] findBestMatches(ComponentResource[] theComponentResources, IPath defaultRoot) {
        ArrayList<IPath> result = new ArrayList<IPath>();
        int currentMatchLength = 0;
        int bestMatchLength = -1;
        IPath estimatedPath = null;
        IPath currentPath = null;
        IPath aRuntimePath = this.getRuntimePath();
        int i = 0;
        while (i < theComponentResources.length) {
            currentPath = theComponentResources[i].getRuntimePath();
            if (currentPath.isPrefixOf(aRuntimePath)) {
                if (currentPath.segmentCount() == aRuntimePath.segmentCount()) {
                    result.add(theComponentResources[i].getSourcePath());
                } else {
                    IPath subpath;
                    IPath sourcePath;
                    currentMatchLength = currentPath.matchingFirstSegments(aRuntimePath);
                    if (currentMatchLength == currentPath.segmentCount() && currentMatchLength > bestMatchLength) {
                        bestMatchLength = currentMatchLength;
                        sourcePath = theComponentResources[i].getSourcePath();
                        subpath = aRuntimePath.removeFirstSegments(currentMatchLength);
                        estimatedPath = sourcePath.append(subpath);
                    } else if (currentMatchLength == currentPath.segmentCount() && currentMatchLength == bestMatchLength) {
                        bestMatchLength = currentMatchLength;
                        sourcePath = theComponentResources[i].getSourcePath();
                        subpath = aRuntimePath.removeFirstSegments(currentMatchLength);
                        if (sourcePath.equals((Object)defaultRoot)) {
                            estimatedPath = sourcePath.append(subpath);
                        }
                    }
                }
            }
            ++i;
        }
        if (result.size() > 0) {
            return result.toArray(new IPath[result.size()]);
        }
        if (estimatedPath == null) {
            return new IPath[0];
        }
        return new IPath[]{estimatedPath};
    }

    public String getName() {
        if (this.getRuntimePath().segmentCount() > 0) {
            return this.getRuntimePath().lastSegment();
        }
        return this.getRuntimePath().toString();
    }

    public IVirtualComponent getComponent() {
        if (this.component == null) {
            this.component = ComponentCore.createComponent(this.getProject());
        }
        return this.component;
    }

    public IVirtualContainer getParent() {
        if (this.getRuntimePath().segmentCount() >= 1) {
            return ComponentCore.createFolder(this.getProject(), this.getRuntimePath().removeLastSegments(1));
        }
        return null;
    }

    public IProject getProject() {
        return this.componentProject;
    }

    public boolean isAccessible() {
        throw new UnsupportedOperationException("Method not supported");
    }

    public Object getAdapter(Class adapter) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public boolean contains(ISchedulingRule rule) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public boolean isConflicting(ISchedulingRule rule) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "[" + ModuleURIUtil.getHandleString(this.getComponent()) + ":" + this.getRuntimePath() + "]";
        }
        return this.toString;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object anOther) {
        return this.hashCode() == (anOther != null && anOther instanceof VirtualResource ? anOther.hashCode() : 0);
    }

    public void setResourceType(String aResourceType) {
        this.resourceType = aResourceType;
        WorkbenchComponent aComponent = this.getReadOnlyComponent();
        ComponentResource[] resources = aComponent.findResourcesByRuntimePath(this.getRuntimePath());
        int i = 0;
        while (i < resources.length) {
            resources[i].setResourceType(aResourceType);
            ++i;
        }
    }

    public String getResourceType() {
        WorkbenchComponent aComponent;
        ComponentResource[] resources;
        int i;
        if (this.resourceType == null && (i = 0) < (resources = (aComponent = this.getReadOnlyComponent()).findResourcesByRuntimePath(this.getRuntimePath())).length) {
            this.resourceType = resources[i].getResourceType();
            return this.resourceType;
        }
        this.resourceType = EMPTY_STRING;
        return this.resourceType;
    }

    protected void createResource(IContainer resource, int updateFlags, IProgressMonitor monitor) throws CoreException {
        if (resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            this.createResource(resource.getParent(), updateFlags, monitor);
        }
        if (!resource.exists() && resource.getType() == 2) {
            ((IFolder)resource).create(updateFlags, true, monitor);
        }
    }

    protected boolean isPotentalMatch(IPath aRuntimePath) {
        return aRuntimePath.isPrefixOf(this.getRuntimePath());
    }

    public void removeLink(IPath aProjectRelativeLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            ResourceTreeRoot root;
            ComponentResource[] resources;
            WorkbenchComponent component;
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            if (moduleCore != null && (component = moduleCore.getComponent()) != null && (resources = (root = ResourceTreeRoot.getDeployResourceTreeRoot(component)).findModuleResources(this.getRuntimePath(), 0)).length > 0) {
                int resourceIndx = 0;
                while (resourceIndx < resources.length) {
                    if (aProjectRelativeLocation.makeAbsolute().equals((Object)resources[resourceIndx].getSourcePath())) {
                        component.getResources().remove((Object)resources[resourceIndx]);
                    }
                    ++resourceIndx;
                }
            }
        }
        finally {
            if (moduleCore != null) {
                if (this.getComponent() != null) {
                    moduleCore.saveIfNecessary(monitor);
                }
                moduleCore.dispose();
            }
        }
    }

    protected final WorkbenchComponent getReadOnlyComponent() {
        if (!this.mapping.hasChanged((IResource)this.getProject()) && this.mapping.hasCacheData((IResource)this.getProject())) {
            return (WorkbenchComponent)this.mapping.getData((IResource)this.getProject());
        }
        StructureEdit moduleCore = null;
        WorkbenchComponent component = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead(this.getProject());
            if (moduleCore != null) {
                component = moduleCore.getComponent();
                this.mapping.mark((IResource)this.getProject(), component);
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
            }
        }
        return component;
    }
}

