/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.view.task.TaskView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.ui.PlatformUI;

public final class WorkspaceProjectsChangeListener
implements IResourceChangeListener {
    private final TaskView taskView;

    public WorkspaceProjectsChangeListener(TaskView taskView) {
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            this.handleChangeRecursively(event.getDelta());
        }
    }

    private void handleChangeRecursively(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource instanceof IProject) {
            int kind = delta.getKind();
            if (kind == 1) {
                this.notifyAboutProjectAddition((IProject)resource);
                return;
            }
            if (kind == 2) {
                this.notifyAboutProjectRemoval((IProject)resource);
                return;
            }
        }
        for (IResourceDelta child : delta.getAffectedChildren()) {
            this.handleChangeRecursively(child);
        }
    }

    private void notifyAboutProjectAddition(final IProject project) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WorkspaceProjectsChangeListener.this.taskView.handleProjectAddition(project);
            }
        });
    }

    private void notifyAboutProjectRemoval(final IProject project) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WorkspaceProjectsChangeListener.this.taskView.handleProjectRemoval(project);
            }
        });
    }
}

