/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.util.editor.EditorUtils;
import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class OpenTestSourceFileJob
extends Job {
    private final ImmutableList<OperationItem> operationItems;

    public OpenTestSourceFileJob(List<OperationItem> operationItems) {
        super("Opening test source files");
        this.operationItems = ImmutableList.copyOf(operationItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.operationItems.size());
        try {
            for (OperationItem operationItem : this.operationItems) {
                if (monitor.isCanceled()) {
                    Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                    Status status = new Status(8, bundle.getSymbolicName(), 8, "Opening test source files was canceled.", null);
                    return status;
                }
                this.searchForTestSource(operationItem, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void searchForTestSource(OperationItem operationItem, IProgressMonitor monitor) {
        JvmTestOperationDescriptor testOperationDescriptor;
        String className;
        OperationDescriptor operationDescriptor = (OperationDescriptor)operationItem.getAdapter(OperationDescriptor.class);
        if (operationDescriptor instanceof JvmTestOperationDescriptor && (className = (testOperationDescriptor = (JvmTestOperationDescriptor)operationDescriptor).getClassName()) != null) {
            String methodName = testOperationDescriptor.getMethodName();
            this.searchForTestSource(className, methodName, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForTestSource(String className, String methodName, IProgressMonitor monitor) {
        monitor.setTaskName(String.format("Open test source file for class %s.", className));
        try {
            SearchEngine searchEngine = new SearchEngine();
            SearchPattern pattern = SearchPattern.createPattern((String)className, (int)0, (int)0, (int)0);
            ShowTestSourceFileSearchRequester requester = new ShowTestSourceFileSearchRequester(methodName);
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), (SearchRequestor)requester, monitor);
            if (!requester.isFoundJavaTestSourceFile()) {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                workspaceRoot.accept((IResourceVisitor)new ShowTestSourceFileResourceVisitor(methodName, className, (List)ImmutableList.of((Object)"groovy")));
            }
        }
        catch (CoreException e) {
            UiPlugin.logger().error(e.getMessage(), (Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    private static final class ShowTestSourceFileResourceVisitor
    implements IResourceVisitor {
        private static final String BIN_FOLDER_NAME = "bin";
        private final String methodName;
        private final String className;
        private final ImmutableList<String> fileExtensions;

        private ShowTestSourceFileResourceVisitor(String methodName, String className, List<String> fileExtensions) {
            this.methodName = methodName;
            this.className = (String)Preconditions.checkNotNull((Object)className);
            this.fileExtensions = ImmutableList.copyOf(fileExtensions);
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() != 1 || !this.fileExtensions.contains((Object)resource.getFileExtension())) {
                return true;
            }
            String classNameToPath = this.className.replaceAll(Pattern.quote("."), "/");
            String projectRelativePath = resource.getProjectRelativePath().toString();
            if (projectRelativePath.startsWith(BIN_FOLDER_NAME) || !projectRelativePath.contains(classNameToPath)) {
                return true;
            }
            final IFile file = (IFile)resource.getAdapter(IFile.class);
            if (file == null) {
                return true;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IEditorPart editor = EditorUtils.openInInternalEditor(file, true);
                    IRegion region = ShowTestSourceFileResourceVisitor.this.getClassOrMethodRegion(file);
                    if (region != null) {
                        EditorUtils.selectAndReveal(region.getOffset(), region.getLength(), editor, file);
                    }
                }
            });
            return false;
        }

        private IRegion getClassOrMethodRegion(IFile file) {
            if (this.methodName == null) {
                try {
                    FindReplaceDocumentAdapter documentAdapter = this.createFindReplaceDocumentAdapter(file);
                    return this.find(documentAdapter, Files.getNameWithoutExtension((String)file.getName()));
                }
                catch (Exception e) {
                    return null;
                }
            }
            try {
                FindReplaceDocumentAdapter documentAdapter = this.createFindReplaceDocumentAdapter(file);
                IRegion region = this.find(documentAdapter, this.methodName);
                if (region == null) {
                    documentAdapter = this.createFindReplaceDocumentAdapter(file);
                    return this.find(documentAdapter, Files.getNameWithoutExtension((String)file.getName()));
                }
                return region;
            }
            catch (Exception e) {
                return null;
            }
        }

        private FindReplaceDocumentAdapter createFindReplaceDocumentAdapter(IFile file) throws CoreException {
            TextFileDocumentProvider textFileDocumentProvider = new TextFileDocumentProvider();
            textFileDocumentProvider.connect((Object)file);
            IDocument document = textFileDocumentProvider.getDocument((Object)file);
            return new FindReplaceDocumentAdapter(document);
        }

        private IRegion find(FindReplaceDocumentAdapter findReplaceDocumentAdapter, String findString) throws BadLocationException {
            return findReplaceDocumentAdapter.find(0, findString, true, true, false, false);
        }
    }

    private final class ShowTestSourceFileSearchRequester
    extends SearchRequestor {
        private final String methodName;
        private final AtomicBoolean foundJavaTestSourceFile;

        private ShowTestSourceFileSearchRequester(String methodName) {
            this.methodName = methodName;
            this.foundJavaTestSourceFile = new AtomicBoolean(false);
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getElement() instanceof IType) {
                this.foundJavaTestSourceFile.set(true);
                IType classElement = (IType)match.getElement();
                IJavaElement methodElement = this.findMethod(this.methodName, classElement);
                this.openInEditor((IJavaElement)(methodElement != null ? methodElement : classElement));
            }
        }

        private IJavaElement findMethod(String methodName, IType type) {
            IStatus status = JavaConventionsUtil.validateMethodName((String)methodName, (IJavaElement)type);
            if (!status.isOK()) {
                return null;
            }
            IMethod method = type.getMethod(methodName, new String[0]);
            if (method != null && method.exists()) {
                return method;
            }
            try {
                for (IMethod methodItem : type.getMethods()) {
                    if (!methodItem.getElementName().equals(methodName)) continue;
                    return methodItem;
                }
                return null;
            }
            catch (JavaModelException e) {
                return null;
            }
        }

        private void openInEditor(final IJavaElement javaElement) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaUI.openInEditor((IJavaElement)javaElement);
                    }
                    catch (Exception e) {
                        String message = String.format("Cannot open Java element %s in editor.", javaElement);
                        UiPlugin.logger().error(message, (Throwable)e);
                    }
                }
            });
        }

        private boolean isFoundJavaTestSourceFile() {
            return this.foundJavaTestSourceFile.get();
        }
    }
}

