/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.databinding.observable;

import com.google.common.base.Preconditions;
import java.io.File;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public final class ProjectLocationComputedValue
extends ComputedValue {
    private final IObservableValue projectName;
    private final IObservableValue useDefaultLocation;
    private final IObservableValue alternativeLocation;

    public ProjectLocationComputedValue(IObservableValue projectName, IObservableValue useDefaultLocation, IObservableValue alternativeLocation) {
        this.projectName = (IObservableValue)Preconditions.checkNotNull((Object)projectName);
        this.useDefaultLocation = (IObservableValue)Preconditions.checkNotNull((Object)useDefaultLocation);
        this.alternativeLocation = (IObservableValue)Preconditions.checkNotNull((Object)alternativeLocation);
    }

    protected Object calculate() {
        if (((Boolean)this.useDefaultLocation.getValue()).booleanValue()) {
            IPath location = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            return new File(location.toOSString(), (String)this.projectName.getValue());
        }
        return new File((String)this.alternativeLocation.getValue(), (String)this.projectName.getValue());
    }
}

