/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.validation;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupEditor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.ResourceMarkerMarkupValidator;
import org.eclipse.mylyn.internal.wikitext.ui.validation.Messages;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.osgi.util.NLS;

public class ValidationProjectBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.mylyn.wikitext.ui.wikiTextValidationBuilder";
    private static final IProject[] NO_PROJECTS = new IProject[0];
    private static int CHECK_ANCESTORS;
    private static Method RESOURCE_DERIVED_WITH_FLAGS_METHOD;

    static {
        try {
            CHECK_ANCESTORS = (Integer)IResource.class.getDeclaredField("CHECK_ANCESTORS").get(null);
        }
        catch (Exception exception) {
            CHECK_ANCESTORS = 0;
        }
        try {
            RESOURCE_DERIVED_WITH_FLAGS_METHOD = IResource.class.getDeclaredMethod("isDerived", Integer.TYPE);
        }
        catch (Exception exception) {
            RESOURCE_DERIVED_WITH_FLAGS_METHOD = null;
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().deleteMarkers("org.eclipse.mylyn.wikitext.core.validation.problem", true, 2);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        IResourceDelta resourceDelta = this.getDelta(project);
        List<ValidationInfo> files = null;
        files = kind != 10 && kind != 9 || resourceDelta == null ? this.collect(project, monitor) : this.collect(resourceDelta, monitor);
        if (!(files == null || files.isEmpty() || this.isInterrupted() || monitor.isCanceled())) {
            this.validate(files, monitor);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return NO_PROJECTS;
    }

    private List<ValidationInfo> collect(IResourceDelta resourceDelta, final IProgressMonitor monitor) throws CoreException {
        final ArrayList<ValidationInfo> files = new ArrayList<ValidationInfo>();
        resourceDelta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (ValidationProjectBuilder.this.isInterrupted()) {
                    return false;
                }
                IResource resource = delta.getResource();
                if (resource instanceof IFile) {
                    if ((delta.getKind() & 5) != 0) {
                        IFile file = (IFile)resource;
                        ValidationProjectBuilder.this.visit(files, file);
                    }
                } else if (resource instanceof IContainer && ValidationProjectBuilder.this.filtered((IContainer)resource)) {
                    return false;
                }
                return true;
            }
        });
        return files;
    }

    private List<ValidationInfo> collect(IProject project, final IProgressMonitor monitor) throws CoreException {
        final ArrayList<ValidationInfo> files = new ArrayList<ValidationInfo>();
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (ValidationProjectBuilder.this.isInterrupted()) {
                    return false;
                }
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    ValidationProjectBuilder.this.visit(files, file);
                } else if (resource instanceof IContainer && ValidationProjectBuilder.this.filtered((IContainer)resource)) {
                    return false;
                }
                return true;
            }
        });
        return files;
    }

    private boolean filtered(IContainer container) {
        return false;
    }

    private void visit(List<ValidationInfo> files, IFile file) {
        boolean derived = false;
        if (RESOURCE_DERIVED_WITH_FLAGS_METHOD != null) {
            try {
                derived = (Boolean)RESOURCE_DERIVED_WITH_FLAGS_METHOD.invoke((Object)file, CHECK_ANCESTORS);
            }
            catch (Exception exception) {
                derived = file.isDerived();
            }
        } else {
            derived = file.isDerived();
        }
        if (derived) {
            return;
        }
        String language = this.getMarkupLanguageForFile(file);
        if (language != null) {
            files.add(new ValidationInfo(file, language));
        }
    }

    private void validate(List<ValidationInfo> files, IProgressMonitor monitor) throws CoreException {
        if (files.isEmpty()) {
            return;
        }
        monitor.beginTask(Messages.ValidationProjectBuilder_validationTask, files.size() * 1000);
        for (ValidationInfo file : files) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.isInterrupted()) break;
            this.validate(file, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        monitor.done();
    }

    private void validate(ValidationInfo file, IProgressMonitor monitor) throws CoreException {
        int totalWork = 1000;
        monitor.beginTask(NLS.bind((String)Messages.ValidationProjectBuilder_validatingFileTask, (Object[])new Object[]{file.file.getName()}), totalWork);
        ResourceMarkerMarkupValidator validator = new ResourceMarkerMarkupValidator();
        validator.setMarkupLanguage(WikiText.getMarkupLanguage(file.languageName));
        validator.setResource((IResource)file.file);
        if (validator.getMarkupLanguage() != null) {
            StringWriter writer = new StringWriter();
            String charset = file.file.getCharset();
            try (InputStreamReader reader = charset == null ? new InputStreamReader(new BufferedInputStream(file.file.getContents())) : new InputStreamReader((InputStream)new BufferedInputStream(file.file.getContents()), charset);){
                int c;
                while ((c = ((Reader)reader).read()) != -1) {
                    writer.append((char)c);
                }
            }
            catch (IOException ioe) {
                throw new CoreException(WikiTextUiPlugin.getDefault().createStatus(4, ioe));
            }
            monitor.worked(totalWork / 2);
            Document document = new Document(writer.toString());
            validator.validate((IProgressMonitor)new SubProgressMonitor(monitor, totalWork / 2), (IDocument)document, (IRegion)new Region(0, document.getLength()));
        }
        monitor.done();
    }

    private String getMarkupLanguageForFile(IFile file) {
        String language = MarkupEditor.getMarkupLanguagePreference(file);
        if (language == null) {
            language = WikiText.getMarkupLanguageNameForFilename(file.getName());
        }
        return language;
    }

    private static class ValidationInfo {
        private final IFile file;
        private final String languageName;

        public ValidationInfo(IFile file, String languageName) {
            this.file = file;
            this.languageName = languageName;
        }
    }
}

