/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.layout.GeneralLayoutData;
import org.eclipse.wb.internal.core.model.util.grid.GridConvertionHelper;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigLayoutConverter {
    private MigLayoutConverter() {
    }

    public static void convert(ContainerInfo parent, MigLayoutInfo layout) throws Exception {
        List columns = GridConvertionHelper.buildGroups((List)parent.getChildrenComponents(), (boolean)true);
        List rows = GridConvertionHelper.buildGroups((List)parent.getChildrenComponents(), (boolean)false);
        GridConvertionHelper.sortGroupsByTranspose((List)columns, (List)rows);
        GridConvertionHelper.sortGroupsByTranspose((List)rows, (List)columns);
        GridConvertionHelper.sortGroups((List)columns);
        GridConvertionHelper.sortGroups((List)rows);
        GridConvertionHelper.updateBoundsGaps((List)columns, (boolean)true);
        GridConvertionHelper.updateBoundsGaps((List)rows, (boolean)true);
        MigLayoutConverter.createDimensions(layout, columns, true);
        MigLayoutConverter.createDimensions(layout, rows, false);
        Set componentsInGroups = Sets.newHashSet();
        for (GridConvertionHelper.ComponentGroup column : columns) {
            for (GridConvertionHelper.ComponentInGroup componentInGroup : column.getComponents()) {
                componentsInGroups.add(componentInGroup);
            }
        }
        for (GridConvertionHelper.ComponentInGroup componentInGroup : componentsInGroups) {
            ComponentInfo component = (ComponentInfo)componentInGroup.getComponent();
            GeneralLayoutData generalLayoutData = GeneralLayoutData.getFromInfoEx((ObjectInfo)component);
            CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
            GridConvertionHelper.ComponentGroup beginColumn = GridConvertionHelper.getBeginForComponent((List)columns, (GridConvertionHelper.ComponentInGroup)componentInGroup);
            GridConvertionHelper.ComponentGroup endColumn = GridConvertionHelper.getEndForComponent((List)columns, (GridConvertionHelper.ComponentInGroup)componentInGroup);
            GridConvertionHelper.ComponentGroup beginRow = GridConvertionHelper.getBeginForComponent((List)rows, (GridConvertionHelper.ComponentInGroup)componentInGroup);
            GridConvertionHelper.ComponentGroup endRow = GridConvertionHelper.getEndForComponent((List)rows, (GridConvertionHelper.ComponentInGroup)componentInGroup);
            int x = columns.indexOf(beginColumn);
            int y = rows.indexOf(beginRow);
            int sx = 1 + columns.indexOf(endColumn) - x;
            int sy = 1 + rows.indexOf(endRow) - y;
            constraints.setX(x);
            constraints.setY(y);
            constraints.setWidth(sx);
            constraints.setHeight(sy);
            constraints.setHorizontalAlignment(MigLayoutConverter.getHorizontalAlignment(columns, componentInGroup, generalLayoutData));
            constraints.setVerticalAlignment(MigLayoutConverter.getVerticalAlignment(rows, componentInGroup, generalLayoutData));
            constraints.write();
        }
        layout.setObject(new MigLayout());
        layout.writeDimensions();
        int i = columns.size() - 1;
        while (i >= 0) {
            if (((GridConvertionHelper.ComponentGroup)columns.get(i)).getComponents().isEmpty()) {
                layout.deleteColumn(i);
            }
            --i;
        }
        i = rows.size() - 1;
        while (i >= 0) {
            if (((GridConvertionHelper.ComponentGroup)rows.get(i)).getComponents().isEmpty()) {
                layout.deleteRow(i);
            }
            --i;
        }
    }

    private static void createDimensions(MigLayoutInfo layout, List<GridConvertionHelper.ComponentGroup> groups, boolean horizontal) throws Exception {
        for (GridConvertionHelper.ComponentGroup group : groups) {
            MigDimensionInfo dimension;
            if (horizontal) {
                MigColumnInfo column = new MigColumnInfo(layout);
                layout.getColumns().add(column);
                dimension = column;
            } else {
                MigRowInfo row = new MigRowInfo(layout);
                layout.getRows().add(row);
                dimension = row;
            }
            dimension.setSize(String.valueOf(group.getSize()) + "px");
        }
    }

    private static MigColumnInfo.Alignment getHorizontalAlignment(List<GridConvertionHelper.ComponentGroup> columns, GridConvertionHelper.ComponentInGroup componentInGroup, GeneralLayoutData generalLayoutData) {
        MigColumnInfo.Alignment alignment;
        if (generalLayoutData.horizontalAlignment != null && (alignment = (MigColumnInfo.Alignment)((Object)GeneralLayoutData.getRealValue(MigLayoutInfo.m_horizontalAlignmentMap, (Object)generalLayoutData.horizontalAlignment))) != null && alignment != MigColumnInfo.Alignment.UNKNOWN) {
            return alignment;
        }
        ComponentInfo component = (ComponentInfo)componentInGroup.getComponent();
        GridConvertionHelper.ComponentGroup beginColumn = GridConvertionHelper.getBeginForComponent(columns, (GridConvertionHelper.ComponentInGroup)componentInGroup);
        GridConvertionHelper.ComponentGroup endColumn = GridConvertionHelper.getEndForComponent(columns, (GridConvertionHelper.ComponentInGroup)componentInGroup);
        Rectangle bounds = component.getBounds();
        Dimension prefSize = component.getPreferredSize();
        int bl = bounds.x;
        int br = bounds.right();
        int columnLeft = beginColumn.getMin();
        int columnRight = endColumn.getMax();
        int columnCenter = columnLeft + (columnRight - columnLeft) / 2;
        int leftOffset = Math.abs(bl - columnLeft);
        int rightOffset = Math.abs(columnRight - br);
        int leftDelta = leftOffset + Math.abs(columnLeft + prefSize.width - br);
        int rightDelta = rightOffset + Math.abs(columnRight - prefSize.width - bl);
        int fillDelta = leftOffset + rightOffset;
        int centerDelta = Math.abs(bl - (columnCenter - prefSize.width / 2)) + Math.abs(br - (columnCenter + prefSize.width / 2));
        return (MigColumnInfo.Alignment)MigLayoutConverter.getAlignment((int[])new int[]{leftDelta, centerDelta, rightDelta, fillDelta}, (Enum[])new MigColumnInfo.Alignment[]{MigColumnInfo.Alignment.LEFT, MigColumnInfo.Alignment.CENTER, MigColumnInfo.Alignment.RIGHT, MigColumnInfo.Alignment.FILL});
    }

    private static MigRowInfo.Alignment getVerticalAlignment(List<GridConvertionHelper.ComponentGroup> rows, GridConvertionHelper.ComponentInGroup componentInGroup, GeneralLayoutData generalLayoutData) {
        MigRowInfo.Alignment alignment;
        if (generalLayoutData.verticalAlignment != null && (alignment = (MigRowInfo.Alignment)((Object)GeneralLayoutData.getRealValue(MigLayoutInfo.m_verticalAlignmentMap, (Object)generalLayoutData.verticalAlignment))) != null && alignment != MigRowInfo.Alignment.UNKNOWN) {
            return alignment;
        }
        ComponentInfo component = (ComponentInfo)componentInGroup.getComponent();
        GridConvertionHelper.ComponentGroup beginRow = GridConvertionHelper.getBeginForComponent(rows, (GridConvertionHelper.ComponentInGroup)componentInGroup);
        GridConvertionHelper.ComponentGroup endRow = GridConvertionHelper.getEndForComponent(rows, (GridConvertionHelper.ComponentInGroup)componentInGroup);
        Rectangle bounds = component.getBounds();
        Dimension prefSize = component.getPreferredSize();
        int bt = bounds.y;
        int bb = bounds.bottom();
        int rowTop = beginRow.getMin();
        int rowBottom = endRow.getMax();
        int rowCenter = rowTop + (rowBottom - rowTop) / 2;
        int topOffset = bt - rowTop;
        int bottomOffset = rowBottom - bb;
        int topDelta = topOffset + Math.abs(rowTop + prefSize.height - bb);
        int bottomDelta = bottomOffset + Math.abs(rowBottom - prefSize.height - bt);
        int fillDelta = topOffset + bottomOffset;
        int centerDelta = Math.abs(bt - (rowCenter - prefSize.height / 2)) + Math.abs(bb - (rowCenter + prefSize.height / 2));
        return (MigRowInfo.Alignment)MigLayoutConverter.getAlignment((int[])new int[]{topDelta, centerDelta, bottomDelta, fillDelta}, (Enum[])new MigRowInfo.Alignment[]{MigRowInfo.Alignment.TOP, MigRowInfo.Alignment.CENTER, MigRowInfo.Alignment.BOTTOM, MigRowInfo.Alignment.FILL});
    }

    private static <A extends Enum<?>> A getAlignment(int[] deltas, A[] alignments) {
        int minimum = Integer.MAX_VALUE;
        int i = 0;
        while (i < deltas.length) {
            int delta = deltas[i];
            minimum = Math.min(minimum, delta);
            ++i;
        }
        return alignments[ArrayUtils.indexOf((int[])deltas, (int)minimum)];
    }
}

