/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ide.IIdeFactory;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;
import org.eclipse.epp.logging.aeri.core.IModelFactory;
import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.epp.logging.aeri.core.IServerConnection;
import org.eclipse.epp.logging.aeri.core.ProblemStatus;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.jdt.annotation.Nullable;

public class UploadReportsScheduler {
    @Nullable
    Job uploadJob = null;
    ConcurrentLinkedQueue<ILogEventGroup> uploadQueue = new ConcurrentLinkedQueue();

    public IProblemState send(ILogEvent event, IProgressMonitor monitor) {
        IProblemState response;
        IServerDescriptor server = event.getServer();
        IServerConnection cx = server.getConnection();
        if (!server.isActive()) {
            String msg = Formats.format(Messages.RESPONSE_REPORT_UPLOADED, server.getName(), event.getStatus().getMessage());
            response = IModelFactory.eINSTANCE.createProblemState();
            response.setStatus(ProblemStatus.FAILURE);
            response.setMessage(msg);
            event.setResponse(response);
            Logs.debug((String)msg, (Object[])new Object[0]);
        }
        try {
            IProblemState response2 = cx.submit(event.getStatus(), event.getContext(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            Preconditions.checkNotNull((Object)response2, (Object)"Server returned null response");
            event.setResponse(response2);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_RESPONSE_UPLOAD_REPORT_FAILED, (Throwable)e, (Object[])new Object[]{server.getName(), e.getMessage()});
            response = IModelFactory.eINSTANCE.createProblemState();
            response.setStatus(ProblemStatus.FAILURE);
            response.setMessage(Formats.format(Messages.RESPONSE_REPORT_UPLOAD_FAILED, server.getName(), e.getMessage()));
            event.setResponse(response);
        }
        monitor.done();
        return event.getResponse();
    }

    public void send(ILogEventGroup group, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)group.getEvents().size());
        for (ILogEvent event : group.getEvents()) {
            this.send(event, (IProgressMonitor)sub.newChild(1));
        }
        monitor.done();
    }

    public void schedule(ILogEvent event) {
        ILogEventGroup group = IIdeFactory.eINSTANCE.createLogEventGroup();
        group.setStatus(event.getStatus());
        group.getEvents().add((Object)event);
        group.setStatus(event.getStatus());
        this.schedule(group);
    }

    public void schedule(ILogEventGroup group) {
        this.uploadQueue.add(group);
        if (this.uploadJob != null && this.uploadJob.getState() == 4) {
            return;
        }
        this.uploadJob = new UploadJob(Messages.JOB_NAME_UPLOADING_REPORTS);
        this.uploadJob.schedule();
    }

    public void schedule(Iterable<ILogEventGroup> groups) {
        for (ILogEventGroup group : groups) {
            this.schedule(group);
        }
    }

    private final class UploadJob
    extends Job {
        private UploadJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!UploadReportsScheduler.this.uploadQueue.isEmpty()) {
                ILogEventGroup group = UploadReportsScheduler.this.uploadQueue.poll();
                UploadReportsScheduler.this.send(group, monitor);
            }
            return Status.OK_STATUS;
        }
    }
}

