/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.server.mars;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.fluent.Executor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.server.LocalReportsHistory;
import org.eclipse.epp.internal.logging.aeri.ide.server.mars.IO;
import org.eclipse.epp.internal.logging.aeri.ide.server.mars.ServerConfiguration;
import org.eclipse.epp.internal.logging.aeri.ide.server.mars.ServerProblemsHistory;
import org.eclipse.epp.logging.aeri.core.ILink;
import org.eclipse.epp.logging.aeri.core.ILinkable;
import org.eclipse.epp.logging.aeri.core.IModelFactory;
import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.ISendOptions;
import org.eclipse.epp.logging.aeri.core.IServerConnection;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.ProblemStatus;
import org.eclipse.epp.logging.aeri.core.filters.AcceptFreezeFilter;
import org.eclipse.epp.logging.aeri.core.filters.AcceptedPluginsFilter;
import org.eclipse.epp.logging.aeri.core.filters.AcceptedProductsFilter;
import org.eclipse.epp.logging.aeri.core.filters.DecoratingDebugFilter;
import org.eclipse.epp.logging.aeri.core.filters.RequiredPackagesFilter;
import org.eclipse.epp.logging.aeri.core.filters.StatusIgnorePatternsFilter;
import org.eclipse.epp.logging.aeri.core.util.Formats;
import org.eclipse.epp.logging.aeri.core.util.Links;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.epp.logging.aeri.core.util.Reports;

public class ServerConnection
extends AbstractIdleService
implements IServerConnection {
    private final IServerDescriptor server;
    private final ISystemSettings systemSettings;
    private final File configurationArea;
    private Predicate<IStatus> statusFilters = Predicates.alwaysFalse();
    private IO io;
    private ServerProblemsHistory remoteHistory;
    private LocalReportsHistory localHistory;

    @Inject
    public ServerConnection(IServerDescriptor descriptor, ISystemSettings system, File configurationArea) {
        this.systemSettings = (ISystemSettings)Preconditions.checkNotNull((Object)system);
        this.configurationArea = (File)Preconditions.checkNotNull((Object)configurationArea);
        this.server = (IServerDescriptor)Preconditions.checkNotNull((Object)descriptor);
    }

    @PostConstruct
    private void e4Start() {
        this.startAsync();
    }

    protected void startUp() throws Exception {
        try {
            File remoteHistoryStateLocation = new File(this.configurationArea, "remote-history");
            this.remoteHistory = new ServerProblemsHistory(remoteHistoryStateLocation);
            this.remoteHistory.startAsync();
            File localHistoryStateLocation = new File(this.configurationArea, "local-history");
            localHistoryStateLocation.mkdirs();
            this.localHistory = new LocalReportsHistory(localHistoryStateLocation);
            this.localHistory.startAsync();
            File file = new File(this.configurationArea, "server-config.json");
            this.io = new IO(Executor.newInstance(), file);
            if (file.exists()) {
                this.io.loadConfiguration();
            }
            if (this.io.isConfigurationOutdated()) {
                this.io.refreshConfiguration(((ILink)Preconditions.checkNotNull((Object)Links.getLink((ILinkable)this.server, (String)"discovery"))).getHref(), (IProgressMonitor)new NullProgressMonitor());
                this.io.saveConfiguration();
            }
            if (this.io.isProblemsDatabaseOutdated()) {
                new ServerProblemsHistory.UpdateIndexJob(this.io, this.systemSettings, this.remoteHistory).schedule(TimeUnit.MINUTES.toMillis(5L));
            }
            ServerConfiguration configuration = this.io.getConfiguration();
            Preconditions.checkNotNull((Object)configuration, (Object)"no configuration available");
            Preconditions.checkNotNull((Object)((Object)this.localHistory));
            Predicate[] statusFilters = DecoratingDebugFilter.decorate((Predicate[])new Predicate[]{new LocalReportsHistory.LocalHistorySeenFilter(this.localHistory, this.systemSettings), new AcceptedProductsFilter(configuration.getAcceptedProductsPatterns()), new RequiredPackagesFilter(configuration.getRequiredPackagesPatterns()), new AcceptedPluginsFilter(configuration.getAcceptedPluginsPatterns()), new StatusIgnorePatternsFilter(configuration.getIgnoredPluginMessagesPatterns()), new AcceptFreezeFilter(configuration.isAcceptUiFreezes())});
            this.statusFilters = Predicates.and((Predicate[])statusFilters);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_SERVER_FAILURE, (Throwable)e, (Object[])new Object[]{this.server.getId(), e.getMessage()});
            this.stopAsync();
        }
    }

    public IProblemState interested(IStatus status, IEclipseContext context, IProgressMonitor monitor) {
        if (!this.isRunning() || !this.statusFilters.apply((Object)status)) {
            IProblemState res = IModelFactory.eINSTANCE.createProblemState();
            res.setStatus(ProblemStatus.IGNORED);
            return res;
        }
        IProblemState seen = this.remoteHistory.seen(status);
        String message = seen.getMessage();
        if (seen.getMessage() != null) {
            return seen;
        }
        switch (seen.getStatus()) {
            case IGNORED: {
                return seen;
            }
            case NEEDINFO: {
                message = this.msgNeedinfoBeforeSend(seen);
                break;
            }
            case FIXED: {
                message = this.msgFixedBeforeSend(seen);
                break;
            }
            case UNCONFIRMED: {
                message = this.msgUnconfirmedBeforeSend(seen);
                break;
            }
            default: {
                message = Formats.format((String)"Unexpected state {0}", (Object[])new Object[]{seen.getStatus()});
            }
        }
        seen.setMessage(message);
        return seen;
    }

    public IReport transform(IStatus status, IEclipseContext context) {
        ISendOptions options = (ISendOptions)Preconditions.checkNotNull((Object)((ISendOptions)context.get(ISendOptions.class)));
        IReport report = Reports.newReport((IStatus)status);
        report.setComment(options.getComment());
        report.setAnonymousId(options.getReporterId());
        report.setName(options.getReporterName());
        report.setEmail(options.getReporterEmail());
        report.setSeverity(options.getSeverity());
        if (options.isAnonymizeMessages()) {
            Reports.anonymizeMessages((IReport)report);
        }
        if (options.isAnonymizeStackTraces()) {
            Reports.anonymizeStackTraces((IReport)report, this.io.getConfiguration().getAcceptedPackagesPatterns());
        }
        return report;
    }

    public IProblemState submit(IStatus status, IEclipseContext context, IProgressMonitor monitor) throws IOException {
        IReport report = this.transform(status, context);
        IProblemState response = this.io.upload(report, monitor);
        this.localHistory.remember(status);
        String message = response.getMessage();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            message = StringUtils.replace((String)message, (String)"{link,", (String)"{0,link,");
            message = Formats.format((String)message, (Object[])new Object[]{response});
            message = Formats.format((String)Messages.PROBLEM_MESSAGES_FORWARD_SERVER_RESPONSE, (Object[])new Object[]{this.server.getName(), message});
            response.setMessage(message);
            return response;
        }
        switch (response.getStatus()) {
            case NEW: {
                message = this.msgNewAfterSend(response);
                break;
            }
            case UNCONFIRMED: {
                message = this.msgUnconfirmedAfterSend(response);
                break;
            }
            case CONFIRMED: {
                message = this.msgConfirmedAfterSend(response);
                break;
            }
            case FIXED: {
                message = this.msgFixedAfterSend(response);
                break;
            }
            case NEEDINFO: {
                message = this.msgNeedinfoAfterSend(response);
                break;
            }
            case FAILURE: {
                message = this.msgFailure();
                break;
            }
            case INVALID: 
            case IGNORED: {
                message = this.msgInvalidOrIgnored(response);
            }
        }
        response.setMessage(message);
        return response;
    }

    private String msgFailure() {
        return Formats.format((String)Messages.PROBLEM_MESSAGES_SERVER_FAILURE, (Object[])new Object[]{this.server.getName()});
    }

    private String msgInvalidOrIgnored(IProblemState response) {
        return Formats.format((String)Messages.PROBLEM_MESSAGES_IGNORED_OR_INVALID_STATUS, (Object[])new Object[]{this.server.getName(), response});
    }

    public void discarded(IStatus status, IEclipseContext context) {
        this.localHistory.remember(status);
    }

    protected String msgNewAfterSend(IProblemState response) {
        return Formats.format((String)Messages.PROBLEM_MESSAGES_NEW_AFTER_SEND, (Object[])new Object[]{this.server.getName(), response});
    }

    protected String msgUnconfirmedBeforeSend(IProblemState cachedState) {
        return Formats.format((String)Messages.PROBLEM_MESSAGES_UNCONFIRMED_BEFORE_SEND, (Object[])new Object[]{this.server.getName(), cachedState});
    }

    protected String msgUnconfirmedAfterSend(IProblemState response) {
        return Formats.format((String)Messages.PROBLEM_MESSAGES_UNCONFIRMED_AFTER_SEND, (Object[])new Object[]{this.server.getName(), response});
    }

    protected String msgConfirmedAfterSend(IProblemState response) {
        if (Links.hasLink((ILinkable)response, (String)"bug")) {
            return Formats.format((String)Messages.PROBLEM_MESSAGES_CONFIRMED_BUG_AFTER_SEND, (Object[])new Object[]{this.server.getName(), response});
        }
        return Formats.format((String)Messages.PROBLEM_MESSAGES_CONFIRMED_NO_BUG_AFTER_SEND, (Object[])new Object[]{this.server.getName(), response});
    }

    protected String msgNeedinfoBeforeSend(IProblemState cachedState) {
        if (Links.hasLink((ILinkable)cachedState, (String)"bug")) {
            return Formats.format((String)Messages.PROBLEM_MESSAGES_NEEDINFO_BUG_BEFORE_SEND, (Object[])new Object[]{this.server.getName(), cachedState});
        }
        return Formats.format((String)Messages.PROBLEM_MESSAGES_NEEDINFO_NO_BUG_BEFORE_SEND, (Object[])new Object[]{this.server.getName(), cachedState});
    }

    protected String msgNeedinfoAfterSend(IProblemState response) {
        if (Links.hasLink((ILinkable)response, (String)"bug")) {
            return Formats.format((String)Messages.PROBLEM_MESSAGES_NEEDINFO_BUG_AFTER_SEND, (Object[])new Object[]{this.server.getName(), response});
        }
        return Formats.format((String)Messages.PROBLEM_MESSAGES_NEEDINFO_NO_BUG_AFTER_SEND, (Object[])new Object[]{this.server.getName(), response});
    }

    protected String msgFixedBeforeSend(IProblemState cachedState) {
        if (Links.hasLink((ILinkable)cachedState, (String)"bug")) {
            return Formats.format((String)Messages.PROBLEM_MESSAGES_FIXED_BUG_BEFORE_SEND, (Object[])new Object[]{this.server.getName(), cachedState});
        }
        return Formats.format((String)Messages.PROBLEM_MESSAGES_FIXED_NO_BUG_BEFORE_SEND, (Object[])new Object[]{this.server.getName(), cachedState});
    }

    protected String msgFixedAfterSend(IProblemState response) {
        if (Links.hasLink((ILinkable)response, (String)"bug")) {
            return Formats.format((String)Messages.PROBLEM_MESSAGES_FIXED_BUG_AFTER_SEND, (Object[])new Object[]{this.server.getName(), response});
        }
        return Formats.format((String)Messages.PROBLEM_MESSAGES_FIXED_NO_BUG_AFTER_SEND, (Object[])new Object[]{this.server.getName(), response});
    }

    @PreDestroy
    private void diStop() throws TimeoutException {
        this.stopAsync().awaitTerminated(2L, TimeUnit.SECONDS);
    }

    protected void shutDown() throws Exception {
    }

    public String toString() {
        return String.valueOf(this.server.getId()) + " " + super.toString();
    }
}

