/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.notifications;

import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.OpenSystemSetupWizardHandler;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.NotificationAction;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.SendMode;
import org.eclipse.epp.logging.aeri.core.SystemControl;

public class SetupSystemNotification
extends Notification {
    private IEclipseContext context;

    @Inject
    public SetupSystemNotification(IEventBroker broker, IEclipseContext context) {
        super("org.eclipse.epp.logging.aeri.notifications.event.setup", broker);
        this.context = context;
    }

    @Override
    public List<NotificationAction> getActions() {
        NotificationAction a1 = new NotificationAction(Messages.NOTIFICATION_ACTION_ENABLE){

            @Override
            public void execute() {
                SetupSystemNotification.this.closeWithEvent(null, null);
                SystemControl.executeHandler(OpenSystemSetupWizardHandler.class, (IEclipseContext)SetupSystemNotification.this.context);
            }
        };
        NotificationAction a2 = new NotificationAction(Messages.NOTIFICATION_ACTION_DISABLE){

            @Override
            public void execute() {
                SetupSystemNotification.this.closeWithEvent(null, null);
                ISystemSettings settings = SystemControl.getSystemSettings();
                settings.setSendMode(SendMode.NEVER);
            }
        };
        return Lists.newArrayList((Object[])new NotificationAction[]{a1, a2});
    }

    @Override
    public String getTitle() {
        return Messages.NOTIFICATION_TITLE_SETUP_SYSTEM;
    }

    public String getLabel() {
        return Messages.NOTIFICATION_LABEL_SETUP_SYSTEM;
    }

    public String getDescription() {
        return Messages.NOTIFICATION_DESCRIPTION_SETUP_SYSTEM;
    }
}

