/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.ui.editor.ICompleteListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.TabContainerConfiguration;
import org.eclipse.wb.internal.core.utils.ui.CTabFactory;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabContainerUiContentProvider
implements IUiContentProvider {
    private final TabContainerConfiguration m_configuration;
    protected ICompleteListener m_listener;
    private CTabFolder m_folder;
    private ToolItem m_removeButton;
    private ToolItem m_upButton;
    private ToolItem m_downButton;
    private boolean m_showEmptyPage;

    public TabContainerUiContentProvider(TabContainerConfiguration configuration) {
        this.m_configuration = configuration;
    }

    @Override
    public void setCompleteListener(ICompleteListener listener) {
        this.m_listener = listener;
    }

    @Override
    public String getErrorMessage() {
        if (this.m_showEmptyPage) {
            return null;
        }
        int count = this.m_folder.getItemCount();
        int i = 0;
        while (i < count) {
            IUiContentProvider contentProvider = (IUiContentProvider)this.m_folder.getItem(i).getData();
            String errorMessage = contentProvider.getErrorMessage();
            if (errorMessage != null) {
                return errorMessage;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    @Override
    public void createContent(Composite parent, int columns) {
        this.m_folder = new CTabFolder(parent, 2048);
        GridDataFactory.create((Control)this.m_folder).fill().grab().spanH(columns);
        this.m_folder.setUnselectedCloseVisible(false);
        this.m_folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabContainerUiContentProvider.this.calculateButtonsState();
            }
        });
        this.m_folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                TabContainerUiContentProvider.this.deletePage((CTabItem)event.item);
            }
        });
        if (this.m_configuration.isUseAddButton() || this.m_configuration.isUseMultiAddButton() || this.m_configuration.isUseRemoveButton() || this.m_configuration.isUseUpDownButtons()) {
            ToolItem addButton;
            Composite buttonsComposite = new Composite((Composite)this.m_folder, 0);
            GridLayoutFactory.create((Composite)buttonsComposite).noMargins();
            ToolBar buttonsBar = new ToolBar(buttonsComposite, 0x820000);
            GridDataFactory.create((Control)buttonsBar).fillH().grabH();
            if (this.m_configuration.isUseAddButton()) {
                addButton = new ToolItem(buttonsBar, 0);
                addButton.setText(Messages.TabContainerUiContentProvider_addButton);
                addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        TabContainerUiContentProvider.this.addPage();
                    }
                });
            }
            if (this.m_configuration.isUseMultiAddButton()) {
                addButton = new ToolItem(buttonsBar, 4);
                addButton.setText(Messages.TabContainerUiContentProvider_addItem);
                final MenuManager menuManager = new MenuManager();
                menuManager.createContextMenu((Control)buttonsBar);
                addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        menuManager.removeAll();
                        int insertIndex = TabContainerUiContentProvider.this.m_folder.getSelectionIndex();
                        if (insertIndex != -1) {
                            ++insertIndex;
                        }
                        try {
                            TabContainerUiContentProvider.this.chooseAddPage(menuManager, insertIndex);
                        }
                        catch (Throwable e) {
                            DesignerPlugin.log((Throwable)e);
                        }
                        menuManager.update(true);
                        Rectangle bounds = addButton.getBounds();
                        Point location = addButton.getParent().toDisplay(new Point(bounds.x, bounds.y + bounds.height));
                        menuManager.getMenu().setLocation(location.x, location.y);
                        menuManager.getMenu().setVisible(true);
                    }
                });
            }
            if (this.m_configuration.isUseRemoveButton()) {
                this.m_removeButton = new ToolItem(buttonsBar, 0);
                this.m_removeButton.setText(Messages.TabContainerUiContentProvider_removeButton);
                this.m_removeButton.setEnabled(false);
                this.m_removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int index = TabContainerUiContentProvider.this.m_folder.getSelectionIndex();
                        if (index != -1) {
                            TabContainerUiContentProvider.this.deletePage(TabContainerUiContentProvider.this.m_folder.getItem(index));
                        }
                    }
                });
            }
            if (this.m_configuration.isUseUpDownButtons()) {
                new ToolItem(buttonsBar, 2);
                this.m_upButton = new ToolItem(buttonsBar, 0);
                this.m_upButton.setText("<<");
                this.m_upButton.setEnabled(false);
                this.m_upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TabContainerUiContentProvider.this.movePage(-1);
                    }
                });
                this.m_downButton = new ToolItem(buttonsBar, 0);
                this.m_downButton.setText(">>");
                this.m_downButton.setEnabled(false);
                this.m_downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TabContainerUiContentProvider.this.movePage(1);
                    }
                });
            }
            this.m_folder.setTopRight((Control)buttonsComposite);
        }
    }

    private void calculateButtonsState() {
        int itemCount = this.m_folder.getItemCount();
        int selectionIndex = this.m_folder.getSelectionIndex();
        if (selectionIndex == -1 || itemCount == 1 && this.m_showEmptyPage) {
            if (this.m_removeButton != null) {
                this.m_removeButton.setEnabled(false);
            }
            if (this.m_upButton != null) {
                this.m_upButton.setEnabled(false);
                this.m_downButton.setEnabled(false);
            }
            return;
        }
        if (this.m_removeButton != null) {
            this.m_removeButton.setEnabled(true);
        }
        if (this.m_upButton != null) {
            this.m_upButton.setEnabled(selectionIndex > 0);
            this.m_downButton.setEnabled(selectionIndex < itemCount - 1);
        }
    }

    protected void chooseAddPage(MenuManager menuManager, int insertIndex) throws Exception {
        throw new UnsupportedOperationException();
    }

    private void addPage() {
        try {
            int insertIndex = this.m_folder.getSelectionIndex();
            if (insertIndex != -1) {
                ++insertIndex;
            }
            this.createPage(insertIndex, this.createNewPageContentProvider(), true);
            this.configure();
            this.m_listener.calculateFinish();
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    protected final void createPage(int insertIndex, IUiContentProvider contentProvider, boolean selection) throws Exception {
        int itemCount = this.m_folder.getItemCount();
        int n = insertIndex = insertIndex == -1 ? itemCount : insertIndex;
        if (itemCount == 1 && this.m_showEmptyPage) {
            this.deleteTabItem(this.m_folder.getItem(0));
            this.m_showEmptyPage = false;
            insertIndex = 0;
        }
        Composite pageComposite = new Composite((Composite)this.m_folder, 0);
        GridLayoutFactory.create((Composite)pageComposite).columns(contentProvider.getNumberOfControls()).margins(3);
        contentProvider.createContent(pageComposite, contentProvider.getNumberOfControls());
        CTabItem tabItem = new CTabItem(this.m_folder, 64, insertIndex);
        tabItem.setControl((Control)pageComposite);
        tabItem.setData((Object)contentProvider);
        contentProvider.setCompleteListener(this.m_listener);
        contentProvider.updateFromObject();
        if (selection) {
            this.m_folder.setSelection(tabItem);
            this.calculateButtonsState();
        }
    }

    protected final void configure() {
        int count = this.m_folder.getItemCount();
        int i = 0;
        while (i < count) {
            CTabItem tabItem = this.m_folder.getItem(i);
            IUiContentProvider contentProvider = (IUiContentProvider)tabItem.getData();
            this.configute(tabItem, i, contentProvider);
            ++i;
        }
    }

    protected abstract IUiContentProvider createNewPageContentProvider() throws Exception;

    protected abstract void configute(CTabItem var1, int var2, IUiContentProvider var3);

    private void deletePage(CTabItem item) {
        try {
            this.postDelete((IUiContentProvider)item.getData());
            this.deleteTabItem(item);
            this.postDelete();
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    protected final void deleteTabItem(CTabItem tabItem) {
        Control control = tabItem.getControl();
        tabItem.dispose();
        control.dispose();
    }

    protected void postDelete(IUiContentProvider provider) throws Exception {
    }

    protected void postDelete() throws Exception {
        if (this.m_folder.getItemCount() == 0 && this.m_configuration.isCreateEmptyPage()) {
            this.createEmptyPage();
        } else {
            this.configure();
        }
        this.m_listener.calculateFinish();
    }

    private void createEmptyPage() {
        this.m_showEmptyPage = true;
        Label messageLabel = new Label((Composite)this.m_folder, 64);
        messageLabel.setText(this.m_configuration.getEmptyPageMessage());
        CTabFactory.item((CTabFolder)this.m_folder).control((Control)messageLabel).name(this.m_configuration.getEmptyPageTitle());
        this.m_folder.setSelection(0);
        this.calculateButtonsState();
    }

    private void movePage(int delta) {
        int index = this.m_folder.getSelectionIndex();
        if (index == -1) {
            return;
        }
        CTabItem tabItem = this.m_folder.getItem(index);
        Control tabControl = tabItem.getControl();
        String tabName = tabItem.getText();
        Object tabData = tabItem.getData();
        tabItem.dispose();
        tabItem = new CTabItem(this.m_folder, 64, index + delta);
        tabItem.setControl(tabControl);
        tabItem.setText(tabName);
        tabItem.setData(tabData);
        this.configure();
        this.m_folder.setSelection(tabItem);
        this.calculateButtonsState();
        this.m_listener.calculateFinish();
    }

    protected final void updateFromObject(List<IUiContentProvider> providers) throws Exception {
        if (providers.isEmpty() && this.m_configuration.isCreateEmptyPage()) {
            this.createEmptyPage();
        } else {
            boolean selection = true;
            for (IUiContentProvider contentProvider : providers) {
                this.createPage(-1, contentProvider, selection);
                selection = false;
            }
            this.configure();
        }
        this.m_listener.calculateFinish();
    }

    @Override
    public void saveToObject() throws Exception {
        List providers = Lists.newArrayList();
        if (!this.m_showEmptyPage) {
            int count = this.m_folder.getItemCount();
            int i = 0;
            while (i < count) {
                IUiContentProvider provider = (IUiContentProvider)this.m_folder.getItem(i).getData();
                providers.add(provider);
                provider.saveToObject();
                ++i;
            }
        }
        this.saveToObject(providers);
    }

    protected final CTabItem providerToItem(IUiContentProvider provider) {
        int count = this.m_folder.getItemCount();
        int i = 0;
        while (i < count) {
            CTabItem item = this.m_folder.getItem(i);
            if (provider == item.getData()) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected final List<IUiContentProvider> getProviders() {
        List providers = Lists.newArrayList();
        if (!this.m_showEmptyPage) {
            int count = this.m_folder.getItemCount();
            int i = 0;
            while (i < count) {
                IUiContentProvider provider = (IUiContentProvider)this.m_folder.getItem(i).getData();
                providers.add(provider);
                ++i;
            }
        }
        return providers;
    }

    protected abstract void saveToObject(List<IUiContentProvider> var1) throws Exception;
}

