/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.external;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.BundleResourceProvider;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalFactoriesHelper {
    private static final String CLASS_LOADING_CONTRIBUTORS = "org.eclipse.wb.core.classLoadingContributor";
    private static Map<String, List<IExtension>> m_extensions = Maps.newHashMap();
    private static Map<String, Map<String, List<IConfigurationElement>>> m_configurationElements = Maps.newHashMap();
    private static Map<String, Map<String, List<?>>> m_configurationObjects = Maps.newHashMap();
    private static final IRegistryChangeListener m_descriptionProcessorsListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] iExtensionDeltaArray = event.getExtensionDeltas();
            int n = iExtensionDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta extensionDelta = iExtensionDeltaArray[n2];
                String pointId = extensionDelta.getExtensionPoint().getUniqueIdentifier();
                ExternalFactoriesHelper.clearCache(pointId);
                ++n2;
            }
        }
    };

    static {
        Platform.getExtensionRegistry().addRegistryChangeListener(m_descriptionProcessorsListener);
    }

    private ExternalFactoriesHelper() {
    }

    public static Class<?> loadBundleClass(String className) throws ClassNotFoundException {
        try {
            List<IConfigurationElement> contributors = ExternalFactoriesHelper.getElements(CLASS_LOADING_CONTRIBUTORS, "contributor");
            for (IConfigurationElement element : contributors) {
                String namespace = ExternalFactoriesHelper.getRequiredAttribute(element, "namespace");
                if (!className.contains(namespace)) continue;
                try {
                    return ExternalFactoriesHelper.getExtensionBundle(element).loadClass(className);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable e) {
            throw new ClassNotFoundException("Exception during loading class " + className, e);
        }
        return Class.forName(className);
    }

    private static synchronized void clearCache(String pointId) {
        m_extensions.remove(pointId);
        m_configurationElements.remove(pointId);
        m_configurationObjects.remove(pointId);
    }

    public static synchronized <T> List<T> getElementsInstances(Class<T> clazz, String pointId, String elementName) {
        List objects;
        Map elementName_to_objects = m_configurationObjects.get(pointId);
        if (elementName_to_objects == null) {
            elementName_to_objects = Maps.newHashMap();
            m_configurationObjects.put(pointId, elementName_to_objects);
        }
        if ((objects = (List)elementName_to_objects.get(elementName)) == null) {
            objects = Lists.newArrayList();
            elementName_to_objects.put(elementName, objects);
            List<IConfigurationElement> elements = ExternalFactoriesHelper.getElements(pointId, elementName);
            for (IConfigurationElement element : elements) {
                T object = ExternalFactoriesHelper.createExecutableExtension(element, "class");
                objects.add(object);
            }
        }
        return objects;
    }

    public static synchronized <T> T createExecutableExtension(final IConfigurationElement element, final String classAttributeName) {
        return ExecutionUtils.runObject(new RunnableObjectEx<T>(){

            @Override
            public T runObject() throws Exception {
                String className;
                Bundle extensionBundle = ExternalFactoriesHelper.getExtensionBundle(element);
                Class clazz = extensionBundle.loadClass(className = ExternalFactoriesHelper.getRequiredAttribute(element, classAttributeName));
                Field instanceField = ReflectionUtils.getFieldByName(clazz, "INSTANCE");
                if (instanceField != null && instanceField.getDeclaringClass() == clazz) {
                    return instanceField.get(null);
                }
                return element.createExecutableExtension(classAttributeName);
            }
        });
    }

    public static synchronized List<IConfigurationElement> getElements(String pointId, String elementName) {
        List elements;
        Map elementName_to_elements = m_configurationElements.get(pointId);
        if (elementName_to_elements == null) {
            elementName_to_elements = Maps.newHashMap();
            m_configurationElements.put(pointId, elementName_to_elements);
        }
        if ((elements = (List)elementName_to_elements.get(elementName)) == null) {
            elements = Lists.newArrayList();
            elementName_to_elements.put(elementName, elements);
            for (IExtension extension : ExternalFactoriesHelper.getExtensions(pointId)) {
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if (elementName.equals(element.getName())) {
                        elements.add(element);
                    }
                    ++n2;
                }
            }
            ExternalFactoriesHelper.sortByPriority(elements);
        }
        ExternalFactoriesHelper.removeInvalidElements(elements);
        return elements;
    }

    private static void removeInvalidElements(List<IConfigurationElement> elements) {
        Iterator<IConfigurationElement> I = elements.iterator();
        while (I.hasNext()) {
            IConfigurationElement element = I.next();
            if (ExternalFactoriesHelper.isValid(element)) continue;
            I.remove();
        }
    }

    private static boolean isValid(IConfigurationElement element) {
        if (!element.isValid()) {
            return false;
        }
        if (element.getParent() instanceof IExtension) {
            IExtension extension = (IExtension)element.getParent();
            return extension.isValid();
        }
        return ExternalFactoriesHelper.isValid((IConfigurationElement)element.getParent());
    }

    private static void sortByPriority(List<IConfigurationElement> elements) {
        Collections.sort(elements, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                return this.getPriority(o2) - this.getPriority(o1);
            }

            private int getPriority(IConfigurationElement element) {
                String priorityString = element.getAttribute("priority");
                return priorityString == null ? 0 : Integer.parseInt(priorityString);
            }
        });
    }

    public static synchronized IExtension getExtension(String pointId, String extensionId) {
        for (IExtension extension : ExternalFactoriesHelper.getExtensions(pointId)) {
            if (extension.isValid()) {
                if (!ObjectUtils.equals((Object)extension.getUniqueIdentifier(), (Object)extensionId)) continue;
                return extension;
            }
            ExternalFactoriesHelper.clearCache(pointId);
            return ExternalFactoriesHelper.getExtension(pointId, extensionId);
        }
        return null;
    }

    private static List<IExtension> getExtensions(String pointId) {
        List extensions = m_extensions.get(pointId);
        if (extensions == null) {
            extensions = Lists.newArrayList();
            m_extensions.put(pointId, extensions);
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pointId);
            if (extensionPoint != null) {
                CollectionUtils.addAll((Collection)extensions, (Object[])extensionPoint.getExtensions());
            }
        }
        return extensions;
    }

    public static Bundle getRequiredBundle(String id) {
        Bundle bundle = Platform.getBundle((String)id);
        if (bundle == null) {
            throw new IllegalArgumentException("Unable to find Bundle " + id);
        }
        return bundle;
    }

    public static Bundle getExtensionBundle(IConfigurationElement element) {
        IExtension extension = element.getDeclaringExtension();
        return ExternalFactoriesHelper.getExtensionBundle(extension);
    }

    public static Bundle getExtensionBundle(IExtension extension) {
        String id = extension.getNamespace();
        return Platform.getBundle((String)id);
    }

    public static String getRequiredAttribute(IConfigurationElement element, String attribute) {
        String value = element.getAttribute(attribute);
        if (value == null) {
            throw new IllegalArgumentException("Attribute '" + attribute + "' expected, but not found in " + element);
        }
        return value;
    }

    public static int getRequiredAttributeInteger(IConfigurationElement element, String attribute) {
        String valueString = ExternalFactoriesHelper.getRequiredAttribute(element, attribute);
        return Integer.parseInt(valueString);
    }

    public static Image getImage(IConfigurationElement element, String attribute) {
        String path = element.getAttribute(attribute);
        if (path != null) {
            Bundle bundle = ExternalFactoriesHelper.getExtensionBundle(element);
            BundleResourceProvider resourceProvider = BundleResourceProvider.get(bundle);
            return resourceProvider.getImage(path);
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(IConfigurationElement element, String attribute) {
        String path = element.getAttribute(attribute);
        if (path != null) {
            Bundle bundle = ExternalFactoriesHelper.getExtensionBundle(element);
            BundleResourceProvider resourceProvider = BundleResourceProvider.get(bundle);
            return resourceProvider.getImageDescriptor(path);
        }
        return null;
    }
}

