/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.text.MessageFormat;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractTextPropertyEditor;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class IntegerPropertyEditor
extends AbstractTextPropertyEditor {
    public static final IntegerPropertyEditor INSTANCE = new IntegerPropertyEditor();

    private IntegerPropertyEditor() {
    }

    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value instanceof Integer) {
            return value.toString();
        }
        return null;
    }

    protected String getEditorText(Property property) throws Exception {
        return this.getText(property);
    }

    protected boolean setEditorText(Property property, String text) throws Exception {
        Integer value;
        if ((text = text.trim()).length() == 0) {
            property.setValue(Property.UNKNOWN_VALUE);
            return true;
        }
        try {
            value = Integer.valueOf(text);
        }
        catch (Throwable throwable) {
            UiUtils.openWarning(DesignerPlugin.getShell(), property.getTitle(), MessageFormat.format(ModelMessages.IntegerPropertyEditor_notValidInt, text));
            return false;
        }
        property.setValue(value);
        return true;
    }
}

