/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.lang3.SystemUtils;

public final class AnonymousId {
    private static UUID anonymousId;

    private AnonymousId() {
    }

    public static synchronized UUID getId() {
        if (anonymousId == null) {
            try {
                anonymousId = AnonymousId.readOrCreateUUID();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return anonymousId;
    }

    private static UUID readOrCreateUUID() throws IOException {
        File f = new File(SystemUtils.getUserHome(), ".eclipse/org.eclipse.recommenders/anonymousId");
        if (f.exists()) {
            String uuid = Files.readFirstLine((File)f, (Charset)StandardCharsets.UTF_8);
            return UUID.fromString(uuid);
        }
        f.getParentFile().mkdirs();
        UUID uuid = UUID.randomUUID();
        Files.write((CharSequence)uuid.toString(), (File)f, (Charset)StandardCharsets.UTF_8);
        return uuid;
    }
}

