
Linux Mint 17.1 Rebecca

To configure cdwrite in Linux Mint perform the following steps:

1. Copy the following block of text:

      #-------------------------------------------------------------------
      %users	ALL = NOPASSWD: /bin/mount, /bin/umount

      %users	ALL = NOPASSWD: /usr/bin/mkisofs, /usr/bin/cdrecord, \
				/usr/bin/cdda2wav, /usr/bin/cdrdao, \
				/usr/bin/dvd+rw-format

      %users	ALL = NOPASSWD: /bin/kill
      #-------------------------------------------------------------------

   and paste it at the end of /etc/sudoers file.

2. Change the default group for all users allowed to use cdwrite from
   the individual ``username'' groups to the global ``users'' group.

   Assuming there are two users in your system -- john and mary -- by
   default the first is the member of the john group and the other is
   the member of the mary group.  To change that use the commands:

      usermod -g users john
      usermod -g users mary

   And then logout and login anew these users.

3. For the basic cdwrite functionality install the following packages:

      sudo apt-get install icedax vorbis-tools libcdio-utils cdparanoia \
           cdrdao lame mp3gain dialog normalize-audio

   (During the installation of normalize-audio apt-get installs also flac
   package.)

4. If you use the version of Linux Mint without multimedia codecs install the
   following package:

      sudo apt-get install mplayer2

5. Run cdwrite -c command to check where cdwrite seeks for the configuration
   file and customize that file to your needs.  You will find the hints about
   ambiguous cdwrite.conf variables in the last section of INSTALL file.
   First of all test manually cdda-player.  If it plays audio CDs,
   ``change cd_player'' variable from ``mplayer'' to ``cdda-player''.

6. If cdwrite displays the messages:

      wodim: No such file or directory. 
      Cannot open SCSI driver!
      For possible targets try 'wodim --devices' or 'wodim -scanbus'.
      For possible transport specifiers try 'wodim dev=help'.
      For IDE/ATAPI devices configuration, see the file README.ATAPI.setup
      from the wodim documentation.

   it means the shell did not found pluggable SCSI device.  If you do not
   use such a device these messages are harmless.

7. For the basic musica script functionality install the following packages:

      sudo apt-get install sox libsox-fmt-mp3 faad mpg321 musepack-tools

   The conversion from M4A to FLAC requires ffmpeg program.  Its installation
   is tricky in the newer versions of Linux Mint, Ubuntu, or Debian.  The
   complete process is decribed here:

      https://trac.ffmpeg.org/wiki/CompilationGuide/Ubuntu

8. For full cdwrite functionality install CDDB_get Perl module package (see:
   http://search.cpan.org/):

      tar xzf CDDB_get-2.28.tar.gz
      cd CDDB_get-2.28
      perl Makefile.PL
      make
      sudo make install

   as well as mutagen package (see: https://bitbucket.org/lazka/mutagen/):

      tar xzf mutagen-1.28.tar.gz
      cd mutagen-1.28
      ./setup.py build
      sudo ./setup.py install

   or id3v2 package:

      sudo apt-get install id3v2

   (During the installation of id3v2 apt-get installs also libid3 package.)

   The mutagen package is necessary if you would like to set ID3 tags in MP3
   files using UTF-8 encoding.

9. For full musica script functionality install manually mac package (see:
   http://etree.org/shnutils/shntool/support/formats/ape/unix/3.99-u4-b5/):

   First install g++ and optionally yasm:

      sudo apt-get install g++ yasm

   Then patch mac source with gcc4_errors.patch:

      tar xzf mac-3.99-u4-b5.tar.gz
      cp gcc4_errors.patch mac-3.99-u4-b5
      cd mac-3.99-u4-b5
      patch -p0 < gcc4_errors.patch

   Finally compile and install mac:

      ./configure
      make
      sudo make install

  The gcc4_errors.patch is required because without it make command
  displays error messages such as:

      APELink.cpp:66:55: error: invalid conversion from 'const char*' to 'char*' [-fpermissive]

For the detailed description of the installation process see INSTALL file.


Copyright (C) 2011-2015 Cezary M. Kruk <c.kruk@bigfoot.com>

