/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.bcb;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.internal.ui.bcb.BreadcrumbBarUI;
import org.pushingpixels.flamingo.internal.ui.bcb.BreadcrumbItemChoices;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class BasicBreadcrumbBarUI
extends BreadcrumbBarUI {
    protected JBreadcrumbBar breadcrumbBar;
    protected JPanel mainPanel;
    protected JScrollablePanel<JPanel> scrollerPanel;
    protected ComponentListener componentListener;
    protected JCommandButton dummy;
    protected LinkedList modelStack;
    protected LinkedList<JCommandButton> buttonStack;
    protected BreadcrumbPathListener pathListener;
    private AtomicInteger atomicCounter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicBreadcrumbBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.breadcrumbBar = (JBreadcrumbBar)jComponent;
        this.modelStack = new LinkedList();
        this.buttonStack = new LinkedList();
        this.installDefaults(this.breadcrumbBar);
        this.installComponents(this.breadcrumbBar);
        this.installListeners(this.breadcrumbBar);
        jComponent.setLayout(this.createLayoutManager());
        if (this.breadcrumbBar.getCallback() != null) {
            SwingWorker<List<StringValuePair>, Void> swingWorker = new SwingWorker<List<StringValuePair>, Void>(){

                @Override
                protected List<StringValuePair> doInBackground() throws Exception {
                    return BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(null);
                }

                @Override
                protected void done() {
                    try {
                        BasicBreadcrumbBarUI.this.pushChoices(new BreadcrumbItemChoices(null, (List)this.get()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            swingWorker.execute();
        }
        this.dummy = new JCommandButton("Dummy", new EmptyResizableIcon(16));
        this.dummy.setDisplayState(CommandButtonDisplayState.MEDIUM);
        this.dummy.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        this.uninstallListeners((JBreadcrumbBar)jComponent);
        this.uninstallComponents((JBreadcrumbBar)jComponent);
        this.uninstallDefaults((JBreadcrumbBar)jComponent);
        this.breadcrumbBar = null;
    }

    protected void installDefaults(JBreadcrumbBar jBreadcrumbBar) {
        Font font = jBreadcrumbBar.getFont();
        if (font == null || font instanceof UIResource) {
            FontUIResource fontUIResource = FlamingoUtilities.getFont(null, "BreadcrumbBar.font", "Button.font", "Panel.font");
            jBreadcrumbBar.setFont(fontUIResource);
        }
    }

    protected void installComponents(JBreadcrumbBar jBreadcrumbBar) {
        this.mainPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mainPanel.setOpaque(false);
        this.scrollerPanel = new JScrollablePanel<JPanel>(this.mainPanel, JScrollablePanel.ScrollType.HORIZONTALLY);
        jBreadcrumbBar.add(this.scrollerPanel, "Center");
    }

    protected void installListeners(JBreadcrumbBar jBreadcrumbBar) {
        this.atomicCounter = new AtomicInteger(0);
        this.componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                BasicBreadcrumbBarUI.this.updateComponents();
            }
        };
        jBreadcrumbBar.addComponentListener(this.componentListener);
        this.pathListener = new BreadcrumbPathListener(){
            private SwingWorker<Void, Object> pathChangeWorker;

            public void breadcrumbPathEvent(BreadcrumbPathEvent breadcrumbPathEvent) {
                final int n = breadcrumbPathEvent.getIndexOfFirstChange();
                if (this.pathChangeWorker != null && !this.pathChangeWorker.isDone()) {
                    this.pathChangeWorker.cancel(true);
                }
                this.pathChangeWorker = new SwingWorker<Void, Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected Void doInBackground() throws Exception {
                        int n2;
                        BasicBreadcrumbBarUI.this.atomicCounter.incrementAndGet();
                        List list = BasicBreadcrumbBarUI.this;
                        synchronized (list) {
                            if (n == 0) {
                                BasicBreadcrumbBarUI.this.modelStack.clear();
                            } else {
                                n2 = n * 2 + 1;
                                while (BasicBreadcrumbBarUI.this.modelStack.size() > n2) {
                                    BasicBreadcrumbBarUI.this.modelStack.removeLast();
                                }
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                BasicBreadcrumbBarUI.this.updateComponents();
                            }
                        });
                        if (n == 0) {
                            list = BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(null);
                            BreadcrumbItemChoices breadcrumbItemChoices = new BreadcrumbItemChoices(null, list);
                            if (!this.isCancelled()) {
                                this.publish(breadcrumbItemChoices);
                            }
                        }
                        if ((list = BasicBreadcrumbBarUI.this.breadcrumbBar.getModel().getItems()) != null) {
                            for (n2 = n; n2 < list.size() && !this.isCancelled(); ++n2) {
                                BreadcrumbItem breadcrumbItem = (BreadcrumbItem)((Object)list.get(n2));
                                this.publish(breadcrumbItem);
                                ArrayList arrayList = new ArrayList();
                                for (int i = 0; i <= n2; ++i) {
                                    arrayList.add(list.get(i));
                                }
                                BreadcrumbItemChoices breadcrumbItemChoices = new BreadcrumbItemChoices(breadcrumbItem, BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(arrayList));
                                if (breadcrumbItemChoices.getChoices() == null || breadcrumbItemChoices.getChoices().length <= 0) continue;
                                this.publish(breadcrumbItemChoices);
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void process(List<Object> list) {
                        if (list != null) {
                            for (Object object : list) {
                                if (this.isCancelled() || BasicBreadcrumbBarUI.this.atomicCounter.get() > 1) break;
                                if (object instanceof BreadcrumbItemChoices) {
                                    BasicBreadcrumbBarUI.this.pushChoices((BreadcrumbItemChoices)object, false);
                                }
                                if (!(object instanceof BreadcrumbItem)) continue;
                                BasicBreadcrumbBarUI.this.pushChoice((BreadcrumbItem)object, false);
                            }
                        }
                        BasicBreadcrumbBarUI.this.updateComponents();
                    }

                    @Override
                    protected void done() {
                        BasicBreadcrumbBarUI.this.atomicCounter.decrementAndGet();
                    }
                };
                this.pathChangeWorker.execute();
            }
        };
        this.breadcrumbBar.getModel().addPathListener(this.pathListener);
    }

    protected void uninstallDefaults(JBreadcrumbBar jBreadcrumbBar) {
    }

    protected void uninstallComponents(JBreadcrumbBar jBreadcrumbBar) {
        this.mainPanel.removeAll();
        this.buttonStack.clear();
        jBreadcrumbBar.remove(this.scrollerPanel);
    }

    protected void uninstallListeners(JBreadcrumbBar jBreadcrumbBar) {
        jBreadcrumbBar.removeComponentListener(this.componentListener);
        this.componentListener = null;
        this.breadcrumbBar.getModel().removePathListener(this.pathListener);
        this.pathListener = null;
    }

    protected LayoutManager createLayoutManager() {
        return new BreadcrumbBarLayout();
    }

    protected synchronized void updateComponents() {
        if (!this.breadcrumbBar.isVisible()) {
            return;
        }
        this.mainPanel.removeAll();
        this.buttonStack.clear();
        for (int i = 0; i < this.modelStack.size(); ++i) {
            BreadcrumbItemChoices breadcrumbItemChoices;
            BreadcrumbItem[] breadcrumbItemArray;
            JCommandButton jCommandButton;
            Object object;
            Object object2 = this.modelStack.get(i);
            if (object2 instanceof BreadcrumbItemChoices) {
                object = (BreadcrumbItemChoices)object2;
                if (this.buttonStack.isEmpty()) {
                    jCommandButton = new JCommandButton("");
                    jCommandButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                    this.configureBreadcrumbButton(jCommandButton);
                    this.configurePopupAction(jCommandButton, (BreadcrumbItemChoices)object);
                    this.configurePopupRollover(jCommandButton);
                    this.buttonStack.add(jCommandButton);
                    continue;
                }
                jCommandButton = this.buttonStack.getLast();
                int n = jCommandButton.getPreferredSize().width;
                jCommandButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                this.configurePopupAction(jCommandButton, (BreadcrumbItemChoices)object);
                this.configurePopupRollover(jCommandButton);
                continue;
            }
            if (!(object2 instanceof BreadcrumbItem)) continue;
            object = (BreadcrumbItem)object2;
            jCommandButton = new JCommandButton(((BreadcrumbItem)object).getKey());
            this.configureBreadcrumbButton(jCommandButton);
            this.configureMainAction(jCommandButton, (BreadcrumbItem)object);
            final Icon icon = ((BreadcrumbItem)object).getIcon();
            if (icon != null) {
                jCommandButton.setIcon(new ResizableIcon(){
                    int iw;
                    int ih;
                    {
                        this.iw = icon.getIconWidth();
                        this.ih = icon.getIconHeight();
                    }

                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        int n3 = (this.iw - icon.getIconWidth()) / 2;
                        int n4 = (this.ih - icon.getIconHeight()) / 2;
                        icon.paintIcon(component, graphics, n + n3, n2 + n4);
                    }

                    public int getIconWidth() {
                        return this.iw;
                    }

                    public int getIconHeight() {
                        return this.ih;
                    }

                    public void setDimension(Dimension dimension) {
                        this.iw = dimension.width;
                        this.ih = dimension.height;
                    }
                });
            }
            if (i > 0 && (breadcrumbItemArray = (breadcrumbItemChoices = (BreadcrumbItemChoices)this.modelStack.get(i - 1)).getChoices()) != null) {
                for (int j = 0; j < breadcrumbItemArray.length; ++j) {
                    if (!((BreadcrumbItem)object).getKey().equals(breadcrumbItemArray[j].getKey())) continue;
                    breadcrumbItemChoices.setSelectedIndex(j);
                    break;
                }
            }
            this.buttonStack.addLast(jCommandButton);
        }
        for (JCommandButton jCommandButton : this.buttonStack) {
            this.mainPanel.add(jCommandButton);
        }
        this.scrollerPanel.revalidate();
        this.scrollerPanel.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BasicBreadcrumbBarUI.this.scrollerPanel.scrollToIfNecessary(BasicBreadcrumbBarUI.this.mainPanel.getPreferredSize().width, 0);
                BasicBreadcrumbBarUI.this.scrollerPanel.repaint();
            }
        });
    }

    private void configureMainAction(JCommandButton jCommandButton, final BreadcrumbItem breadcrumbItem) {
        jCommandButton.getActionModel().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BreadcrumbBarModel breadcrumbBarModel = BasicBreadcrumbBarUI.this.breadcrumbBar.getModel();
                        int n = breadcrumbBarModel.indexOf(breadcrumbItem);
                        int n2 = n < 0 ? 0 : n + 1;
                        breadcrumbBarModel.setCumulative(true);
                        while (breadcrumbBarModel.getItemCount() > n2) {
                            breadcrumbBarModel.removeLast();
                        }
                        breadcrumbBarModel.setCumulative(false);
                    }
                });
            }
        });
    }

    private void configurePopupAction(JCommandButton jCommandButton, final BreadcrumbItemChoices breadcrumbItemChoices) {
        jCommandButton.setPopupCallback(new PopupPanelCallback(){

            public JPopupPanel getPopupPanel(JCommandButton jCommandButton) {
                JCommandPopupMenu jCommandPopupMenu = new JCommandPopupMenu();
                int n = 0;
                while (n < breadcrumbItemChoices.getChoices().length) {
                    final BreadcrumbItem breadcrumbItem = breadcrumbItemChoices.getChoices()[n];
                    JCommandMenuButton jCommandMenuButton = new JCommandMenuButton(breadcrumbItem.getKey(), null);
                    final Icon icon = breadcrumbItem.getIcon();
                    if (icon != null) {
                        jCommandMenuButton.setIcon(new ResizableIcon(){
                            int iw;
                            int ih;
                            {
                                this.iw = icon.getIconWidth();
                                this.ih = icon.getIconHeight();
                            }

                            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                                int n3 = (this.iw - icon.getIconWidth()) / 2;
                                int n4 = (this.ih - icon.getIconHeight()) / 2;
                                icon.paintIcon(component, graphics, n + n3, n2 + n4);
                            }

                            public int getIconWidth() {
                                return this.iw;
                            }

                            public int getIconHeight() {
                                return this.ih;
                            }

                            public void setDimension(Dimension dimension) {
                                this.iw = dimension.width;
                                this.ih = dimension.height;
                            }
                        });
                    }
                    if (n == breadcrumbItemChoices.getSelectedIndex()) {
                        jCommandMenuButton.setFont(jCommandMenuButton.getFont().deriveFont(1));
                    }
                    final int n2 = n++;
                    jCommandMenuButton.getActionModel().addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    int n;
                                    if (breadcrumbItem == null) {
                                        return;
                                    }
                                    BreadcrumbBarModel breadcrumbBarModel = BasicBreadcrumbBarUI.this.breadcrumbBar.getModel();
                                    breadcrumbBarModel.setCumulative(true);
                                    int n2 = breadcrumbBarModel.indexOf(breadcrumbItemChoices.getAncestor());
                                    int n3 = n = breadcrumbItemChoices.getAncestor() == null || n2 < 0 ? 0 : n2 + 1;
                                    while (breadcrumbBarModel.getItemCount() > n) {
                                        breadcrumbBarModel.removeLast();
                                    }
                                    breadcrumbBarModel.addLast(breadcrumbItem);
                                    breadcrumbItemChoices.setSelectedIndex(n2);
                                    breadcrumbBarModel.setCumulative(false);
                                }
                            });
                        }
                    });
                    jCommandPopupMenu.addMenuButton(jCommandMenuButton);
                    jCommandMenuButton.setCursor(Cursor.getPredefinedCursor(12));
                }
                jCommandPopupMenu.setMaxVisibleMenuButtons(10);
                return jCommandPopupMenu;
            }
        });
    }

    private void configurePopupRollover(final JCommandButton jCommandButton) {
        jCommandButton.getPopupModel().addChangeListener(new ChangeListener(){
            boolean rollover;
            {
                this.rollover = jCommandButton.getPopupModel().isRollover();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        boolean bl = jCommandButton.getPopupModel().isRollover();
                        if (bl == rollover) {
                            return;
                        }
                        if (bl) {
                            for (JCommandButton jCommandButton : BasicBreadcrumbBarUI.this.buttonStack) {
                                if (jCommandButton == jCommandButton || !jCommandButton.getPopupModel().isPopupShowing()) continue;
                                BasicBreadcrumbBarUI.this.scrollerPanel.scrollToIfNecessary(jCommandButton.getBounds().x, jCommandButton.getWidth());
                                jCommandButton.doPopupClick();
                            }
                        }
                        rollover = bl;
                    }
                });
            }
        });
    }

    private void configureBreadcrumbButton(final JCommandButton jCommandButton) {
        jCommandButton.setDisplayState(CommandButtonDisplayState.MEDIUM);
        jCommandButton.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
        jCommandButton.setHGapScaleFactor(0.75);
        jCommandButton.getPopupModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PopupButtonModel popupButtonModel = jCommandButton.getPopupModel();
                boolean bl = popupButtonModel.isRollover() || popupButtonModel.isPopupShowing();
                JCommandButton.CommandButtonPopupOrientationKind commandButtonPopupOrientationKind = bl ? JCommandButton.CommandButtonPopupOrientationKind.DOWNWARD : JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD;
                jCommandButton.setPopupOrientationKind(commandButtonPopupOrientationKind);
            }
        });
    }

    protected Object pushChoices(BreadcrumbItemChoices breadcrumbItemChoices) {
        return this.pushChoices(breadcrumbItemChoices, true);
    }

    protected synchronized Object pushChoices(BreadcrumbItemChoices breadcrumbItemChoices, boolean bl) {
        if (breadcrumbItemChoices == null) {
            return null;
        }
        if (this.modelStack.size() % 2 == 1) {
            this.modelStack.pop();
        }
        this.modelStack.addLast(breadcrumbItemChoices);
        if (bl) {
            this.updateComponents();
        }
        return breadcrumbItemChoices;
    }

    protected synchronized Object pushChoice(BreadcrumbItem breadcrumbItem, boolean bl) {
        assert (breadcrumbItem != null);
        if (!this.modelStack.isEmpty() && this.modelStack.size() % 2 == 0) {
            this.modelStack.pop();
        }
        breadcrumbItem.setIndex(this.modelStack.size());
        this.modelStack.addLast(breadcrumbItem);
        return breadcrumbItem;
    }

    protected class BreadcrumbBarLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = BasicBreadcrumbBarUI.this.dummy.getPreferredSize().height;
            Insets insets = container.getInsets();
            return new Dimension(container.getWidth(), n + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n = BasicBreadcrumbBarUI.this.dummy.getPreferredSize().height;
            return new Dimension(10, n);
        }

        public void layoutContainer(Container container) {
            int n = container.getWidth();
            int n2 = container.getHeight();
            BasicBreadcrumbBarUI.this.scrollerPanel.setBounds(0, 0, n, n2);
        }
    }
}

