/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class DataExportUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("DataExport <filename> <output directory>");
        } else {
            Connection connection = null;
            try {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                String string = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + stringArray[0];
                connection = DriverManager.getConnection(string);
                DataExportUtility dataExportUtility = new DataExportUtility();
                dataExportUtility.process(connection, stringArray[1]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    public void process(Connection connection, String string) throws Exception {
        connection.setAutoCommit(true);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String[] stringArray = new String[]{"TABLE"};
        FileWriter fileWriter = new FileWriter(string);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println();
        printWriter.println("<database>");
        ResultSet resultSet = databaseMetaData.getTables(null, null, null, stringArray);
        while (resultSet.next()) {
            this.processTable(printWriter, connection, resultSet.getString("TABLE_NAME"));
        }
        printWriter.println("</database>");
        printWriter.close();
        resultSet.close();
    }

    private void processTable(PrintWriter printWriter, Connection connection, String string) throws Exception {
        int n;
        System.out.println("Processing " + string);
        PreparedStatement preparedStatement = connection.prepareStatement("select * from " + string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = resultSetMetaData.getColumnName(n + 1);
            nArray[n] = resultSetMetaData.getColumnType(n + 1);
            if (nArray[n] != 2) continue;
            nArray2[n] = resultSetMetaData.getPrecision(n + 1);
            nArray3[n] = resultSetMetaData.getScale(n + 1);
        }
        printWriter.println("<table name=\"" + string + "\">");
        StringBuilder stringBuilder = new StringBuilder(255);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm", Locale.UK);
        while (resultSet.next()) {
            printWriter.println(" <row>");
            block8: for (n = 0; n < n2; ++n) {
                switch (nArray[n]) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        printWriter.print("  <column name=\"" + stringArray[n] + "\" type=\"" + nArray[n] + "\">");
                        printWriter.println("[BINARY DATA]");
                        printWriter.println("</column>");
                        continue block8;
                    }
                    case 91: 
                    case 92: {
                        Object object = resultSet.getDate(n + 1);
                        printWriter.print("  <column name=\"" + stringArray[n] + "\" type=\"" + nArray[n] + "\">");
                        if (object != null) {
                            printWriter.print(simpleDateFormat.format((Date)object));
                        }
                        printWriter.println("</column>");
                        continue block8;
                    }
                    case 93: {
                        Object object = resultSet.getTimestamp(n + 1);
                        printWriter.print("  <column name=\"" + stringArray[n] + "\" type=\"" + nArray[n] + "\">");
                        if (object != null) {
                            printWriter.print(((Timestamp)object).toString());
                        }
                        printWriter.println("</column>");
                        continue block8;
                    }
                    case 2: {
                        Object object = resultSet.getString(n + 1);
                        int n3 = 2;
                        int n4 = nArray2[n];
                        int n5 = nArray3[n];
                        if (n5 == 0) {
                            if (n4 == 10) {
                                n3 = 4;
                            } else if (n4 == 5) {
                                n3 = 5;
                            } else if (n4 == 1) {
                                n3 = -7;
                            }
                        } else if (n4 > 125) {
                            n3 = 8;
                        }
                        printWriter.print("  <column name=\"" + stringArray[n] + "\" type=\"" + n3 + "\">");
                        if (object != null) {
                            printWriter.print((String)object);
                        }
                        printWriter.println("</column>");
                        continue block8;
                    }
                    default: {
                        Object object = resultSet.getString(n + 1);
                        printWriter.print("  <column name=\"" + stringArray[n] + "\" type=\"" + nArray[n] + "\">");
                        if (object != null) {
                            printWriter.print(this.escapeText(stringBuilder, (String)object));
                        }
                        printWriter.println("</column>");
                        continue block8;
                    }
                }
            }
            printWriter.println(" </row>");
        }
        printWriter.println("</table>");
        preparedStatement.close();
    }

    private String escapeText(StringBuilder stringBuilder, String string) {
        int n = string.length();
        stringBuilder.setLength(0);
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block5;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block5;
                }
                default: {
                    if (!this.validXMLCharacter(c)) continue block5;
                    if (c > '\u007f') {
                        stringBuilder.append("&#" + c + ";");
                        continue block5;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private boolean validXMLCharacter(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
    }
}

