/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Record {
    private String m_field;
    private String m_value;
    private List<Record> m_records = new ArrayList<Record>();
    private static final String SEPARATOR = new String(new byte[]{127, 127});

    protected Record(String string) {
        this(string, 0, string.length());
    }

    protected Record(String string, int n, int n2) {
        this.parse(string, n, n2);
    }

    public String getField() {
        return this.m_field;
    }

    public String getValue() {
        return this.m_value;
    }

    public List<Record> getChildren() {
        return this.m_records;
    }

    public Record getChild(String string) {
        Record record = null;
        if (string != null) {
            for (Record record2 : this.m_records) {
                if (!string.equals(record2.getField())) continue;
                record = record2;
                break;
            }
        }
        return record;
    }

    private void parse(String string, int n, int n2) {
        int n3 = this.getClosingParenthesisPosition(string, n);
        if (n3 == -1 || n3 > n2) {
            throw new IllegalStateException("Error in parenthesis hierarchy");
        }
        if (!string.startsWith("(0||")) {
            throw new IllegalStateException("Not a valid record");
        }
        int n4 = this.getNextOpeningParenthesisPosition(string, n);
        int n5 = this.getClosingParenthesisPosition(string, n4);
        int n6 = this.getNextOpeningParenthesisPosition(string, n5);
        int n7 = this.getClosingParenthesisPosition(string, n6);
        this.parse(string, n + 4, n4, n5, n6, n7);
    }

    private void parse(String string, int n, int n2, int n3, int n4, int n5) {
        this.m_field = string.substring(n, n2);
        this.m_value = n3 - n2 <= 1 ? null : string.substring(n2 + 1, n3);
        if (n5 - n4 > 1) {
            int n6 = this.getNextOpeningParenthesisPosition(string, n4);
            while (n6 >= 0 && n6 < n5) {
                int n7 = this.getClosingParenthesisPosition(string, n6);
                this.m_records.add(new Record(string, n6, n7));
                n6 = this.getNextOpeningParenthesisPosition(string, n7);
            }
        }
    }

    private int getClosingParenthesisPosition(String string, int n) {
        if (string.charAt(n) != '(') {
            return -1;
        }
        int n2 = 0;
        block4: for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '(': {
                    ++n2;
                    continue block4;
                }
                case ')': {
                    if (--n2 != 0) continue block4;
                    return i;
                }
            }
        }
        return -1;
    }

    private int getNextOpeningParenthesisPosition(String string, int n) {
        return string.indexOf(40, n + 1);
    }

    public String toString() {
        return this.toString(1);
    }

    protected String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder("(0||" + (this.m_field == null ? "" : this.m_field) + "(" + (this.m_value == null ? "" : this.m_value) + ")(");
        for (Record record : this.m_records) {
            if (n != 0) {
                stringBuilder.append(SEPARATOR);
                for (int i = 0; i < n * 2; ++i) {
                    stringBuilder.append(" ");
                }
            }
            stringBuilder.append(record.toString(n + 1));
        }
        stringBuilder.append("))");
        return stringBuilder.toString();
    }
}

