/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.math.BigInteger;

public final class NumberHelper {
    public static final Double DOUBLE_ZERO = 0.0;

    public static final int getInt(Number number) {
        return number == null ? 0 : number.intValue();
    }

    public static final int getInt(String string) {
        return string == null || string.length() == 0 ? 0 : Integer.parseInt(string);
    }

    public static final Integer getInteger(Number number) {
        Integer n = null;
        if (number != null) {
            n = number instanceof Integer ? (Integer)number : Integer.valueOf((int)Math.round(number.doubleValue()));
        }
        return n;
    }

    public static final Integer getInteger(String string) {
        Integer n;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = null;
        }
        return n;
    }

    public static final BigInteger getBigInteger(Number number) {
        BigInteger bigInteger = null;
        if (number != null) {
            bigInteger = number instanceof BigInteger ? (BigInteger)number : BigInteger.valueOf(Math.round(number.doubleValue()));
        }
        return bigInteger;
    }

    public static final double getDouble(Number number) {
        return number == null ? 0.0 : number.doubleValue();
    }

    public static final Double getDouble(double d) {
        return d == 0.0 ? DOUBLE_ZERO : Double.valueOf(d);
    }

    public static final double truncate(double d, double d2) {
        d2 = Math.pow(10.0, d2);
        double d3 = d > 0.0 ? Math.floor(d * d2) / d2 : Math.ceil(d * d2) / d2;
        return d3;
    }

    public static final Integer parseInteger(String string) {
        return string == null || string.length() == 0 ? null : Integer.valueOf(Integer.parseInt(string));
    }

    public static boolean equals(Number number, Number number2) {
        boolean bl = false;
        if (number == null && number2 == null) {
            bl = true;
        } else if (number != null && number2 != null) {
            bl = number.equals(number2);
        }
        return bl;
    }

    public static boolean equals(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }
}

