/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

public class QuotedStringTokenizer {
    private final String m_content;
    private final int m_contentLength;
    private final String m_delimiters;
    private final char m_quoteChar;
    private int m_index = 0;

    public QuotedStringTokenizer(String content, String delimiters, char quoteCharacter) {
        this.m_content = content;
        this.m_delimiters = delimiters;
        this.m_quoteChar = quoteCharacter;
        this.m_contentLength = this.m_content.length();
        while (this.isDelimiter(this.m_content.charAt(this.m_index)) && this.m_index < this.m_contentLength) {
            ++this.m_index;
        }
    }

    public String nextToken() {
        StringBuffer sb = new StringBuffer();
        while (this.m_index < this.m_contentLength) {
            char c = this.m_content.charAt(this.m_index);
            if (c == this.m_quoteChar) {
                ++this.m_index;
                if (this.m_index < this.m_contentLength) {
                    sb.append(this.m_content.charAt(this.m_index));
                }
            } else {
                if (this.isDelimiter(c)) {
                    do {
                        ++this.m_index;
                    } while (this.m_index < this.m_contentLength && this.isDelimiter(this.m_content.charAt(this.m_index)));
                    return sb.toString();
                }
                sb.append(c);
            }
            ++this.m_index;
        }
        return sb.toString();
    }

    private boolean isDelimiter(char c) {
        return this.m_delimiters.indexOf(c) >= 0;
    }

    public boolean hasMoreTokens() {
        return this.m_index < this.m_contentLength;
    }
}

