/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToTeXstudio
implements PushToApplication {
    private final String defaultCiteCommand = "\\cite";
    private JPanel settings = null;
    private JTextField citeCommand = new JTextField(30);
    private JTextField progPath = new JTextField(30);
    private boolean couldNotConnect = false;
    private boolean couldNotRunClient = false;

    @Override
    public String getName() {
        return Globals.lang("Insert selected citations into TeXstudio");
    }

    @Override
    public String getApplicationName() {
        return "TeXstudio";
    }

    @Override
    public String getTooltip() {
        return Globals.lang("Push selection to TeXstudio");
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("texstudio");
    }

    @Override
    public String getKeyStrokeName() {
        return "Push to TeXstudio";
    }

    protected String defaultProgramPath() {
        if (Globals.ON_WIN) {
            String progFiles = System.getenv("ProgramFiles(x86)");
            if (progFiles == null) {
                progFiles = System.getenv("ProgramFiles");
            }
            return progFiles + "\\texstudio\\texstudio.exe";
        }
        return "texstudio";
    }

    @Override
    public JPanel getSettingsPanel() {
        String citeCom;
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        if ((citeCom = Globals.prefs.get("citeCommandTeXstudio")) == null) {
            citeCom = "\\cite";
        }
        this.citeCommand.setText(citeCom);
        String programPath = Globals.prefs.get("TeXstudioPath");
        if (programPath == null) {
            programPath = this.defaultProgramPath();
        }
        this.progPath.setText(programPath);
        return this.settings;
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("citeCommandTeXstudio", this.citeCommand.getText().trim());
        Globals.prefs.put("TeXstudioPath", this.progPath.getText().trim());
    }

    private void initSettingsPanel() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
        builder.append(Globals.lang("Cite command") + ":");
        builder.append(this.citeCommand);
        builder.nextLine();
        builder.append(Globals.lang("Path to TeXstudio") + ":");
        builder.append(this.progPath);
        this.settings = builder.getPanel();
    }

    @Override
    public void pushEntries(BibtexDatabase database, BibtexEntry[] entries, String keys, MetaData metaData) {
        String programPath;
        this.couldNotConnect = false;
        this.couldNotRunClient = false;
        String citeCom = Globals.prefs.get("citeCommandTeXstudio");
        if (citeCom == null) {
            citeCom = "\\cite";
        }
        if ((programPath = Globals.prefs.get("TeXstudioPath")) == null) {
            programPath = this.defaultProgramPath();
        }
        try {
            String[] stringArray;
            if (Globals.ON_WIN) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = programPath;
                stringArray2[1] = "--insert-cite";
                stringArray = stringArray2;
                stringArray2[2] = citeCom + "{" + keys + "}";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = programPath;
                stringArray3[1] = "--insert-cite";
                stringArray = stringArray3;
                stringArray3[2] = citeCom + "{" + keys + "}";
            }
            String[] com = stringArray;
            final Process p = Runtime.getRuntime().exec(com);
            System.out.println(keys);
            Runnable errorListener = new Runnable(){

                @Override
                public void run() {
                    InputStream out = p.getErrorStream();
                    StringBuffer sb = new StringBuffer();
                    try {
                        int c;
                        while ((c = out.read()) != -1) {
                            sb.append((char)c);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (sb.toString().trim().length() > 0) {
                        PushToTeXstudio.this.couldNotConnect = true;
                        return;
                    }
                }
            };
            Thread t = new Thread(errorListener);
            t.start();
            t.join();
        }
        catch (IOException excep) {
            this.couldNotRunClient = true;
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void operationCompleted(BasePanel panel) {
        if (this.couldNotConnect) {
            JOptionPane.showMessageDialog(panel.frame(), "TeXstudio: could not connect", Globals.lang("Error"), 0);
        } else if (this.couldNotRunClient) {
            String programPath = Globals.prefs.get("TeXstudioPath");
            if (programPath == null) {
                programPath = this.defaultProgramPath();
            }
            JOptionPane.showMessageDialog(panel.frame(), "TeXstudio: " + Globals.lang("Program '%0' not found", programPath), Globals.lang("Error"), 0);
        } else {
            panel.output(Globals.lang("Pushed citations to TeXstudio"));
        }
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }
}

