/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: server.h 112 2009-03-15 17:30:28Z loos-br $
 */

#ifndef SERVER_H
#define SERVER_H

#include <sys/types.h>
#include <sys/time.h>

#include <event.h>

#include "command.h"

typedef struct server__ {
    int			fd;
    string		host;
    string		port;
    commands		commands;
    struct event	read;
    struct event	write;
} server_;

void server_close(server_ *server);
server_ *server_disconnect(server_ *server);
server_ *server_alloc(void);
void server_sched_read(server_ *server);
void server_sched_write(server_ *server);
server_ *server_connect2(string *host,
                         void (*fn_read)(int, short, void *),
                         void (*fn_write)(int, short, void *),
                         void *arg);
server_ *server_connect( string *host, string *port,
                         void (*fn_read)(int, short, void *),
                         void (*fn_write)(int, short, void *),
                         void *arg);
int server_real_connect(server_ *server,
                        void (*fn_read)(int, short, void *),
                        void (*fn_write)(int, short, void *),
                        void *arg);
void shift_server_commands(server_ *server, command *cmd);
int read_server_command(server_ *server, void (*sched_write)(), void *ev_write);
int	server_flush_commands(server_ *server);

#endif
