/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: sb-data.h 96 2009-01-20 15:34:19Z loos-br $
 */

#ifndef SB_DATA_H
#define SB_DATA_H

#include <sys/time.h>

#include <event.h>

#include "queue.h"
#include "client.h"
#include "server.h"

struct sb_user_ {
    SLIST_ENTRY(sb_user_)	sb_user__;
    string			email;
};

struct sb_users {
    struct sb_user_		*slh_first;	/* first element */
};

struct sb_ {
    struct sb_users	sb_users;	/* list of connected users */
    LIST_ENTRY(sb_)	sb__;		/* sb list */
    struct event        listen;		/* listen event */
    struct user_	*user;		/* pointer to user */

    __uint32_t		id;		/* sql chat id */
    __uint32_t		warned;		/* warned about message logging */
    __uint32_t		closed;		/* need to log stop at disconnect ? */

    server_             *server;	/* sb server data */
    client_             *client;	/* sb client data */

    string              start;
    string              *xfr;
};

struct sbs {
    struct sb_		*lh_first;	/* first element */
};

#endif
