// Generated by IcedCoffeeScript 1.7.1-g
(function() {
  var AltKeyRing, Config, a_json_parse, base64u, chain, constants, fs, fullname, home, iced, iutils, keyring, kpath, log, make_esc, mkdir_p, path, prng, request, set_gpg_cmd, tmpdir, url_join, __iced_k, __iced_k_noop, _ref, _ref1, _ref2,
    __slice = [].slice;

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  constants = require('./constants').constants;

  fullname = require('./package').fullname;

  request = require('./request').request;

  log = require('./log');

  tmpdir = require('os').tmpdir;

  fs = require('fs');

  _ref = require('iced-error'), chain = _ref.chain, make_esc = _ref.make_esc;

  iutils = require('iced-utils');

  _ref1 = iutils.util, a_json_parse = _ref1.a_json_parse, base64u = _ref1.base64u;

  mkdir_p = iutils.fs.mkdir_p;

  prng = require('crypto').prng;

  path = require('path');

  _ref2 = require('gpg-wrapper'), set_gpg_cmd = _ref2.set_gpg_cmd, keyring = _ref2.keyring;

  AltKeyRing = keyring.AltKeyRing;

  kpath = require('keybase-path');

  url_join = function() {
    var a, args, parts, rxx, trim;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    rxx = /^(\/*)(.*?)(\/*)$/;
    trim = function(s) {
      var m;
      if ((m = s.match(rxx)) != null) {
        return m[2];
      } else {
        return s;
      }
    };
    parts = (function() {
      var _i, _len, _results;
      _results = [];
      for (_i = 0, _len = args.length; _i < _len; _i++) {
        a = args[_i];
        _results.push(trim(a));
      }
      return _results;
    })();
    return parts.join('/');
  };

  home = function(opts) {
    var x;
    x = kpath.home(opts);
    return x;
  };

  exports.Config = Config = (function() {
    function Config(argv) {
      this.argv = argv;
      this._tmpdir = null;
      this._alt_cmds = {};
      this._keyring_dir = null;
      this._actual_prefix = null;
    }

    Config.prototype.set_actual_prefix = function(p) {
      return this._actual_prefix = p;
    };

    Config.prototype.get_keyring_dir = function() {
      var d, v;
      if (this._keyring_dir == null) {
        if (!((d = this.argv.get("k", "keyring-dir")) != null)) {
          v = (home({
            array: true
          })).concat([".keybase-installer", "keyring"]);
          d = kpath.unsplit(v);
        }
        this._keyring_dir = d;
      }
      return this._keyring_dir;
    };

    Config.prototype.init_keyring = function(cb) {
      var dir, esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      keyring.init({
        log: log,
        get_tmp_keyring_dir: (function(_this) {
          return function() {
            return _this.get_tmpdir();
          };
        })(this),
        get_no_options: (function(_this) {
          return function() {
            return _this.get_no_gpg_options();
          };
        })(this)
      });
      dir = this.get_keyring_dir();
      esc = make_esc(cb, "Config::init_keyring");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-installer/src/config.iced",
            funcname: "Config.init_keyring"
          });
          AltKeyRing.make(dir, esc(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                return __slot_1._master_ring = arguments[0];
              };
            })(_this),
            lineno: 66
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-installer/src/config.iced",
              funcname: "Config.init_keyring"
            });
            _this._master_ring.index(esc(__iced_deferrals.defer({
              assign_fn: (function(__slot_1) {
                return function() {
                  return __slot_1._keyring_index = arguments[0];
                };
              })(_this),
              lineno: 67
            })));
            __iced_deferrals._fulfill();
          })(function() {
            return cb(null);
          });
        };
      })(this));
    };

    Config.prototype.keyring_index = function() {
      return this._keyring_index;
    };

    Config.prototype.master_ring = function() {
      return this._master_ring;
    };

    Config.prototype.set_master_ring = function(r, cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      this._master_ring = r;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-installer/src/config.iced",
            funcname: "Config.set_master_ring"
          });
          _this._master_ring.index(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1._keyring_index = arguments[1];
              };
            })(_this),
            lineno: 79
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Config.prototype.url_prefix = function() {
      var prot, u;
      if ((u = this.argv.get("u", "url-prefix"))) {
        return u;
      } else {
        prot = this.argv.get("S", "no-https") ? 'http' : 'https';
        return constants.url_prefix[prot];
      }
    };

    Config.prototype.install_prefix = function() {
      return process.env.PREFIX || this.argv.get("p", "prefix");
    };

    Config.prototype.make_url = function(u) {
      return url_join(this.url_prefix(), u);
    };

    Config.prototype.get_tmpdir = function() {
      return this._tmpdir;
    };

    Config.prototype.get_no_gpg_options = function() {
      return this.argv.get("O", "no-gpg-options");
    };

    Config.prototype.make_tmpdir = function(cb) {
      var err, p, r, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (_this._tmpdir == null) {
            r = base64u.encode(prng(16));
            p = kpath.split(tmpdir()).concat(["keybase_install_" + r]);
            _this._tmpdir = kpath.unsplit(p);
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-installer/src/config.iced",
                funcname: "Config.make_tmpdir"
              });
              fs.mkdir(_this._tmpdir, 0x1c0, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 111
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(log.info("Made temporary directory: " + _this._tmpdir));
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Config.prototype.cleanup = function(cb) {
      var esc, f, files, p, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Installer::cleanup");
      log.debug("+ cleanup " + this._tmpdir);
      (function(_this) {
        return (function(__iced_k) {
          if (_this._tmpdir == null) {
            return __iced_k();
          } else {
            (function(__iced_k) {
              if (_this.argv.get("C", "skip-cleanup")) {
                return __iced_k(log.info("Preserving tmpdir " + _this._tmpdir + " as per command-line switch"));
              } else {
                log.info("cleaning up tmpdir " + _this._tmpdir);
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-installer/src/config.iced",
                    funcname: "Config.cleanup"
                  });
                  fs.readdir(_this._tmpdir, esc(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return files = arguments[0];
                      };
                    })(),
                    lineno: 125
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  (function(__iced_k) {
                    var _i, _len, _ref3, _results, _while;
                    _ref3 = files;
                    _len = _ref3.length;
                    _i = 0;
                    _results = [];
                    _while = function(__iced_k) {
                      var _break, _continue, _next;
                      _break = function() {
                        return __iced_k(_results);
                      };
                      _continue = function() {
                        return iced.trampoline(function() {
                          ++_i;
                          return _while(__iced_k);
                        });
                      };
                      _next = function(__iced_next_arg) {
                        _results.push(__iced_next_arg);
                        return _continue();
                      };
                      if (!(_i < _len)) {
                        return _break();
                      } else {
                        f = _ref3[_i];
                        p = kpath.join(_this._tmpdir, f);
                        log.debug("| Unlink " + p);
                        (function(__iced_k) {
                          __iced_deferrals = new iced.Deferrals(__iced_k, {
                            parent: ___iced_passed_deferral,
                            filename: "/Users/max/src/keybase/node-installer/src/config.iced",
                            funcname: "Config.cleanup"
                          });
                          fs.unlink(p, esc(__iced_deferrals.defer({
                            lineno: 129
                          })));
                          __iced_deferrals._fulfill();
                        })(_next);
                      }
                    };
                    _while(__iced_k);
                  })(function() {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/Users/max/src/keybase/node-installer/src/config.iced",
                        funcname: "Config.cleanup"
                      });
                      fs.rmdir(_this._tmpdir, esc(__iced_deferrals.defer({
                        lineno: 130
                      })));
                      __iced_deferrals._fulfill();
                    })(__iced_k);
                  });
                });
              }
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- cleanup " + _this._tmpdir + " -> OK");
          return cb(null);
        };
      })(this));
    };

    Config.prototype.get_proxy = function() {
      return this.argv.get("x", "proxy") || process.env.https_proxy || process.env.http_proxy;
    };

    Config.prototype.request = function(u, cb) {
      var body, err, opts, res, url, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      url = u.match("^https?://") ? u : this.make_url(u);
      opts = {
        url: url,
        headers: {
          "X-Keybase-Installer": fullname()
        },
        maxRedirects: 10,
        progress: 50000,
        proxy: this.get_proxy()
      };
      log.info("Fetching URL " + url);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-installer/src/config.iced",
            funcname: "Config.request"
          });
          request(opts, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                res = arguments[1];
                return body = arguments[2];
              };
            })(),
            lineno: 150
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          log.debug(" * fetched -> " + (typeof res !== "undefined" && res !== null ? res.statusCode : void 0));
          return cb(err, res, body);
        };
      })(this));
    };

    Config.prototype.set_keys = function(keys) {
      if ((this._keys == null) || this._keys.version !== keys.version) {
        log.info("Using keyset version v" + keys.version);
        return this._keys = keys;
      }
    };

    Config.prototype.set_alt_cmds = function() {
      this.set_alt_gpg();
      return this.set_alt_npm();
    };

    Config.prototype.set_alt_gpg = function() {
      var c;
      if ((c = this.argv.get("g", "gpg")) != null) {
        return this._alt_cmds.gpg = c;
      } else {
        return null;
      }
    };

    Config.prototype.set_alt_npm = function() {
      var n;
      if ((n = this.argv.get("n", "npm")) != null) {
        return this._alt_cmds.npm = n;
      }
    };

    Config.prototype.get_alt_cmd = function(k) {
      return this._alt_cmds[k];
    };

    Config.prototype.get_cmd = function(k) {
      return this.get_alt_cmd(k) || k;
    };

    Config.prototype.key_version = function() {
      return this._keys.version;
    };

    Config.prototype.set_index = function(i) {
      return this._index = i;
    };

    Config.prototype.index = function() {
      return this._index;
    };

    Config.prototype.index_lookup_hash = function(v) {
      var _ref3, _ref4;
      return (_ref3 = this._index["package"]) != null ? (_ref4 = _ref3.all) != null ? _ref4[v] : void 0 : void 0;
    };

    Config.prototype.oneshot_verify = function(_arg, cb) {
      var err, file, json, query, sig, which, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      which = _arg.which, sig = _arg.sig, file = _arg.file;
      query = this._keys[which].fingerprint();
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-installer/src/config.iced",
            funcname: "Config.oneshot_verify"
          });
          _this.master_ring().oneshot_verify({
            query: query,
            file: file,
            sig: sig,
            single: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return json = arguments[1];
              };
            })(),
            lineno: 203
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, json);
        };
      })(this));
    };

    return Config;

  })();

}).call(this);
