// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var Basefile, C, E, Infile, Outfile, Queue, Stdout, base58, concat, constants, crypto, fix_stat, fs, iced, log, make_esc, msgpack_packed_numlen, purepack, tmp_filename, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __slice = [].slice;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  fs = require('fs');

  log = require('./log');

  constants = require('./constants').constants;

  base58 = require('./basex').base58;

  crypto = require('crypto');

  C = require('constants');

  make_esc = require('iced-error').make_esc;

  purepack = require('purepack');

  E = require('./err').E;

  fix_stat = function(stat) {
    var f, _i, _len, _ref;
    _ref = ["ctime", "mtime", "atime"];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      f = _ref[_i];
      stat[f] = Math.floor(stat[f].getTime() / 1000);
    }
    return stat;
  };

  msgpack_packed_numlen = function(byt) {
    if (byt < 0x80) {
      return 1;
    } else if (byt === 0xcc) {
      return 2;
    } else if (byt === 0xcd) {
      return 3;
    } else if (byt === 0xce) {
      return 5;
    } else if (byt === 0xcf) {
      return 9;
    } else {
      return 0;
    }
  };

  exports.tmp_filename = tmp_filename = function(stem) {
    var ext;
    ext = base58.encode(crypto.rng(8));
    return [stem, ext].join('.');
  };

  exports.Basefile = Basefile = (function() {
    function Basefile(_arg) {
      this.fd = _arg.fd;
      if (this.fd == null) {
        this.fd = -1;
      }
      this.i = 0;
    }

    Basefile.prototype.offset = function() {
      return this.i;
    };

    Basefile.prototype.close = function() {
      if ((this.fd != null) >= 0) {
        fs.close(this.fd);
        this.fd = -1;
        return this.i = 0;
      }
    };

    return Basefile;

  })();

  exports.Stdout = Stdout = (function(_super) {
    __extends(Stdout, _super);

    function Stdout() {
      this.filename = "<stdout>";
      this.pos = 0;
      this.stream = process.stdout;
    }

    Stdout.prototype._open = function(cb) {
      return cb(null);
    };

    Stdout.prototype.close = function() {};

    Stdout.open = function(_arg, cb) {
      var file;
      _arg;
      file = new Stdout();
      return cb(err, file);
    };

    Stdout.prototype.finish = function(ok, cb) {
      return cb(null);
    };

    Stdout.prototype.write = function(block, cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          if (block.offset !== _this.pos) {
            return __iced_k(err = new E.InvalError("Can't seek stdout"));
          } else {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/file.iced",
                funcname: "Stdout.write"
              });
              _this.stream.write(block.buf, null, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 80
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(_this.pos += block.buf.length);
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    return Stdout;

  })(Basefile);

  exports.Outfile = Outfile = (function(_super) {
    __extends(Outfile, _super);

    function Outfile(_arg) {
      this.target = _arg.target, this.mode = _arg.mode;
      Outfile.__super__.constructor.call(this, {});
      if (this.mode == null) {
        this.mode = 0x1a4;
      }
      this.tmpname = tmp_filename(this.target);
      this.renamed = false;
      this.buf = null;
      this.i = 0;
    }

    Outfile.open = function(_arg, cb) {
      var err, file, mode, target, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      target = _arg.target, mode = _arg.mode;
      file = target != null ? new Outfile({
        target: target,
        mode: mode
      }) : new Stdout({});
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/file.iced",
            funcname: "Outfile.open"
          });
          file._open(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 103
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            file = null;
          }
          return cb(err, file);
        };
      })(this));
    };

    Outfile.prototype._open = function(cb) {
      var esc, flags, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Open " + this.target + " for writing");
      flags = C.O_WRONLY | C.O_TRUNC | C.O_EXCL | C.O_CREAT;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/file.iced",
            funcname: "Outfile._open"
          });
          fs.open(_this.tmpname, flags, _this.mode, esc(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                return __slot_1.fd = arguments[0];
              };
            })(_this),
            lineno: 112
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/file.iced",
              funcname: "Outfile._open"
            });
            fs.realpath(_this.tmpname, esc(__iced_deferrals.defer({
              assign_fn: (function(__slot_1) {
                return function() {
                  return __slot_1.realpath = arguments[0];
                };
              })(_this),
              lineno: 113
            })));
            __iced_deferrals._fulfill();
          })(function() {
            return cb(null);
          });
        };
      })(this));
    };

    Outfile.prototype._rename = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/file.iced",
            funcname: "Outfile._rename"
          });
          fs.rename(_this.tmpname, _this.target, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 119
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            log.error("Failed to rename temporary file: " + err);
          } else {
            _this.renamed = true;
          }
          return cb(typeof err === "undefined" || err === null);
        };
      })(this));
    };

    Outfile.prototype.finish = function(success, cb) {
      var ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      this.close();
      (function(_this) {
        return (function(__iced_k) {
          if (success) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/file.iced",
                funcname: "Outfile.finish"
              });
              _this._rename(__iced_deferrals.defer({
                lineno: 130
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/file.iced",
              funcname: "Outfile.finish"
            });
            _this._cleanup(__iced_deferrals.defer({
              lineno: 131
            }));
            __iced_deferrals._fulfill();
          })(function() {
            return cb();
          });
        };
      })(this));
    };

    Outfile.prototype._cleanup = function(cb) {
      var err, ok, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      ok = false;
      (function(_this) {
        return (function(__iced_k) {
          if (!_this.renamed) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/file.iced",
                funcname: "Outfile._cleanup"
              });
              fs.unlink(_this.tmpname, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 139
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(typeof err !== "undefined" && err !== null ? (log.error("failed to remove temporary file: " + err), ok = false) : void 0);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(ok);
        };
      })(this));
    };

    Outfile.prototype.write = function(block, cb) {
      var b, err, l, nw, o, ok, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      ok = false;
      l = block.buf.length;
      b = block.buf;
      o = block.offset;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/file.iced",
            funcname: "Outfile.write"
          });
          fs.write(_this.fd, b, 0, l, o, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return nw = arguments[1];
              };
            })(),
            lineno: 152
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            err = new E.BadIoError("In writing " + _this.tmpname + "@" + o + ": " + err);
          } else if (nw !== l) {
            err = new E.BadIoError("Short write in " + _this.tmpname + ": " + nw + " != " + l);
          }
          return cb(err);
        };
      })(this));
    };

    return Outfile;

  })(Basefile);

  exports.Infile = Infile = (function(_super) {
    __extends(Infile, _super);

    function Infile(_arg) {
      this.stat = _arg.stat, this.realpath = _arg.realpath, this.filename = _arg.filename, this.fd = _arg.fd;
      Infile.__super__.constructor.call(this, {
        fd: this.fd
      });
      this.buf = null;
      this.eof = false;
    }

    Infile.prototype.more_to_go = function() {
      return !this.eof;
    };

    Infile.prototype.size = function() {
      if (!this.stat) {
        throw new E.InternalError("file is not opened");
      }
      return this.stat.size;
    };

    Infile.prototype.read = function(offset, n, cb) {
      var br, err, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      ret = null;
      if (((_ref = this.buf) != null ? _ref.length : void 0) !== n) {
        this.buf = new Buffer(n);
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/file.iced",
            funcname: "Infile.read"
          });
          fs.read(_this.fd, _this.buf, 0, n, offset, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return br = arguments[1];
              };
            })(),
            lineno: 183
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            err = new E.BadIoError("" + _this.filename + "/" + offset + "-" + (offset + n) + ": " + err);
          } else if (br !== n) {
            err = new E.BadIoError("Short read: " + br + " != " + n);
          } else {
            ret = new Block({
              buf: _this.buf,
              offset: offset
            });
          }
          return cb(err, ret);
        };
      })(this));
    };

    Infile.prototype.next = function(n, cb) {
      var block, eof, err, rem, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      eof = false;
      if ((rem = this.stat.size - this.i) < n) {
        n = rem;
        eof = true;
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/file.iced",
            funcname: "Infile.next"
          });
          _this.read(_this.i, n, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return block = arguments[1];
              };
            })(),
            lineno: 199
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof block !== "undefined" && block !== null) {
            _this.i += block.len();
          } else {
            eof = true;
          }
          _this.eof = eof;
          return cb(err, block, eof);
        };
      })(this));
    };

    Infile.open = function(filename, cb) {
      var err, file, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      file = new Infile({
        filename: filename
      });
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/file.iced",
            funcname: "Infile.open"
          });
          file._open(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 211
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            file = null;
          }
          return cb(err, file);
        };
      })(this));
    };

    Infile.prototype.finish = function(ok, cb) {
      this.close();
      return cb(null);
    };

    Infile.prototype._open = function(cb) {
      var esc, flags, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Open " + this.filename);
      flags = C.O_RDONLY;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/file.iced",
            funcname: "Infile._open"
          });
          fs.open(_this.filename, flags, esc(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                return __slot_1.fd = arguments[0];
              };
            })(_this),
            lineno: 226
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/file.iced",
              funcname: "Infile._open"
            });
            fs.fstat(_this.fd, esc(__iced_deferrals.defer({
              assign_fn: (function(__slot_1) {
                return function() {
                  return __slot_1.stat = arguments[0];
                };
              })(_this),
              lineno: 227
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/file.iced",
                funcname: "Infile._open"
              });
              fs.realpath(_this.filename, esc(__iced_deferrals.defer({
                assign_fn: (function(__slot_1) {
                  return function() {
                    return __slot_1.realpath = arguments[0];
                  };
                })(_this),
                lineno: 228
              })));
              __iced_deferrals._fulfill();
            })(function() {
              return cb(null);
            });
          });
        };
      })(this));
    };

    return Infile;

  })(Basefile);

  concat = function(lst) {
    return Buffer.concat(lst);
  };

  Queue = (function() {
    function Queue() {
      this._q = [];
      this._cb = null;
    }

    Queue.prototype.push = function() {
      var args, tmp;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      if (this._cb != null) {
        tmp = this._cb;
        this._cb = null;
        return tmp.apply(null, args);
      } else {
        return this._q.push(args);
      }
    };

    Queue.prototype.pop = function(i, cb) {
      var trip;
      if (this._q.length != null) {
        trip = this._q[0];
        this._q = this.q.slice(1);
        return cb.apply(null, trip);
      } else {
        return this._cb = cb;
      }
    };

    return Queue;

  })();

}).call(this);
