/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.processor;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.CompositeIterator4;
import com.db4o.foundation.IntIterator4Adaptor;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.MappingIterator;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.TreeKeyIterator;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.IDGenerator;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.fieldindex.FieldIndexProcessor;
import com.db4o.internal.fieldindex.FieldIndexProcessorResult;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.query.processor.Order;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QField;
import com.db4o.internal.query.processor.QOrder;

public final class QCandidates
implements Visitor4 {
    public final Transaction i_trans;
    public Tree i_root;
    private List4 i_constraints;
    ClassMetadata i_yapClass;
    private QField i_field;
    QCon i_currentConstraint;
    Tree i_ordered;
    private int _majorOrderingID;
    private IDGenerator _idGenerator;

    QCandidates(Transaction transaction, ClassMetadata classMetadata, QField qField) {
        this.i_trans = transaction;
        this.i_yapClass = classMetadata;
        this.i_field = qField;
        if (qField == null || qField.i_yapField == null || !(qField.i_yapField.getHandler() instanceof ClassMetadata)) {
            return;
        }
        ClassMetadata classMetadata2 = (ClassMetadata)qField.i_yapField.getHandler();
        if (this.i_yapClass == null) {
            this.i_yapClass = classMetadata2;
        } else if ((classMetadata2 = this.i_yapClass.getHigherOrCommonHierarchy(classMetadata2)) != null) {
            this.i_yapClass = classMetadata2;
        }
    }

    public QCandidate addByIdentity(QCandidate qCandidate) {
        this.i_root = Tree.add(this.i_root, qCandidate);
        if (qCandidate._size == 0) {
            return qCandidate.getRoot();
        }
        return qCandidate;
    }

    void addConstraint(QCon qCon) {
        this.i_constraints = new List4(this.i_constraints, qCon);
    }

    void addOrder(QOrder qOrder) {
        this.i_ordered = Tree.add(this.i_ordered, qOrder);
    }

    void applyOrdering(Tree tree, int n) {
        if (tree == null || this.i_root == null) {
            return;
        }
        int n2 = Math.abs(n);
        boolean bl = this.treatOrderingIDAsMajor(n2);
        if (bl && !this.isUnordered()) {
            this.swapMajorOrderToMinor();
        }
        this.hintNewOrder(tree, bl);
        this.i_root = this.recreateTreeFromCandidates();
        if (bl) {
            this._majorOrderingID = n2;
        }
    }

    private Tree recreateTreeFromCandidates() {
        Collection4 collection4 = this.collectCandidates();
        Tree tree = null;
        Iterator4 iterator4 = collection4.iterator();
        while (iterator4.moveNext()) {
            QCandidate qCandidate = (QCandidate)iterator4.current();
            qCandidate._preceding = null;
            qCandidate._subsequent = null;
            qCandidate._size = 1;
            tree = Tree.add(tree, qCandidate);
        }
        return tree;
    }

    private Collection4 collectCandidates() {
        final Collection4 collection4 = new Collection4();
        this.i_root.traverse(new Visitor4(){

            public void visit(Object object) {
                QCandidate qCandidate = (QCandidate)object;
                collection4.add(qCandidate);
            }
        });
        return collection4;
    }

    private void hintNewOrder(Tree tree, final boolean bl) {
        final int[] nArray = new int[]{0};
        final QOrder[] qOrderArray = new QOrder[]{null};
        tree.traverse(new Visitor4(){

            public void visit(Object object) {
                QOrder qOrder = (QOrder)object;
                if (!qOrder.isEqual(qOrderArray[0])) {
                    nArray[0] = nArray[0] + 1;
                }
                QCandidate qCandidate = qOrder._candidate.getRoot();
                qCandidate.hintOrder(nArray[0], bl);
                qOrderArray[0] = qOrder;
            }
        });
    }

    private void swapMajorOrderToMinor() {
        this.i_root.traverse(new Visitor4(){

            public void visit(Object object) {
                QCandidate qCandidate = (QCandidate)object;
                Order order = (Order)qCandidate._order;
                order.swapMajorToMinor();
            }
        });
    }

    private boolean treatOrderingIDAsMajor(int n) {
        return this.isUnordered() || this.isMoreRelevantOrderingID(n);
    }

    private boolean isUnordered() {
        return this._majorOrderingID == 0;
    }

    private boolean isMoreRelevantOrderingID(int n) {
        return n < this._majorOrderingID;
    }

    void collect(QCandidates qCandidates) {
        Iterator4 iterator4 = this.iterateConstraints();
        while (iterator4.moveNext()) {
            QCon qCon = (QCon)iterator4.current();
            this.setCurrentConstraint(qCon);
            qCon.collect(qCandidates);
        }
        this.setCurrentConstraint(null);
    }

    void execute() {
        FieldIndexProcessorResult fieldIndexProcessorResult = this.processFieldIndexes();
        if (fieldIndexProcessorResult.foundIndex()) {
            this.i_root = fieldIndexProcessorResult.toQCandidate(this);
        } else {
            this.loadFromClassIndex();
        }
        this.evaluate();
    }

    public Iterator4 executeSnapshot(Collection4 collection4) {
        IntIterator4Adaptor intIterator4Adaptor = new IntIterator4Adaptor(this.iterateIndex(this.processFieldIndexes()));
        Tree tree = TreeInt.addAll(null, intIterator4Adaptor);
        TreeKeyIterator treeKeyIterator = new TreeKeyIterator(tree);
        Iterator4 iterator4 = this.singleObjectSodaProcessor(treeKeyIterator);
        return this.mapIdsToExecutionPath(iterator4, collection4);
    }

    private Iterator4 singleObjectSodaProcessor(Iterator4 iterator4) {
        return new MappingIterator(iterator4){

            protected Object map(Object object) {
                int n = (Integer)object;
                QCandidate qCandidate = new QCandidate(QCandidates.this, null, n, true);
                QCandidates.this.i_root = qCandidate;
                QCandidates.this.evaluate();
                if (!qCandidate.include()) {
                    return MappingIterator.SKIP;
                }
                return object;
            }
        };
    }

    public Iterator4 executeLazy(Collection4 collection4) {
        Iterator4 iterator4 = this.iterateIndex(this.processFieldIndexes());
        Iterator4 iterator42 = this.singleObjectSodaProcessor(iterator4);
        return this.mapIdsToExecutionPath(iterator42, collection4);
    }

    private Iterator4 iterateIndex(FieldIndexProcessorResult fieldIndexProcessorResult) {
        if (fieldIndexProcessorResult.noMatch()) {
            return Iterator4Impl.EMPTY;
        }
        if (fieldIndexProcessorResult.foundIndex()) {
            return fieldIndexProcessorResult.iterateIDs();
        }
        if (this.i_yapClass.isPrimitive()) {
            return Iterator4Impl.EMPTY;
        }
        return BTreeClassIndexStrategy.iterate(this.i_yapClass, this.i_trans);
    }

    private Iterator4 mapIdsToExecutionPath(Iterator4 iterator4, Collection4 collection4) {
        if (collection4 == null) {
            return iterator4;
        }
        Iterator4 iterator42 = iterator4;
        Iterator4 iterator43 = collection4.iterator();
        while (iterator43.moveNext()) {
            final String string = (String)iterator43.current();
            MappingIterator mappingIterator = new MappingIterator(iterator42){

                protected Object map(Object object) {
                    int n = (Integer)object;
                    StatefulBuffer statefulBuffer = QCandidates.this.stream().readWriterByID(QCandidates.this.i_trans, n);
                    if (statefulBuffer == null) {
                        return MappingIterator.SKIP;
                    }
                    ObjectHeader objectHeader = new ObjectHeader(QCandidates.this.stream(), (Buffer)statefulBuffer);
                    TreeInt treeInt = objectHeader.yapClass().collectFieldIDs(objectHeader._marshallerFamily, objectHeader._headerAttributes, null, statefulBuffer, string);
                    return new TreeKeyIterator(treeInt);
                }
            };
            iterator42 = new CompositeIterator4(mappingIterator);
        }
        return iterator42;
    }

    public ObjectContainerBase stream() {
        return this.i_trans.stream();
    }

    public int classIndexEntryCount() {
        return this.i_yapClass.indexEntryCount(this.i_trans);
    }

    private FieldIndexProcessorResult processFieldIndexes() {
        if (this.i_constraints == null) {
            return FieldIndexProcessorResult.NO_INDEX_FOUND;
        }
        return new FieldIndexProcessor(this).run();
    }

    void evaluate() {
        if (this.i_constraints == null) {
            return;
        }
        Iterator4 iterator4 = this.iterateConstraints();
        while (iterator4.moveNext()) {
            QCon qCon = (QCon)iterator4.current();
            qCon.setCandidates(this);
            qCon.evaluateSelf();
        }
        iterator4 = this.iterateConstraints();
        while (iterator4.moveNext()) {
            ((QCon)iterator4.current()).evaluateSimpleChildren();
        }
        iterator4 = this.iterateConstraints();
        while (iterator4.moveNext()) {
            ((QCon)iterator4.current()).evaluateEvaluations();
        }
        iterator4 = this.iterateConstraints();
        while (iterator4.moveNext()) {
            ((QCon)iterator4.current()).evaluateCreateChildrenCandidates();
        }
        iterator4 = this.iterateConstraints();
        while (iterator4.moveNext()) {
            ((QCon)iterator4.current()).evaluateCollectChildren();
        }
        iterator4 = this.iterateConstraints();
        while (iterator4.moveNext()) {
            ((QCon)iterator4.current()).evaluateChildren();
        }
    }

    boolean isEmpty() {
        final boolean[] blArray = new boolean[]{true};
        this.traverse(new Visitor4(){

            public void visit(Object object) {
                if (((QCandidate)object)._include) {
                    blArray[0] = false;
                }
            }
        });
        return blArray[0];
    }

    boolean filter(Visitor4 visitor4) {
        if (this.i_root != null) {
            this.i_root.traverse(visitor4);
            this.i_root = this.i_root.filter(new Predicate4(){

                public boolean match(Object object) {
                    return ((QCandidate)object)._include;
                }
            });
        }
        return this.i_root != null;
    }

    int generateCandidateId() {
        if (this._idGenerator == null) {
            this._idGenerator = new IDGenerator();
        }
        return -this._idGenerator.next();
    }

    public Iterator4 iterateConstraints() {
        if (this.i_constraints == null) {
            return Iterator4Impl.EMPTY;
        }
        return new Iterator4Impl(this.i_constraints);
    }

    void loadFromClassIndex() {
        if (!this.isEmpty()) {
            return;
        }
        final TreeIntBuilder treeIntBuilder = new TreeIntBuilder();
        ClassIndexStrategy classIndexStrategy = this.i_yapClass.index();
        classIndexStrategy.traverseAll(this.i_trans, new Visitor4(){

            public void visit(Object object) {
                treeIntBuilder.add(new QCandidate(QCandidates.this, null, (Integer)object, true));
            }
        });
        this.i_root = treeIntBuilder.tree;
        DiagnosticProcessor diagnosticProcessor = this.i_trans.stream().i_handlers._diagnosticProcessor;
        if (diagnosticProcessor.enabled()) {
            diagnosticProcessor.loadedFromClassIndex(this.i_yapClass);
        }
    }

    void setCurrentConstraint(QCon qCon) {
        this.i_currentConstraint = qCon;
    }

    void traverse(Visitor4 visitor4) {
        if (this.i_root != null) {
            this.i_root.traverse(visitor4);
        }
    }

    boolean tryAddConstraint(QCon qCon) {
        Object object;
        if (this.i_field != null && (object = qCon.getField()) != null && this.i_field.i_name != null && !this.i_field.i_name.equals(((QField)object).i_name)) {
            return false;
        }
        if (this.i_yapClass == null || qCon.isNullConstraint()) {
            this.addConstraint(qCon);
            return true;
        }
        object = qCon.getYapClass();
        if (object != null && (object = this.i_yapClass.getHigherOrCommonHierarchy((ClassMetadata)object)) != null) {
            this.i_yapClass = object;
            this.addConstraint(qCon);
            return true;
        }
        return false;
    }

    public void visit(Object object) {
        QCandidate qCandidate = (QCandidate)object;
        if (qCandidate.createChild(this)) {
            return;
        }
        Iterator4 iterator4 = this.iterateConstraints();
        while (iterator4.moveNext()) {
            ((QCon)iterator4.current()).visitOnNull(qCandidate.getRoot());
        }
    }

    public String toString() {
        final StringBuffer stringBuffer = new StringBuffer();
        this.i_root.traverse(new Visitor4(){

            public void visit(Object object) {
                QCandidate qCandidate = (QCandidate)object;
                stringBuffer.append(" ");
                stringBuffer.append(qCandidate._key);
            }
        });
        return stringBuffer.toString();
    }

    public void clearOrdering() {
        this.i_ordered = null;
    }

    static final class TreeIntBuilder {
        public TreeInt tree;

        TreeIntBuilder() {
        }

        public void add(TreeInt treeInt) {
            this.tree = (TreeInt)Tree.add(this.tree, treeInt);
        }
    }
}

