/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.Db4oUUID;
import com.db4o.ext.ObjectInfo;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.PrimitiveFieldHandler;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualAttributes;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeader;

public class ObjectReference
extends PersistentBase
implements ObjectInfo {
    private ClassMetadata _class;
    private Object _object;
    private VirtualAttributes _virtualAttributes;
    private ObjectReference id_preceding;
    private ObjectReference id_subsequent;
    private int id_size;
    private ObjectReference hc_preceding;
    private ObjectReference hc_subsequent;
    private int hc_size;
    private int hc_code;
    private int _lastTopLevelCallId;

    public ObjectReference() {
    }

    public ObjectReference(int n) {
        this.i_id = n;
    }

    ObjectReference(ClassMetadata classMetadata, int n) {
        this._class = classMetadata;
        this.i_id = n;
    }

    public void activate(Transaction transaction, Object object, int n, boolean bl) {
        this.activate1(transaction, object, n, bl);
        transaction.stream().activate3CheckStill(transaction);
    }

    void activate1(Transaction transaction, Object object, int n, boolean bl) {
        if (object instanceof Db4oTypeImpl) {
            n = ((Db4oTypeImpl)object).adjustReadDepth(n);
        }
        if (n > 0) {
            ObjectContainerBase objectContainerBase = transaction.stream();
            if (bl) {
                this.logActivation(objectContainerBase, "refresh");
            } else {
                if (this.isActive() && object != null) {
                    if (n > 1) {
                        if (this._class.i_config != null) {
                            n = this._class.i_config.adjustActivationDepth(n);
                        }
                        this._class.activateFields(transaction, object, n);
                    }
                    return;
                }
                this.logActivation(objectContainerBase, "activate");
            }
            this.read(transaction, null, object, n, 0, false);
        }
    }

    private void logActivation(ObjectContainerBase objectContainerBase, String string) {
        this.logEvent(objectContainerBase, string, 2);
    }

    private void logEvent(ObjectContainerBase objectContainerBase, String string, int n) {
        if (objectContainerBase.configImpl().messageLevel() > n) {
            objectContainerBase.message("" + this.getID() + " " + string + " " + this._class.getName());
        }
    }

    final void addExistingReferenceToIdTree(ObjectContainerBase objectContainerBase) {
        if (!(this._class instanceof PrimitiveFieldHandler)) {
            objectContainerBase.referenceSystem().addExistingReferenceToIdTree(this);
        }
    }

    boolean continueSet(Transaction transaction, int n) {
        if (this.bitIsTrue(4)) {
            if (!this._class.stateOKAndAncestors()) {
                return false;
            }
            this.bitFalse(4);
            StatefulBuffer statefulBuffer = MarshallerFamily.current()._object.marshallNew(transaction, this, n);
            ObjectContainerBase objectContainerBase = transaction.stream();
            objectContainerBase.writeNew(this._class, statefulBuffer);
            Object object = this._object;
            this.objectOnNew(objectContainerBase, object);
            if (!this._class.isPrimitive()) {
                this._object = objectContainerBase.i_references.createYapRef(this, object);
            }
            this.setStateClean();
            this.endProcessing();
        }
        return true;
    }

    private void objectOnNew(ObjectContainerBase objectContainerBase, Object object) {
        objectContainerBase.callbacks().objectOnNew(object);
        this._class.dispatchEvent(objectContainerBase, object, 4);
    }

    public void deactivate(Transaction transaction, int n) {
        Object object;
        if (n > 0 && (object = this.getObject()) != null) {
            if (object instanceof Db4oTypeImpl) {
                ((Db4oTypeImpl)object).preDeactivate();
            }
            ObjectContainerBase objectContainerBase = transaction.stream();
            this.logActivation(objectContainerBase, "deactivate");
            this.setStateDeactivated();
            this._class.deactivate(transaction, object, n);
        }
    }

    public byte getIdentifier() {
        return 79;
    }

    public Object getObject() {
        if (Platform4.hasWeakReferences()) {
            return Platform4.getYapRefObject(this._object);
        }
        return this._object;
    }

    public Object getObjectReference() {
        return this._object;
    }

    public ObjectContainerBase getStream() {
        if (this._class == null) {
            return null;
        }
        return this._class.getStream();
    }

    public Transaction getTrans() {
        ObjectContainerBase objectContainerBase = this.getStream();
        if (objectContainerBase != null) {
            return objectContainerBase.getTransaction();
        }
        return null;
    }

    public Db4oUUID getUUID() {
        VirtualAttributes virtualAttributes = this.virtualAttributes(this.getTrans());
        if (virtualAttributes != null && virtualAttributes.i_database != null) {
            return new Db4oUUID(virtualAttributes.i_uuid, virtualAttributes.i_database.i_signature);
        }
        return null;
    }

    public long getVersion() {
        VirtualAttributes virtualAttributes = this.virtualAttributes(this.getTrans());
        if (virtualAttributes == null) {
            return 0L;
        }
        return virtualAttributes.i_version;
    }

    public ClassMetadata getYapClass() {
        return this._class;
    }

    public int ownLength() {
        throw Exceptions4.shouldNeverBeCalled();
    }

    public VirtualAttributes produceVirtualAttributes() {
        if (this._virtualAttributes == null) {
            this._virtualAttributes = new VirtualAttributes();
        }
        return this._virtualAttributes;
    }

    final Object read(Transaction transaction, StatefulBuffer statefulBuffer, Object object, int n, int n2, boolean bl) {
        if (this.beginProcessing()) {
            ObjectContainerBase objectContainerBase = transaction.stream();
            if (statefulBuffer == null) {
                statefulBuffer = objectContainerBase.readWriterByID(transaction, this.getID());
            }
            if (statefulBuffer != null) {
                Object object2;
                ObjectHeader objectHeader = new ObjectHeader(objectContainerBase, (Buffer)statefulBuffer);
                this._class = objectHeader.yapClass();
                if (this._class == null) {
                    return null;
                }
                if (bl && (object2 = objectContainerBase.objectForIDFromCache(this.getID())) != null) {
                    return object2;
                }
                statefulBuffer.setInstantiationDepth(n);
                statefulBuffer.setUpdateDepth(n2);
                object = n2 == -1 ? this._class.instantiateTransient(this, object, objectHeader._marshallerFamily, objectHeader._headerAttributes, statefulBuffer) : this._class.instantiate(this, object, objectHeader._marshallerFamily, objectHeader._headerAttributes, statefulBuffer, n2 == 1);
            }
            this.endProcessing();
        }
        return object;
    }

    public final Object readPrefetch(ObjectContainerBase objectContainerBase, StatefulBuffer statefulBuffer) {
        Object object = null;
        if (this.beginProcessing()) {
            ObjectHeader objectHeader = new ObjectHeader(objectContainerBase, (Buffer)statefulBuffer);
            this._class = objectHeader.yapClass();
            if (this._class == null) {
                return null;
            }
            statefulBuffer.setInstantiationDepth(this._class.configOrAncestorConfig() == null ? 1 : 0);
            object = this._class.instantiate(this, this.getObject(), objectHeader._marshallerFamily, objectHeader._headerAttributes, statefulBuffer, true);
            this.endProcessing();
        }
        return object;
    }

    public final void readThis(Transaction transaction, Buffer buffer) {
    }

    void setObjectWeak(ObjectContainerBase objectContainerBase, Object object) {
        if (objectContainerBase.i_references._weak) {
            if (this._object != null) {
                Platform4.killYapRef(this._object);
            }
            this._object = Platform4.createYapRef(objectContainerBase.i_references._queue, this, object);
        } else {
            this._object = object;
        }
    }

    public void setObject(Object object) {
        this._object = object;
    }

    final void store(Transaction transaction, ClassMetadata classMetadata, Object object) {
        this._object = object;
        this._class = classMetadata;
        this.writeObjectBegin();
        int n = transaction.stream().newUserObject();
        transaction.slotFreePointerOnRollback(n);
        this.setID(n);
        this.beginProcessing();
        this.bitTrue(4);
    }

    public void flagForDelete(int n) {
        this._lastTopLevelCallId = -n;
    }

    public boolean isFlaggedForDelete() {
        return this._lastTopLevelCallId < 0;
    }

    public void flagAsHandled(int n) {
        this._lastTopLevelCallId = n;
    }

    public final boolean isFlaggedAsHandled(int n) {
        return this._lastTopLevelCallId == n;
    }

    public final boolean isValid() {
        return ObjectReference.isValidId(this.getID()) && this.getObject() != null;
    }

    public static final boolean isValidId(int n) {
        return n > 0;
    }

    public VirtualAttributes virtualAttributes() {
        return this._virtualAttributes;
    }

    public VirtualAttributes virtualAttributes(Transaction transaction) {
        if (transaction == null) {
            return this._virtualAttributes;
        }
        if (this._virtualAttributes == null) {
            if (this._class.hasVirtualAttributes()) {
                this._virtualAttributes = new VirtualAttributes();
                this._class.readVirtualAttributes(transaction, this);
            }
        } else if (!this._virtualAttributes.suppliesUUID() && this._class.hasVirtualAttributes()) {
            this._class.readVirtualAttributes(transaction, this);
        }
        return this._virtualAttributes;
    }

    public void setVirtualAttributes(VirtualAttributes virtualAttributes) {
        this._virtualAttributes = virtualAttributes;
    }

    public void writeThis(Transaction transaction, Buffer buffer) {
    }

    public void writeUpdate(Transaction transaction, int n) {
        this.continueSet(transaction, n);
        if (this.beginProcessing()) {
            Object object = this.getObject();
            if (this.objectCanUpdate(transaction.stream(), object)) {
                if (!this.isActive() || object == null) {
                    this.endProcessing();
                    return;
                }
                this.logEvent(transaction.stream(), "update", 1);
                this.setStateClean();
                transaction.writeUpdateDeleteMembers(this.getID(), this._class, transaction.stream().i_handlers.arrayType(object), 0);
                MarshallerFamily.current()._object.marshallUpdate(transaction, n, this, object);
            } else {
                this.endProcessing();
            }
        }
    }

    private boolean objectCanUpdate(ObjectContainerBase objectContainerBase, Object object) {
        return objectContainerBase.callbacks().objectCanUpdate(object) && this._class.dispatchEvent(objectContainerBase, object, 9);
    }

    public ObjectReference hc_add(ObjectReference objectReference) {
        if (objectReference.getObject() == null) {
            return this;
        }
        objectReference.hc_init();
        return this.hc_add1(objectReference);
    }

    public void hc_init() {
        this.hc_preceding = null;
        this.hc_subsequent = null;
        this.hc_size = 1;
        this.hc_code = this.hc_getCode(this.getObject());
    }

    /*
     * Enabled aggressive block sorting
     */
    private ObjectReference hc_add1(ObjectReference objectReference) {
        int n = this.hc_compare(objectReference);
        if (n < 0) {
            if (this.hc_preceding == null) {
                this.hc_preceding = objectReference;
                ++this.hc_size;
                return this;
            }
            this.hc_preceding = this.hc_preceding.hc_add1(objectReference);
            if (this.hc_subsequent != null) return this.hc_balance();
            return this.hc_rotateRight();
        }
        if (this.hc_subsequent == null) {
            this.hc_subsequent = objectReference;
            ++this.hc_size;
            return this;
        }
        this.hc_subsequent = this.hc_subsequent.hc_add1(objectReference);
        if (this.hc_preceding != null) return this.hc_balance();
        return this.hc_rotateLeft();
    }

    private ObjectReference hc_balance() {
        int n = this.hc_subsequent.hc_size - this.hc_preceding.hc_size;
        if (n < -2) {
            return this.hc_rotateRight();
        }
        if (n > 2) {
            return this.hc_rotateLeft();
        }
        this.hc_size = this.hc_preceding.hc_size + this.hc_subsequent.hc_size + 1;
        return this;
    }

    private void hc_calculateSize() {
        this.hc_size = this.hc_preceding == null ? (this.hc_subsequent == null ? 1 : this.hc_subsequent.hc_size + 1) : (this.hc_subsequent == null ? this.hc_preceding.hc_size + 1 : this.hc_preceding.hc_size + this.hc_subsequent.hc_size + 1);
    }

    private int hc_compare(ObjectReference objectReference) {
        int n = objectReference.hc_code - this.hc_code;
        if (n == 0) {
            n = objectReference.i_id - this.i_id;
        }
        return n;
    }

    public ObjectReference hc_find(Object object) {
        return this.hc_find(this.hc_getCode(object), object);
    }

    private ObjectReference hc_find(int n, Object object) {
        int n2 = n - this.hc_code;
        if (n2 < 0) {
            if (this.hc_preceding != null) {
                return this.hc_preceding.hc_find(n, object);
            }
        } else if (n2 > 0) {
            if (this.hc_subsequent != null) {
                return this.hc_subsequent.hc_find(n, object);
            }
        } else {
            ObjectReference objectReference;
            if (object == this.getObject()) {
                return this;
            }
            if (this.hc_preceding != null && (objectReference = this.hc_preceding.hc_find(n, object)) != null) {
                return objectReference;
            }
            if (this.hc_subsequent != null) {
                return this.hc_subsequent.hc_find(n, object);
            }
        }
        return null;
    }

    private int hc_getCode(Object object) {
        int n = System.identityHashCode(object);
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        return n;
    }

    private ObjectReference hc_rotateLeft() {
        ObjectReference objectReference = this.hc_subsequent;
        this.hc_subsequent = objectReference.hc_preceding;
        this.hc_calculateSize();
        objectReference.hc_preceding = this;
        objectReference.hc_size = objectReference.hc_subsequent == null ? 1 + this.hc_size : 1 + this.hc_size + objectReference.hc_subsequent.hc_size;
        return objectReference;
    }

    private ObjectReference hc_rotateRight() {
        ObjectReference objectReference = this.hc_preceding;
        this.hc_preceding = objectReference.hc_subsequent;
        this.hc_calculateSize();
        objectReference.hc_subsequent = this;
        objectReference.hc_size = objectReference.hc_preceding == null ? 1 + this.hc_size : 1 + this.hc_size + objectReference.hc_preceding.hc_size;
        return objectReference;
    }

    private ObjectReference hc_rotateSmallestUp() {
        if (this.hc_preceding != null) {
            this.hc_preceding = this.hc_preceding.hc_rotateSmallestUp();
            return this.hc_rotateRight();
        }
        return this;
    }

    ObjectReference hc_remove(ObjectReference objectReference) {
        if (this == objectReference) {
            return this.hc_remove();
        }
        int n = this.hc_compare(objectReference);
        if (n <= 0 && this.hc_preceding != null) {
            this.hc_preceding = this.hc_preceding.hc_remove(objectReference);
        }
        if (n >= 0 && this.hc_subsequent != null) {
            this.hc_subsequent = this.hc_subsequent.hc_remove(objectReference);
        }
        this.hc_calculateSize();
        return this;
    }

    public void hc_traverse(Visitor4 visitor4) {
        if (this.hc_preceding != null) {
            this.hc_preceding.hc_traverse(visitor4);
        }
        if (this.hc_subsequent != null) {
            this.hc_subsequent.hc_traverse(visitor4);
        }
        visitor4.visit(this);
    }

    private ObjectReference hc_remove() {
        if (this.hc_subsequent != null && this.hc_preceding != null) {
            this.hc_subsequent = this.hc_subsequent.hc_rotateSmallestUp();
            this.hc_subsequent.hc_preceding = this.hc_preceding;
            this.hc_subsequent.hc_calculateSize();
            return this.hc_subsequent;
        }
        if (this.hc_subsequent != null) {
            return this.hc_subsequent;
        }
        return this.hc_preceding;
    }

    ObjectReference id_add(ObjectReference objectReference) {
        objectReference.id_preceding = null;
        objectReference.id_subsequent = null;
        objectReference.id_size = 1;
        return this.id_add1(objectReference);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ObjectReference id_add1(ObjectReference objectReference) {
        int n = objectReference.i_id - this.i_id;
        if (n < 0) {
            if (this.id_preceding == null) {
                this.id_preceding = objectReference;
                ++this.id_size;
                return this;
            }
            this.id_preceding = this.id_preceding.id_add1(objectReference);
            if (this.id_subsequent != null) return this.id_balance();
            return this.id_rotateRight();
        }
        if (n <= 0) return this;
        if (this.id_subsequent == null) {
            this.id_subsequent = objectReference;
            ++this.id_size;
            return this;
        }
        this.id_subsequent = this.id_subsequent.id_add1(objectReference);
        if (this.id_preceding != null) return this.id_balance();
        return this.id_rotateLeft();
    }

    private ObjectReference id_balance() {
        int n = this.id_subsequent.id_size - this.id_preceding.id_size;
        if (n < -2) {
            return this.id_rotateRight();
        }
        if (n > 2) {
            return this.id_rotateLeft();
        }
        this.id_size = this.id_preceding.id_size + this.id_subsequent.id_size + 1;
        return this;
    }

    private void id_calculateSize() {
        this.id_size = this.id_preceding == null ? (this.id_subsequent == null ? 1 : this.id_subsequent.id_size + 1) : (this.id_subsequent == null ? this.id_preceding.id_size + 1 : this.id_preceding.id_size + this.id_subsequent.id_size + 1);
    }

    ObjectReference id_find(int n) {
        int n2 = n - this.i_id;
        if (n2 > 0) {
            if (this.id_subsequent != null) {
                return this.id_subsequent.id_find(n);
            }
        } else if (n2 < 0) {
            if (this.id_preceding != null) {
                return this.id_preceding.id_find(n);
            }
        } else {
            return this;
        }
        return null;
    }

    private ObjectReference id_rotateLeft() {
        ObjectReference objectReference = this.id_subsequent;
        this.id_subsequent = objectReference.id_preceding;
        this.id_calculateSize();
        objectReference.id_preceding = this;
        objectReference.id_size = objectReference.id_subsequent == null ? this.id_size + 1 : this.id_size + 1 + objectReference.id_subsequent.id_size;
        return objectReference;
    }

    private ObjectReference id_rotateRight() {
        ObjectReference objectReference = this.id_preceding;
        this.id_preceding = objectReference.id_subsequent;
        this.id_calculateSize();
        objectReference.id_subsequent = this;
        objectReference.id_size = objectReference.id_preceding == null ? this.id_size + 1 : this.id_size + 1 + objectReference.id_preceding.id_size;
        return objectReference;
    }

    private ObjectReference id_rotateSmallestUp() {
        if (this.id_preceding != null) {
            this.id_preceding = this.id_preceding.id_rotateSmallestUp();
            return this.id_rotateRight();
        }
        return this;
    }

    ObjectReference id_remove(int n) {
        int n2 = n - this.i_id;
        if (n2 < 0) {
            if (this.id_preceding != null) {
                this.id_preceding = this.id_preceding.id_remove(n);
            }
        } else if (n2 > 0) {
            if (this.id_subsequent != null) {
                this.id_subsequent = this.id_subsequent.id_remove(n);
            }
        } else {
            return this.id_remove();
        }
        this.id_calculateSize();
        return this;
    }

    private ObjectReference id_remove() {
        if (this.id_subsequent != null && this.id_preceding != null) {
            this.id_subsequent = this.id_subsequent.id_rotateSmallestUp();
            this.id_subsequent.id_preceding = this.id_preceding;
            this.id_subsequent.id_calculateSize();
            return this.id_subsequent;
        }
        if (this.id_subsequent != null) {
            return this.id_subsequent;
        }
        return this.id_preceding;
    }

    public String toString() {
        return super.toString();
    }
}

