/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.Db4o;
import com.db4o.config.Configuration;
import com.db4o.defragment.ContextIDMapping;
import com.db4o.defragment.DefragmentConfig;
import com.db4o.defragment.DefragmentInfo;
import com.db4o.defragment.DefragmentListener;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.mapping.DefragContext;
import com.db4o.internal.mapping.MappingNotFoundException;
import com.db4o.internal.slots.Slot;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DefragContextImpl
implements DefragContext {
    public static final DbSelector SOURCEDB = new DbSelector(){

        LocalObjectContainer db(DefragContextImpl defragContextImpl) {
            return defragContextImpl._sourceDb;
        }
    };
    public static final DbSelector TARGETDB = new DbSelector(){

        LocalObjectContainer db(DefragContextImpl defragContextImpl) {
            return defragContextImpl._targetDb;
        }
    };
    private static final long CLASSCOLLECTION_POINTER_ADDRESS = 10L;
    public final LocalObjectContainer _sourceDb;
    final LocalObjectContainer _targetDb;
    private final ContextIDMapping _mapping;
    private DefragmentListener _listener;
    private Queue4 _unindexed = new Queue4();
    private Hashtable4 _classIndices = new Hashtable4(16);

    public DefragContextImpl(DefragmentConfig defragmentConfig, DefragmentListener defragmentListener) {
        this._listener = defragmentListener;
        Config4Impl config4Impl = (Config4Impl)defragmentConfig.db4oConfig();
        Configuration configuration = (Configuration)config4Impl.deepClone(null);
        configuration.weakReferences(false);
        configuration.flushFileBuffers(false);
        configuration.readOnly(true);
        this._sourceDb = (LocalObjectContainer)Db4o.openFile(configuration, defragmentConfig.tempPath()).ext();
        this._targetDb = DefragContextImpl.freshYapFile(defragmentConfig.origPath(), defragmentConfig.blockSize());
        this._mapping = defragmentConfig.mapping();
        this._mapping.open();
    }

    static LocalObjectContainer freshYapFile(String string, int n) {
        new File(string).delete();
        return (LocalObjectContainer)Db4o.openFile(DefragmentConfig.vanillaDb4oConfig(n), string).ext();
    }

    public int mappedID(int n, int n2) {
        int n3 = this.internalMappedID(n, false);
        return n3 != 0 ? n3 : n2;
    }

    public int mappedID(int n) throws MappingNotFoundException {
        int n2 = this.internalMappedID(n, false);
        if (n2 == 0) {
            throw new MappingNotFoundException(n);
        }
        return n2;
    }

    public int mappedID(int n, boolean bl) throws MappingNotFoundException {
        if (n == 0) {
            return 0;
        }
        int n2 = this.internalMappedID(n, bl);
        if (n2 == 0) {
            this._listener.notifyDefragmentInfo(new DefragmentInfo("No mapping found for ID " + n));
            return 0;
        }
        return n2;
    }

    private int internalMappedID(int n, boolean bl) throws MappingNotFoundException {
        if (n == 0) {
            return 0;
        }
        if (this._sourceDb.handlers().isSystemHandler(n)) {
            return n;
        }
        return this._mapping.mappedID(n, bl);
    }

    public void mapIDs(int n, int n2, boolean bl) {
        this._mapping.mapIDs(n, n2, bl);
    }

    public void close() {
        this._sourceDb.close();
        this._targetDb.close();
        this._mapping.close();
    }

    public Buffer readerByID(DbSelector dbSelector, int n) {
        Slot slot = this.readPointer(dbSelector, n);
        return this.readerByAddress(dbSelector, slot._address, slot._length);
    }

    public StatefulBuffer sourceWriterByID(int n) {
        Slot slot = this.readPointer(SOURCEDB, n);
        return this._sourceDb.readWriterByAddress(SOURCEDB.transaction(this), slot._address, slot._length);
    }

    public Buffer sourceReaderByAddress(int n, int n2) {
        return this.readerByAddress(SOURCEDB, n, n2);
    }

    public Buffer targetReaderByAddress(int n, int n2) {
        return this.readerByAddress(TARGETDB, n, n2);
    }

    public Buffer readerByAddress(DbSelector dbSelector, int n, int n2) {
        return dbSelector.db(this).readReaderByAddress(n, n2);
    }

    public StatefulBuffer targetWriterByAddress(int n, int n2) {
        return this._targetDb.readWriterByAddress(TARGETDB.transaction(this), n, n2);
    }

    public int allocateTargetSlot(int n) {
        return this._targetDb.getSlot(n);
    }

    public void targetWriteBytes(ReaderPair readerPair, int n) {
        readerPair.write(this._targetDb, n);
    }

    public void targetWriteBytes(Buffer buffer, int n) {
        this._targetDb.writeBytes(buffer, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass[] storedClasses(DbSelector dbSelector) {
        LocalObjectContainer localObjectContainer = dbSelector.db(this);
        localObjectContainer.showInternalClasses(true);
        try {
            StoredClass[] storedClassArray = localObjectContainer.storedClasses();
            return storedClassArray;
        }
        finally {
            localObjectContainer.showInternalClasses(false);
        }
    }

    public LatinStringIO stringIO() {
        return this._sourceDb.stringIO();
    }

    public void targetCommit() {
        this._targetDb.commit();
    }

    public TypeHandler4 sourceHandler(int n) {
        return this._sourceDb.handlerByID(n);
    }

    public int sourceClassCollectionID() {
        return this._sourceDb.classCollection().getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void targetClassCollectionID(String string, int n) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        try {
            Buffer buffer = new Buffer(4);
            randomAccessFile.seek(10L);
            buffer._offset = 0;
            buffer.writeInt(n);
            randomAccessFile.write(buffer._buffer);
        }
        finally {
            randomAccessFile.close();
        }
    }

    public int classIndexID(ClassMetadata classMetadata) {
        return this.classIndex(classMetadata).id();
    }

    public void traverseAll(ClassMetadata classMetadata, Visitor4 visitor4) {
        if (!classMetadata.hasIndex()) {
            return;
        }
        classMetadata.index().traverseAll(SOURCEDB.transaction(this), visitor4);
    }

    public void traverseAllIndexSlots(ClassMetadata classMetadata, Visitor4 visitor4) {
        Iterator4 iterator4 = classMetadata.index().allSlotIDs(SOURCEDB.transaction(this));
        while (iterator4.moveNext()) {
            visitor4.visit(iterator4.current());
        }
    }

    public void traverseAllIndexSlots(BTree bTree, Visitor4 visitor4) {
        Iterator4 iterator4 = bTree.allNodeIds(SOURCEDB.transaction(this));
        while (iterator4.moveNext()) {
            visitor4.visit(iterator4.current());
        }
    }

    public int databaseIdentityID(DbSelector dbSelector) {
        LocalObjectContainer localObjectContainer = dbSelector.db(this);
        Db4oDatabase db4oDatabase = localObjectContainer.identity();
        if (db4oDatabase == null) {
            return 0;
        }
        return db4oDatabase.getID(dbSelector.transaction(this));
    }

    private ClassIndexStrategy classIndex(ClassMetadata classMetadata) {
        ClassIndexStrategy classIndexStrategy = (ClassIndexStrategy)this._classIndices.get(classMetadata);
        if (classIndexStrategy == null) {
            classIndexStrategy = new BTreeClassIndexStrategy(classMetadata);
            this._classIndices.put(classMetadata, (Object)classIndexStrategy);
            classIndexStrategy.initialize(this._targetDb);
        }
        return classIndexStrategy;
    }

    public Transaction systemTrans() {
        return SOURCEDB.transaction(this);
    }

    public void copyIdentity() {
        this._targetDb.setIdentity(this._sourceDb.identity());
    }

    public void targetClassCollectionID(int n) {
        this._targetDb.systemData().classCollectionID(n);
    }

    public Buffer sourceReaderByID(int n) {
        return this.readerByID(SOURCEDB, n);
    }

    public BTree sourceUuidIndex() {
        if (this.sourceUuidIndexID() == 0) {
            return null;
        }
        return this._sourceDb.getUUIDIndex().getIndex(this.systemTrans());
    }

    public void targetUuidIndexID(int n) {
        this._targetDb.systemData().uuidIndexId(n);
    }

    public int sourceUuidIndexID() {
        return this._sourceDb.systemData().uuidIndexId();
    }

    public ClassMetadata yapClass(int n) {
        return this._sourceDb.getYapClass(n);
    }

    public void registerUnindexed(int n) {
        this._unindexed.add(new Integer(n));
    }

    public Iterator4 unindexedIDs() {
        return this._unindexed.iterator();
    }

    private Slot readPointer(DbSelector dbSelector, int n) {
        Buffer buffer = this.readerByAddress(dbSelector, n, 8);
        int n2 = buffer.readInt();
        int n3 = buffer.readInt();
        return new Slot(n2, n3);
    }

    public int blockSize() {
        return this._sourceDb.config().blockSize();
    }

    public static abstract class DbSelector {
        DbSelector() {
        }

        abstract LocalObjectContainer db(DefragContextImpl var1);

        Transaction transaction(DefragContextImpl defragContextImpl) {
            return this.db(defragContextImpl).getSystemTransaction();
        }
    }
}

