/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.url.URLStreamHandlerService;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.AuthenticationRequiredException;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.IAbortable;
import org.rssowl.core.connection.ICredentials;
import org.rssowl.core.connection.ICredentialsProvider;
import org.rssowl.core.connection.SyncConnectionException;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.connection.DefaultProtocolHandler;
import org.rssowl.core.internal.connection.Messages;
import org.rssowl.core.internal.interpreter.json.JSONException;
import org.rssowl.core.internal.interpreter.json.JSONObject;
import org.rssowl.core.internal.interpreter.json.JSONTokener;
import org.rssowl.core.interpreter.ParserException;
import org.rssowl.core.persist.IConditionalGet;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.SyncItem;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.core.util.Triple;
import org.rssowl.core.util.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderProtocolHandler
extends DefaultProtocolHandler {
    private static final String REQUEST_HEADER_USER_AGENT = "User-Agent";
    private static final String REQUEST_HEADER_ACCEPT_CHARSET = "Accept-Charset";
    private static final String REQUEST_HEADER_AUTHORIZATION = "Authorization";
    private static final String UTF_8 = "UTF-8";
    private static final String BROWSER_USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; rv:2.0.1) Gecko/20100101 Firefox/4.0.1";
    private static final int DEFAULT_ITEM_LIMIT = 200;

    @Override
    public Triple<IFeed, IConditionalGet, URI> reload(URI link, IProgressMonitor monitor, Map<Object, Object> properties) throws CoreException {
        Map uncommittedItems;
        int itemLimit = 200;
        long dateLimit = 0L;
        if (properties != null) {
            Object dateLimitObj;
            Object itemLimitObj;
            if (properties.containsKey("ITEM_LIMIT") && (itemLimitObj = properties.get("ITEM_LIMIT")) instanceof Integer) {
                itemLimit = (Integer)itemLimitObj;
            }
            if (properties.containsKey("DATE_LIMIT") && (dateLimitObj = properties.get("DATE_LIMIT")) instanceof Long) {
                dateLimit = (Long)dateLimitObj / 1000L;
            }
        } else {
            properties = new HashMap<Object, Object>();
        }
        URI googleLink = this.readerToGoogle(link, itemLimit, dateLimit);
        InputStream inS = null;
        try {
            String authToken = this.handleAuthentication(false, monitor);
            inS = this.openGoogleConnection(authToken, googleLink, monitor, properties);
        }
        catch (ConnectionException e) {
            if (!(e instanceof AuthenticationRequiredException) && !(e instanceof SyncConnectionException)) {
                throw e;
            }
            if (monitor.isCanceled()) {
                this.closeStream(inS, true);
                return null;
            }
            String authToken = this.handleAuthentication(true, monitor);
            inS = this.openGoogleConnection(authToken, googleLink, monitor, properties);
        }
        if (monitor.isCanceled()) {
            this.closeStream(inS, true);
            return null;
        }
        IConditionalGet conditionalGet = this.getConditionalGet(googleLink, inS);
        if (monitor.isCanceled()) {
            this.closeStream(inS, true);
            return null;
        }
        InputStreamReader reader = null;
        boolean isError = false;
        IModelFactory typesFactory = Owl.getModelFactory();
        IFeed feed = typesFactory.createFeed(null, link);
        feed.setBase(this.readerToHTTP(link));
        try {
            try {
                reader = new InputStreamReader(inS, UTF_8);
                JSONObject obj = new JSONObject(new JSONTokener(reader));
                Owl.getInterpreter().interpretJSONObject(obj, feed);
            }
            catch (JSONException e) {
                isError = true;
                throw new ParserException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
            catch (IOException e) {
                isError = true;
                throw new ParserException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (isError && inS instanceof IAbortable) {
                    ((IAbortable)((Object)inS)).abort();
                } else if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (isError && inS instanceof IAbortable) {
                ((IAbortable)((Object)inS)).abort();
            } else if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        Object uncommittedItemsObj = properties.get("UNCOMMITTED_ITEMS");
        if (uncommittedItemsObj != null && !(uncommittedItems = (Map)uncommittedItemsObj).isEmpty()) {
            List<INews> news = feed.getNews();
            for (INews item : news) {
                SyncItem syncItem;
                if (item.getGuid() == null || item.getGuid().getValue() == null || (syncItem = (SyncItem)uncommittedItems.get(item.getGuid().getValue())) == null) continue;
                syncItem.applyTo(item);
            }
        }
        return Triple.create(feed, conditionalGet, link);
    }

    private InputStream openGoogleConnection(String authToken, URI googleLink, IProgressMonitor monitor, Map<Object, Object> properties) throws ConnectionException {
        if (monitor.isCanceled()) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(REQUEST_HEADER_AUTHORIZATION, SyncUtils.getGoogleAuthorizationHeader(authToken));
        headers.put(REQUEST_HEADER_ACCEPT_CHARSET, UTF_8.toLowerCase());
        headers.put(REQUEST_HEADER_USER_AGENT, BROWSER_USER_AGENT);
        properties.put("HEADERS", headers);
        properties.put("PROGRESS_MONITOR", monitor);
        return this.openStream(googleLink, properties);
    }

    private String handleAuthentication(boolean refresh, IProgressMonitor monitor) throws ConnectionException {
        URI googleLoginUri = URI.create("https://www.google.com/accounts/ClientLogin");
        ICredentialsProvider provider = Owl.getConnectionService().getCredentialsProvider(googleLoginUri);
        ICredentials credentials = provider.getAuthCredentials(googleLoginUri, null);
        if (credentials == null) {
            throw new AuthenticationRequiredException(null, Status.CANCEL_STATUS);
        }
        String token = SyncUtils.getGoogleAuthToken(credentials.getUsername(), credentials.getPassword(), refresh, monitor);
        if (token == null) {
            throw new AuthenticationRequiredException(null, Status.CANCEL_STATUS);
        }
        return token;
    }

    private URI readerToGoogle(URI uri, int itemLimit, long dateLimit) throws ConnectionException {
        String linkVal = uri.toString();
        try {
            if ("reader://readinglist".equals(linkVal)) {
                return new URI(this.appendCommonParams("http://www.google.com/reader/api/0/stream/contents/user/-/state/com.google/reading-list", itemLimit, dateLimit, false));
            }
            if ("reader://starred".equals(linkVal)) {
                return new URI(this.appendCommonParams("http://www.google.com/reader/api/0/stream/contents/user/-/state/com.google/starred", itemLimit, dateLimit, false));
            }
            if ("reader://shared".equals(linkVal)) {
                return new URI(this.appendCommonParams("http://www.google.com/reader/api/0/stream/contents/user/-/state/com.google/broadcast", itemLimit, dateLimit, false));
            }
            if ("reader://recommended".equals(linkVal)) {
                String language = Locale.getDefault().getLanguage();
                return new URI(this.appendCommonParams("http://www.google.com/reader/api/0/stream/contents/user/-/state/com.google/itemrecs/" + language, itemLimit, dateLimit, true));
            }
            if ("reader://notes".equals(linkVal)) {
                return new URI(this.appendCommonParams("http://www.google.com/reader/api/0/stream/contents/user/-/state/com.google/created", itemLimit, dateLimit, false));
            }
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
        URI httpUri = this.readerToHTTP(uri);
        try {
            return new URI(this.appendCommonParams("http://www.google.com/reader/api/0/stream/contents/feed/" + URIUtils.urlEncode(httpUri.toString()), itemLimit, dateLimit, false));
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
    }

    private String appendCommonParams(String link, int itemLimit, long dateLimit, boolean onlyRecommended) {
        StringBuilder str = new StringBuilder(link);
        str.append("?n=").append(itemLimit);
        str.append("&client=scroll");
        if (dateLimit > 0L) {
            str.append("&ot=").append(dateLimit);
        }
        str.append("&likes=false&comments=false");
        if (onlyRecommended) {
            str.append("&xt=user/-/state/com.google/read&xt=user/-/state/com.google/dislike");
        }
        str.append("&ck=").append(System.currentTimeMillis());
        return str.toString();
    }

    @Override
    public InputStream openStream(URI link, IProgressMonitor monitor, Map<Object, Object> properties) throws ConnectionException {
        return super.openStream(this.readerToHTTP(link), monitor, properties);
    }

    @Override
    public byte[] getFeedIcon(URI link, IProgressMonitor monitor) {
        block11: {
            String linkVal;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            try {
                                linkVal = link.toString();
                                if (!"reader://readinglist".equals(linkVal)) break block7;
                                return null;
                            }
                            catch (ConnectionException connectionException) {
                                return null;
                            }
                        }
                        if (!"reader://starred".equals(linkVal)) break block8;
                        return null;
                    }
                    if (!"reader://shared".equals(linkVal)) break block9;
                    return null;
                }
                if (!"reader://recommended".equals(linkVal)) break block10;
                return null;
            }
            if (!"reader://notes".equals(linkVal)) break block11;
            return null;
        }
        return super.getFeedIcon(this.readerToHTTP(link), monitor);
    }

    @Override
    public String getLabel(URI link, IProgressMonitor monitor) throws ConnectionException {
        String linkVal = link.toString();
        if ("reader://readinglist".equals(linkVal)) {
            return Messages.ReaderProtocolHandler_GR_ALL_ITEMS;
        }
        if ("reader://starred".equals(linkVal)) {
            return Messages.ReaderProtocolHandler_GR_STARRED_ITEMS;
        }
        if ("reader://shared".equals(linkVal)) {
            return Messages.ReaderProtocolHandler_GR_SHARED_ITEMS;
        }
        if ("reader://recommended".equals(linkVal)) {
            return Messages.ReaderProtocolHandler_GR_RECOMMENDED_ITEMS;
        }
        if ("reader://notes".equals(linkVal)) {
            return Messages.ReaderProtocolHandler_GR_NOTES;
        }
        return super.getLabel(this.readerToHTTP(link), monitor);
    }

    @Override
    public URI getFeed(URI website, IProgressMonitor monitor) throws ConnectionException {
        return super.getFeed(this.readerToHTTP(website), monitor);
    }

    @Override
    public URLStreamHandlerService getURLStreamHandler() {
        return null;
    }

    private URI readerToHTTP(URI uri) throws ConnectionException {
        try {
            String scheme = "readers".equals(uri.getScheme()) ? "https" : "http";
            return new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
    }
}

