/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.LinkTransformer;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.editors.feed.IFeedViewPart;
import org.rssowl.ui.internal.editors.feed.IFeedViewSite;
import org.rssowl.ui.internal.editors.feed.Messages;
import org.rssowl.ui.internal.editors.feed.NewsBrowserLabelProvider;
import org.rssowl.ui.internal.editors.feed.NewsBrowserViewer;
import org.rssowl.ui.internal.editors.feed.NewsColumn;
import org.rssowl.ui.internal.editors.feed.NewsComparator;
import org.rssowl.ui.internal.editors.feed.NewsContentProvider;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsBrowserControl
implements IFeedViewPart {
    private IFeedViewSite fFeedViewSite;
    private NewsBrowserViewer fViewer;
    private ISelectionListener fSelectionListener;
    private Object fInitialInput;
    private boolean fInputSet;
    private IPreferenceScope fInputPreferences;
    private IPropertyChangeListener fPropertyChangeListener;
    private boolean fStripImagesFromNews;
    private boolean fStripMediaFromNews;
    private boolean fHeadlinesOnly;
    private NewsComparator fNewsSorter;
    private FeedViewInput fEditorInput;
    private Composite fInfoBar;
    private Label fInfoBarSeparator;

    @Override
    public void init(IFeedViewSite feedViewSite) {
        this.fFeedViewSite = feedViewSite;
    }

    @Override
    public void onInputChanged(FeedViewInput input) {
        this.fEditorInput = input;
        this.fInputPreferences = Owl.getPreferenceService().getEntityScope((IEntity)input.getMark());
        this.fStripImagesFromNews = !this.fInputPreferences.getBoolean(DefaultPreferences.ENABLE_IMAGES);
        this.fStripMediaFromNews = !this.fInputPreferences.getBoolean(DefaultPreferences.ENABLE_MEDIA);
        boolean bl = this.fHeadlinesOnly = OwlUI.getLayout(this.fInputPreferences) == OwlUI.Layout.HEADLINES;
        if (this.fViewer != null && this.fViewer.getLabelProvider() != null) {
            ((NewsBrowserLabelProvider)this.fViewer.getLabelProvider()).setStripMediaFromNews(this.fStripImagesFromNews, this.fStripMediaFromNews);
            ((NewsBrowserLabelProvider)this.fViewer.getLabelProvider()).setHeadlinesOnly(this.fHeadlinesOnly);
        }
    }

    @Override
    public void onLayoutChanged(OwlUI.Layout newLayout) {
        boolean bl = this.fHeadlinesOnly = newLayout == OwlUI.Layout.HEADLINES;
        if (this.fViewer != null) {
            if (this.fViewer.getLabelProvider() != null) {
                ((NewsBrowserLabelProvider)this.fViewer.getLabelProvider()).setHeadlinesOnly(this.fHeadlinesOnly);
            }
            this.fViewer.onLayoutChanged(newLayout);
        }
    }

    @Override
    public void createPart(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        container.setBackground(parent.getBackground());
        this.createInfoBar(container);
        this.setInfoBarVisible(false, false);
        this.fViewer = new NewsBrowserViewer(container, 0, this.fFeedViewSite){

            protected void onRefresh() {
                NewsBrowserControl.this.setInfoBarVisible(false);
            }
        };
        this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createInfoBar(Composite parent) {
        this.fInfoBar = new Composite(parent, 0);
        this.fInfoBar.setBackground(parent.getDisplay().getSystemColor(29));
        this.fInfoBar.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fInfoBar.setLayout((Layout)LayoutUtils.createGridLayout(3, 3, 3));
        this.fInfoBar.setCursor(parent.getDisplay().getSystemCursor(21));
        this.fInfoBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                NewsBrowserControl.this.onInfoBarClicked();
            }
        });
        Label imgLabel = new Label(this.fInfoBar, 0);
        imgLabel.setImage(OwlUI.getImage((Control)imgLabel, "icons/obj16/info.gif"));
        imgLabel.setBackground(this.fInfoBar.getBackground());
        imgLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Link textLink = new Link(this.fInfoBar, 0);
        textLink.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        textLink.setBackground(this.fInfoBar.getBackground());
        textLink.setCursor(parent.getDisplay().getSystemCursor(21));
        textLink.setText(Messages.NewsBrowserControl_ADDITIONAL_NEWS_INFO);
        textLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsBrowserControl.this.onInfoBarClicked();
            }
        });
        textLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                NewsBrowserControl.this.onInfoBarClicked();
            }
        });
        ToolBar bar = new ToolBar(this.fInfoBar, 0x800000);
        bar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        bar.setBackground(this.fInfoBar.getBackground());
        ToolItem closeItem = new ToolItem(bar, 8);
        closeItem.setToolTipText(Messages.NewsBrowserControl_CLOSE);
        closeItem.setImage(OwlUI.getImage((Control)bar, "icons/etool16/close_normal.png"));
        closeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsBrowserControl.this.setInfoBarVisible(false);
            }
        });
        this.fInfoBarSeparator = new Label(parent, 258);
        this.fInfoBarSeparator.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    private void onInfoBarClicked() {
        boolean moveToTop = OwlUI.getPageSize(this.fInputPreferences).getPageSize() == 0;
        this.fViewer.refresh(true, moveToTop);
    }

    public void setInfoBarVisible(boolean visible) {
        this.setInfoBarVisible(visible, true);
    }

    private void setInfoBarVisible(boolean visible, boolean layout) {
        if (this.fInfoBar == null || this.fInfoBar.isDisposed()) {
            return;
        }
        if (((GridData)this.fInfoBar.getLayoutData()).exclude != visible) {
            return;
        }
        ((GridData)this.fInfoBarSeparator.getLayoutData()).exclude = !visible;
        ((GridData)this.fInfoBar.getLayoutData()).exclude = !visible;
        this.fInfoBarSeparator.setVisible(visible);
        this.fInfoBar.setVisible(visible);
        if (layout) {
            this.fInfoBar.getParent().layout(true, true);
        }
    }

    @Override
    public NewsBrowserViewer getViewer() {
        return this.fViewer;
    }

    @Override
    public void initViewer(IStructuredContentProvider contentProvider, ViewerFilter filter) {
        this.fViewer.setContentProvider((IContentProvider)contentProvider);
        NewsBrowserLabelProvider labelProvider = new NewsBrowserLabelProvider(this.fViewer);
        labelProvider.setStripMediaFromNews(this.fStripImagesFromNews, this.fStripMediaFromNews);
        labelProvider.setHeadlinesOnly(this.fHeadlinesOnly);
        this.fViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fNewsSorter = new NewsComparator();
        this.fViewer.setComparator(this.fNewsSorter);
        this.updateSorting(this.fEditorInput.getMark(), false);
        this.fViewer.addFilter(filter);
        this.registerListener();
    }

    void updateSorting(Object input, boolean refreshIfChanged) {
        if (this.fViewer.getControl().isDisposed()) {
            return;
        }
        IPreferenceScope preferences = input instanceof IEntity ? Owl.getPreferenceService().getEntityScope((IEntity)input) : Owl.getPreferenceService().getGlobalScope();
        NewsColumn sortColumn = NewsColumn.values()[preferences.getInteger(DefaultPreferences.BM_NEWS_SORT_COLUMN)];
        boolean ascending = preferences.getBoolean(DefaultPreferences.BM_NEWS_SORT_ASCENDING);
        NewsColumn oldSortColumn = this.fNewsSorter.getSortBy();
        boolean oldAscending = this.fNewsSorter.isAscending();
        this.fNewsSorter.setSortBy(sortColumn);
        this.fNewsSorter.setAscending(ascending);
        if (refreshIfChanged && (oldSortColumn != sortColumn || oldAscending != ascending)) {
            this.fViewer.refresh();
        }
    }

    @Override
    public void setPartInput(Object input) {
        if (input instanceof EntityGroup || input instanceof INewsMark) {
            this.updateSorting(input, false);
        }
        Pair<?, Boolean> computedInput = this.getInput(input);
        this.fViewer.setInput(computedInput.getFirst(), (Boolean)computedInput.getSecond());
        this.fInitialInput = this.fViewer.getInput();
        this.fInputSet = true;
    }

    private Pair<?, Boolean> getInput(Object obj) {
        if (obj instanceof INewsMark) {
            return Pair.create((Object)((INewsMark)obj).toReference(), (Object)false);
        }
        if (obj instanceof INews) {
            return this.getInput((INews)obj);
        }
        if (obj instanceof NewsReference) {
            INews resolvedNews = null;
            if (this.fViewer.getContentProvider() instanceof NewsContentProvider) {
                resolvedNews = ((NewsContentProvider)this.fViewer.getContentProvider()).obtainFromCache(((NewsReference)obj).getId());
            }
            if (resolvedNews == null) {
                resolvedNews = ((NewsReference)obj).resolve();
            }
            return this.getInput(resolvedNews);
        }
        return Pair.create((Object)obj, (Object)false);
    }

    private Pair<?, Boolean> getInput(INews news) {
        if (!this.fInputPreferences.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS)) {
            return Pair.create((Object)news, (Object)false);
        }
        if (this.fInputPreferences.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_EMPTY_NEWS) && !CoreUtils.isEmpty((INews)news)) {
            return Pair.create((Object)news, (Object)false);
        }
        String newsLink = CoreUtils.getLink((INews)news);
        if (!StringUtils.isSet((String)newsLink)) {
            return Pair.create((Object)news, (Object)false);
        }
        if (this.fInputPreferences.getBoolean(DefaultPreferences.BM_USE_TRANSFORMER)) {
            String transformerId = this.fInputPreferences.getString(DefaultPreferences.BM_TRANSFORMER_ID);
            LinkTransformer transformer = Controller.getDefault().getLinkTransformer(transformerId);
            if (transformer != null) {
                return Pair.create((Object)transformer.toTransformedUrl(newsLink), (Object)true);
            }
        }
        return Pair.create((Object)newsLink, (Object)false);
    }

    @Override
    public void dispose() {
        this.unregisterListeners();
        this.fEditorInput = null;
    }

    private void registerListener() {
        this.fSelectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection sel) {
                if (!part.equals(NewsBrowserControl.this.fFeedViewSite.getEditorSite().getPart())) {
                    return;
                }
                if (!NewsBrowserControl.this.fFeedViewSite.isBrowserViewerVisible()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)sel;
                if (selection.isEmpty() && NewsBrowserControl.this.fInputSet) {
                    NewsBrowserControl.this.fViewer.setInput(NewsBrowserControl.this.fInitialInput);
                } else if (selection.size() == 1) {
                    NewsBrowserControl.this.setPartInput(selection.getFirstElement());
                }
            }
        };
        this.fFeedViewSite.getEditorSite().getPage().addSelectionListener(this.fSelectionListener);
        ((Browser)this.fViewer.getControl()).addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                if (event.text != null && !event.text.contains("rssowl://") && !event.text.contains("127.0.0.1") && !NewsBrowserControl.this.fViewer.getControl().isDisposed() && NewsBrowserControl.this.fViewer.getControl().isVisible()) {
                    String statusText = event.text;
                    statusText = URIUtils.fastDecode((String)statusText);
                    if (URIUtils.isManaged((String)(statusText = statusText.replaceAll("&", "&&")))) {
                        statusText = URIUtils.toUnManaged((String)statusText);
                    }
                    NewsBrowserControl.this.fFeedViewSite.getEditorSite().getActionBars().getStatusLineManager().setMessage(statusText);
                }
            }
        });
        ((Browser)this.fViewer.getControl()).addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                if (event.doit) {
                    String loc = event.location;
                    boolean visible = NewsBrowserControl.this.fViewer.getControl().getVisible();
                    if (!visible && StringUtils.isSet((String)loc) && !"about:blank".equals(loc)) {
                        NewsBrowserControl.this.fViewer.getControl().setVisible(true);
                    }
                }
            }
        });
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (NewsBrowserControl.this.fViewer.getControl().isDisposed()) {
                    return;
                }
                String property = event.getProperty();
                if ("org.rssowl.ui.NewsTextFont".equals(property) || "org.rssowl.ui.StickyBGColor".equals(property) || "org.rssowl.ui.LinkFGColor".equals(property) || "org.rssowl.ui.NewsListBackgroundColor".equals(property)) {
                    NewsBrowserControl.this.fViewer.getBrowser().refresh();
                }
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    private void unregisterListeners() {
        this.fFeedViewSite.getEditorSite().getPage().removeSelectionListener(this.fSelectionListener);
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    @Override
    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }
}

