/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.browser;

import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.browser.IWebBrowser;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.browser.WebBrowserContext;
import org.rssowl.ui.internal.util.BrowserUtils;

public class EmbeddedWebBrowser
implements IWebBrowser {
    private final String fBrowserId;
    private WebBrowserContext fContext;

    public EmbeddedWebBrowser(String browserId) {
        this(browserId, null);
    }

    public EmbeddedWebBrowser(String browserId, WebBrowserContext context) {
        this.fBrowserId = browserId;
        this.fContext = context;
    }

    public void setContext(WebBrowserContext context) {
        this.fContext = context;
    }

    public void openURL(URL url) {
        this.openURL(url, false);
    }

    public void openURL(URL url, boolean forceOpenInBackground) {
        Assert.isNotNull((Object)url);
        if (OwlUI.useExternalBrowser()) {
            this.openExternal(url);
        } else {
            BrowserUtils.openLinkInternal(url.toExternalForm(), this.fContext, forceOpenInBackground);
        }
    }

    public void openURL(URI uri) {
        this.openURL(uri, false);
    }

    public void openURL(URI uri, boolean forceOpenInBackground) {
        Assert.isNotNull((Object)uri);
        if (OwlUI.useExternalBrowser()) {
            this.openExternal(uri);
        } else {
            BrowserUtils.openLinkInternal(uri.toString(), this.fContext, forceOpenInBackground);
        }
    }

    private void openExternal(URL url) {
        BrowserUtils.openLinkExternal(url.toExternalForm());
    }

    private void openExternal(URI uri) {
        BrowserUtils.openLinkExternal(uri.toString());
    }

    public boolean close() {
        return true;
    }

    public String getId() {
        return this.fBrowserId;
    }
}

