/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.undo.StickyOperation;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.ModelUtils;

public class MakeNewsStickyAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String ID = "org.rssowl.ui.actions.MarkSticky";
    private IStructuredSelection fSelection;
    private boolean fMarkSticky;

    public MakeNewsStickyAction() {
        this((IStructuredSelection)StructuredSelection.EMPTY);
    }

    public MakeNewsStickyAction(IStructuredSelection selection) {
        this.fSelection = selection;
        this.init();
    }

    public String getText() {
        IBindingService bs = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence binding = bs.getBestActiveBindingFor(ID);
        return binding != null ? NLS.bind((String)Messages.MakeNewsStickyAction_NEWS_STICKY_BINDING, (Object)binding.format()) : Messages.MakeNewsStickyAction_NEWS_STICKY;
    }

    public int getStyle() {
        return 2;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fMarkSticky ? OwlUI.NEWS_PIN : OwlUI.NEWS_PINNED;
    }

    public boolean isChecked() {
        return !this.fMarkSticky && !this.fSelection.isEmpty();
    }

    private void init() {
        List<INews> entities = ModelUtils.getEntities(this.fSelection, INews.class);
        for (INews entity : entities) {
            if (entity.isFlagged()) continue;
            this.fMarkSticky = true;
            break;
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        List<INews> newsList = ModelUtils.getEntities(this.fSelection, INews.class);
        if (newsList.isEmpty()) {
            return;
        }
        UndoStack.getInstance().addOperation(new StickyOperation(newsList, this.fMarkSticky));
        for (INews newsItem : newsList) {
            newsItem.setFlagged(this.fMarkSticky);
        }
        Controller.getDefault().getSavedSearchService().forceQuickUpdate();
        DynamicDAO.saveAll(newsList);
        this.fMarkSticky = !this.fMarkSticky;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

