/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2006 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mime.h"

char * create_mime_mail (char *filepath, char *text) {
	char *filename = get_file_name (filepath);	
	char *textmime;
	char *boundary = gen_boundary(); 
	
	struct loaded_file * file_content = encode_file (filepath);
	
	textmime = gitm_strcat ("\
MIME-Version: 1.0\r\n\
Content-Type: multipart/mixed;\r\n\
 boundary=\"", boundary);
	textmime = gitm_stradd (textmime, "\"\r\n\r\n\
--");
	textmime = gitm_stradd (textmime, boundary);
	textmime = gitm_stradd (textmime, "\r\n\
X-Mailer: Ghost In The Mail ");
	textmime = gitm_stradd (textmime, GITM_VERSION);
	textmime = gitm_stradd (textmime,"\
\r\n\
Content-Type: text/plain\r\n\
Content-Transfer-Encoding: 8bit\r\n\r\n");
	textmime = gitm_stradd (textmime, text);
	textmime = gitm_stradd (textmime, "\
\r\n--");
	textmime = gitm_stradd (textmime, boundary);
	textmime = gitm_stradd (textmime, "\r\n\
Content-Type: application/octet-stream;\r\n\
 name=\"");
	textmime = gitm_stradd (textmime, filename);
	textmime = gitm_stradd (textmime, "\
\"\r\n\
Content-Transfer-Encoding: base64\r\n\
Content-Disposition: attachment;\r\n\
 filename=\"");
	textmime = gitm_stradd (textmime, filename);
	textmime = gitm_stradd (textmime, "\"\r\n\r\n");
	textmime = gitm_stradd (textmime, file_content->data);
	textmime = gitm_stradd (textmime, "\r\n--");
	textmime = gitm_stradd (textmime, boundary);
	textmime = gitm_stradd (textmime, "\r\n");
	
	free(file_content);
	
	return textmime;
}

/* generate the MIME boundary */
char * gen_boundary () {
	char *boundary = gitm_malloc (32);;
	srandom((int)time((time_t *)NULL));
	int i = random();
	snprintf (boundary, 32, "boundary%d%d999", i, i);
	return boundary;	
}
