/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.core.jobs;

import org.apache.directory.studio.common.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StudioJob<T extends StudioRunnableWithProgress>
extends Job {
    protected T[] runnables;

    public StudioJob(T ... runnables) {
        super(runnables[0].getName());
        this.runnables = runnables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor ipm) {
        StudioProgressMonitor monitor = new StudioProgressMonitor(ipm);
        if (!monitor.errorsReported()) {
            try {
                for (T runnable : this.runnables) {
                    if (runnable instanceof StudioBulkRunnableWithProgress) {
                        StudioBulkRunnableWithProgress bulkRunnable = (StudioBulkRunnableWithProgress)runnable;
                        this.suspendEventFiringInCurrentThread();
                        try {
                            bulkRunnable.run(monitor);
                        }
                        finally {
                            this.resumeEventFiringInCurrentThread();
                        }
                        bulkRunnable.runNotification(monitor);
                        continue;
                    }
                    runnable.run(monitor);
                }
            }
            catch (Exception e) {
                monitor.reportError(e);
            }
        }
        monitor.done();
        ipm.done();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.errorsReported()) {
            return monitor.getErrorStatus(this.runnables[0].getErrorMessage());
        }
        return Status.OK_STATUS;
    }

    protected void suspendEventFiringInCurrentThread() {
    }

    protected void resumeEventFiringInCurrentThread() {
    }

    public void execute() {
        this.setUser(true);
        this.schedule();
    }

    public boolean shouldSchedule() {
        for (T runnable : this.runnables) {
            Object[] myLockedObjects = runnable.getLockedObjects();
            String[] myLockedObjectsIdentifiers = this.getLockIdentifiers(myLockedObjects);
            Job[] jobs = StudioJob.getJobManager().find(null);
            for (int i = 0; i < jobs.length; ++i) {
                Job job = jobs[i];
                if (!(job instanceof StudioJob)) continue;
                StudioJob otherJob = (StudioJob)job;
                for (T otherRunnable : otherJob.runnables) {
                    if (runnable.getClass() != otherRunnable.getClass() || runnable == otherRunnable) continue;
                    Object[] otherLockedObjects = otherRunnable.getLockedObjects();
                    String[] otherLockedObjectIdentifiers = this.getLockIdentifiers(otherLockedObjects);
                    for (int j = 0; j < otherLockedObjectIdentifiers.length; ++j) {
                        String other = otherLockedObjectIdentifiers[j];
                        for (int k = 0; k < myLockedObjectsIdentifiers.length; ++k) {
                            String my = myLockedObjectsIdentifiers[k];
                            if (!other.startsWith(my) && !my.startsWith(other)) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return super.shouldSchedule();
    }

    protected String[] getLockIdentifiers(Object[] objects) {
        String[] identifiers = new String[objects.length];
        for (int i = 0; i < identifiers.length; ++i) {
            identifiers[i] = this.getLockIdentifier(objects[i]);
        }
        return identifiers;
    }

    private String getLockIdentifier(Object object) {
        return object != null ? object.toString() : "null";
    }

    public boolean belongsTo(Object family) {
        return this.getFamily().equals(family);
    }

    public Object getFamily() {
        return "org.apache.directory.studio.common.core.jobs.family";
    }
}

