/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.valueeditors;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.valueeditors.Messages;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.ExtendedContentAssistCommandAdapter;
import org.apache.directory.studio.ldapbrowser.common.widgets.ListContentProposalProvider;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RestrictedByValueEditor
extends AbstractDialogStringValueEditor {
    private static final String L_CURLY_TYPE = "{ type ";
    private static final String SEP_VALUESIN = ", valuesIn ";
    private static final String R_CURLY = " }";
    private static final String EMPTY = "";

    public boolean openDialog(Shell shell) {
        RestrictedByValueEditorRawValueWrapper wrapper;
        RestrictedByDialog dialog;
        Object value = this.getValue();
        if (value != null && value instanceof RestrictedByValueEditorRawValueWrapper && (dialog = new RestrictedByDialog(shell, (wrapper = (RestrictedByValueEditorRawValueWrapper)value).schema, wrapper.type, wrapper.valuesIn)).open() == 0 && !EMPTY.equals(dialog.getType()) && !EMPTY.equals(dialog.getValuesIn())) {
            this.setValue(L_CURLY_TYPE + dialog.getType() + SEP_VALUESIN + dialog.getValuesIn() + R_CURLY);
            return true;
        }
        return false;
    }

    public Object getRawValue(IValue value) {
        return value != null ? this.getRawValue(value.getAttribute().getEntry().getBrowserConnection(), value.getStringValue()) : null;
    }

    private Object getRawValue(IBrowserConnection connection, Object value) {
        Schema schema = null;
        if (connection != null) {
            schema = connection.getSchema();
        }
        if (schema == null || value == null || !(value instanceof String)) {
            return null;
        }
        String stringValue = (String)value;
        String type = EMPTY;
        String valuesIn = EMPTY;
        try {
            Pattern pattern = Pattern.compile("\\s*\\{\\s*type\\s*([^,\\s]*)\\s*,\\s*valuesIn\\s*([^,\\s]*)\\s*\\}\\s*");
            Matcher matcher = pattern.matcher(stringValue);
            type = matcher.matches() ? matcher.group(1) : EMPTY;
            valuesIn = matcher.matches() ? matcher.group(2) : EMPTY;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        RestrictedByValueEditorRawValueWrapper wrapper = new RestrictedByValueEditorRawValueWrapper(schema, type, valuesIn);
        return wrapper;
    }

    private class RestrictedByDialog
    extends Dialog {
        private Schema schema;
        private String initialType;
        private String initialValuesIn;
        private Combo typeCombo;
        private Combo valuesInCombo;
        private String returnType;
        private String returnValuesIn;

        public RestrictedByDialog(Shell parentShell, Schema schema, String initialType, String initialValuesIn) {
            super(parentShell);
            super.setShellStyle(super.getShellStyle() | 0x10);
            this.initialType = initialType;
            this.initialValuesIn = initialValuesIn;
            this.schema = schema;
            this.returnType = null;
            this.returnValuesIn = null;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.getString("RestrictedByValueEditor.title"));
            shell.setImage(Activator.getDefault().getImage(Messages.getString("RestrictedByValueEditor.icon")));
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
        }

        protected void okPressed() {
            this.returnType = this.typeCombo.getText();
            this.returnValuesIn = this.valuesInCombo.getText();
            super.okPressed();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertHorizontalDLUsToPixels(300);
            composite.setLayoutData((Object)gd);
            composite.setLayout((Layout)new GridLayout(5, false));
            BaseWidgetUtils.createLabel((Composite)composite, (String)RestrictedByValueEditor.L_CURLY_TYPE, (int)1);
            Collection names = SchemaUtils.getNames((Collection)this.schema.getAttributeTypeDescriptions());
            Object[] allAtNames = names.toArray(new String[names.size()]);
            Arrays.sort(allAtNames);
            this.typeCombo = BaseWidgetUtils.createCombo((Composite)composite, (String[])allAtNames, (int)-1, (int)1);
            this.typeCombo.setText(this.initialType);
            new ExtendedContentAssistCommandAdapter((Control)this.typeCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new ListContentProposalProvider(this.typeCombo.getItems()), null, null, true);
            BaseWidgetUtils.createLabel((Composite)composite, (String)RestrictedByValueEditor.SEP_VALUESIN, (int)1);
            this.valuesInCombo = BaseWidgetUtils.createCombo((Composite)composite, (String[])allAtNames, (int)-1, (int)1);
            this.valuesInCombo.setText(this.initialValuesIn);
            new ExtendedContentAssistCommandAdapter((Control)this.valuesInCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new ListContentProposalProvider(this.valuesInCombo.getItems()), null, null, true);
            BaseWidgetUtils.createLabel((Composite)composite, (String)RestrictedByValueEditor.R_CURLY, (int)1);
            RestrictedByDialog.applyDialogFont((Control)composite);
            return composite;
        }

        public String getType() {
            return this.returnType;
        }

        public String getValuesIn() {
            return this.returnValuesIn;
        }
    }

    private class RestrictedByValueEditorRawValueWrapper {
        private Schema schema;
        private String type;
        private String valuesIn;

        private RestrictedByValueEditorRawValueWrapper(Schema schema, String type, String valuesIn) {
            this.schema = schema;
            this.type = type;
            this.valuesIn = valuesIn;
        }
    }
}

