/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.valueeditors;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.valueeditors.Messages;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.ExtendedContentAssistCommandAdapter;
import org.apache.directory.studio.ldapbrowser.common.widgets.ListContentProposalProvider;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class MaxValueCountValueEditor
extends AbstractDialogStringValueEditor {
    private static final String L_CURLY_TYPE = "{ type ";
    private static final String SEP_MAXCOUNT = ", maxCount ";
    private static final String R_CURLY = " }";
    private static final String EMPTY = "";

    public boolean openDialog(Shell shell) {
        MaxValueCountValueEditorRawValueWrapper wrapper;
        MaxValueCountDialog dialog;
        Object value = this.getValue();
        if (value != null && value instanceof MaxValueCountValueEditorRawValueWrapper && (dialog = new MaxValueCountDialog(shell, (wrapper = (MaxValueCountValueEditorRawValueWrapper)value).schema, wrapper.type, wrapper.maxCount)).open() == 0 && !EMPTY.equals(dialog.getType()) && dialog.getMaxCount() > -1) {
            this.setValue(L_CURLY_TYPE + dialog.getType() + SEP_MAXCOUNT + dialog.getMaxCount() + R_CURLY);
            return true;
        }
        return false;
    }

    public Object getRawValue(IValue value) {
        return value != null ? this.getRawValue(value.getAttribute().getEntry().getBrowserConnection(), value.getStringValue()) : null;
    }

    private Object getRawValue(IBrowserConnection connection, Object value) {
        Schema schema = null;
        if (connection != null) {
            schema = connection.getSchema();
        }
        if (schema == null || value == null || !(value instanceof String)) {
            return null;
        }
        String stringValue = (String)value;
        String type = EMPTY;
        int maxCount = 0;
        try {
            Pattern pattern = Pattern.compile("\\s*\\{\\s*type\\s*([^,]*),\\s*maxCount\\s*(\\d*)\\s*\\}\\s*");
            Matcher matcher = pattern.matcher(stringValue);
            type = matcher.matches() ? matcher.group(1) : EMPTY;
            maxCount = matcher.matches() ? Integer.valueOf(matcher.group(2)) : 0;
        }
        catch (Exception e) {
            // empty catch block
        }
        MaxValueCountValueEditorRawValueWrapper wrapper = new MaxValueCountValueEditorRawValueWrapper(schema, type, maxCount);
        return wrapper;
    }

    private class MaxValueCountDialog
    extends Dialog {
        private Schema schema;
        private String initialType;
        private int initialMaxCount;
        private Combo attributeTypeCombo;
        private Spinner maxCountSpinner;
        private String returnType;
        private int returnMaxCount;

        public MaxValueCountDialog(Shell parentShell, Schema schema, String initialType, int initialMaxCount) {
            super(parentShell);
            super.setShellStyle(super.getShellStyle() | 0x10);
            this.initialType = initialType;
            this.initialMaxCount = initialMaxCount;
            this.schema = schema;
            this.returnType = null;
            this.returnMaxCount = -1;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.getString("MaxValueCountValueEditor.title"));
            shell.setImage(Activator.getDefault().getImage(Messages.getString("MaxValueCountValueEditor.icon")));
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
        }

        protected void okPressed() {
            this.returnType = this.attributeTypeCombo.getText();
            this.returnMaxCount = this.maxCountSpinner.getSelection();
            super.okPressed();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertHorizontalDLUsToPixels(300);
            composite.setLayoutData((Object)gd);
            composite.setLayout((Layout)new GridLayout(5, false));
            BaseWidgetUtils.createLabel((Composite)composite, (String)MaxValueCountValueEditor.L_CURLY_TYPE, (int)1);
            Collection names = SchemaUtils.getNames((Collection)this.schema.getAttributeTypeDescriptions());
            Object[] allAtNames = names.toArray(new String[names.size()]);
            Arrays.sort(allAtNames);
            this.attributeTypeCombo = BaseWidgetUtils.createCombo((Composite)composite, (String[])allAtNames, (int)-1, (int)1);
            this.attributeTypeCombo.setText(this.initialType);
            new ExtendedContentAssistCommandAdapter((Control)this.attributeTypeCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new ListContentProposalProvider(this.attributeTypeCombo.getItems()), null, null, true);
            BaseWidgetUtils.createLabel((Composite)composite, (String)MaxValueCountValueEditor.SEP_MAXCOUNT, (int)1);
            this.maxCountSpinner = new Spinner(composite, 2048);
            this.maxCountSpinner.setMinimum(0);
            this.maxCountSpinner.setMaximum(Integer.MAX_VALUE);
            this.maxCountSpinner.setDigits(0);
            this.maxCountSpinner.setIncrement(1);
            this.maxCountSpinner.setPageIncrement(100);
            this.maxCountSpinner.setSelection(this.initialMaxCount);
            this.maxCountSpinner.setLayoutData((Object)new GridData(768));
            BaseWidgetUtils.createLabel((Composite)composite, (String)MaxValueCountValueEditor.R_CURLY, (int)1);
            MaxValueCountDialog.applyDialogFont((Control)composite);
            return composite;
        }

        public String getType() {
            return this.returnType;
        }

        public int getMaxCount() {
            return this.returnMaxCount;
        }
    }

    private class MaxValueCountValueEditorRawValueWrapper {
        private Schema schema;
        private String type;
        private int maxCount;

        private MaxValueCountValueEditorRawValueWrapper(Schema schema, String type, int maxCount) {
            this.schema = schema;
            this.type = type;
            this.maxCount = maxCount;
        }
    }
}

