/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.apacheds.v155;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIOException;
import org.apache.directory.studio.apacheds.configuration.model.v155.ServerConfigurationV155;
import org.apache.directory.studio.apacheds.configuration.model.v155.ServerXmlIOV155;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.ui.filesystem.PathEditorInput;
import org.apache.directory.studio.ldapservers.LdapServersManager;
import org.apache.directory.studio.ldapservers.LdapServersUtils;
import org.apache.directory.studio.ldapservers.apacheds.v155.ApacheDS155Plugin;
import org.apache.directory.studio.ldapservers.apacheds.v155.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapter;
import org.apache.mina.util.AvailablePortFinder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ApacheDS155LdapServerAdapter
implements LdapServerAdapter {
    private static final String SERVER_XML = "server.xml";
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String RESOURCES = "resources";
    private static final String LIBS = "libs";
    private static final String CONF = "conf";
    private static final String[] libraries = new String[]{"antlr-2.7.7.jar", "apacheds-bootstrap-extract-1.5.5.jar", "apacheds-bootstrap-partition-1.5.5.jar", "apacheds-core-1.5.5.jar", "apacheds-core-avl-1.5.5.jar", "apacheds-core-constants-1.5.5.jar", "apacheds-core-entry-1.5.5.jar", "apacheds-core-jndi-1.5.5.jar", "apacheds-core-shared-1.5.5.jar", "apacheds-interceptor-kerberos-1.5.5.jar", "apacheds-jdbm-1.5.5.jar", "apacheds-jdbm-store-1.5.5.jar", "apacheds-kerberos-shared-1.5.5.jar", "apacheds-launcher-1.5.0.jar", "apacheds-protocol-changepw-1.5.5.jar", "apacheds-protocol-dns-1.5.5.jar", "apacheds-protocol-kerberos-1.5.5.jar", "apacheds-protocol-ldap-1.5.5.jar", "apacheds-protocol-ntp-1.5.5.jar", "apacheds-protocol-shared-1.5.5.jar", "apacheds-schema-bootstrap-1.5.5.jar", "apacheds-schema-extras-1.5.5.jar", "apacheds-schema-registries-1.5.5.jar", "apacheds-server-jndi-1.5.5.jar", "apacheds-server-xml-1.5.5.jar", "apacheds-utils-1.5.5.jar", "apacheds-xbean-spring-1.5.5.jar", "apacheds-xdbm-base-1.5.5.jar", "apacheds-xdbm-search-1.5.5.jar", "apacheds-xdbm-tools-1.5.5.jar", "bcprov-jdk15-140.jar", "commons-cli-1.2.jar", "commons-collections-3.2.1.jar", "commons-daemon-1.0.1.jar", "commons-io-1.4.jar", "commons-lang-2.4.jar", "daemon-bootstrappers-1.1.6.jar", "jcl-over-slf4j-1.5.6.jar", "log4j-1.2.14.jar", "mina-core-2.0.0-M6.jar", "shared-asn1-0.9.15.jar", "shared-asn1-codec-0.9.15.jar", "shared-cursor-0.9.15.jar", "shared-ldap-0.9.15.jar", "shared-ldap-constants-0.9.15.jar", "slf4j-api-1.5.6.jar", "slf4j-log4j12-1.5.6.jar", "spring-beans-2.5.6.SEC01.jar", "spring-context-2.5.6.SEC01.jar", "spring-core-2.5.6.SEC01.jar", "xbean-spring-3.5.jar"};

    public void add(LdapServer server, StudioProgressMonitor monitor) throws Exception {
        Bundle bundle = ApacheDS155Plugin.getDefault().getBundle();
        LdapServersUtils.verifyAndCopyLibraries((Bundle)bundle, (IPath)new Path(RESOURCES).append(LIBS), (IPath)ApacheDS155LdapServerAdapter.getServerLibrariesFolder(), (String[])libraries, (StudioProgressMonitor)monitor, (String)Messages.getString("ApacheDS155LdapServerAdapter.VerifyingAndCopyingLibraries"));
        monitor.subTask(Messages.getString("ApacheDS155LdapServerAdapter.CreatingServerFolderStructure"));
        File serverFolder = LdapServersManager.getServerFolder((LdapServer)server).toFile();
        File confFolder = new File(serverFolder, CONF);
        confFolder.mkdir();
        File ldifFolder = new File(serverFolder, "ldif");
        ldifFolder.mkdir();
        File logFolder = new File(serverFolder, "log");
        logFolder.mkdir();
        File partitionFolder = new File(serverFolder, "partitions");
        partitionFolder.mkdir();
        monitor.subTask(Messages.getString("ApacheDS155LdapServerAdapter.CopyingConfigurationFiles"));
        IPath resourceConfFolderPath = new Path(RESOURCES).append(CONF);
        LdapServersUtils.copyResource((Bundle)bundle, (IPath)resourceConfFolderPath.append(SERVER_XML), (File)new File(confFolder, SERVER_XML));
        LdapServersUtils.copyResource((Bundle)bundle, (IPath)resourceConfFolderPath.append(LOG4J_PROPERTIES), (File)new File(confFolder, LOG4J_PROPERTIES));
        new File(logFolder, "apacheds.log").createNewFile();
    }

    public void delete(LdapServer server, StudioProgressMonitor monitor) throws Exception {
    }

    public void openConfiguration(final LdapServer server, final StudioProgressMonitor monitor) throws Exception {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PathEditorInput input = new PathEditorInput(LdapServersManager.getServerFolder((LdapServer)server).append(ApacheDS155LdapServerAdapter.CONF).append(ApacheDS155LdapServerAdapter.SERVER_XML));
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, ServerConfigurationEditor.ID);
                }
                catch (PartInitException e) {
                    monitor.reportError((Exception)((Object)e));
                }
            }
        });
    }

    public void start(LdapServer server, StudioProgressMonitor monitor) throws Exception {
        Bundle bundle = ApacheDS155Plugin.getDefault().getBundle();
        LdapServersUtils.verifyAndCopyLibraries((Bundle)bundle, (IPath)new Path(RESOURCES).append(LIBS), (IPath)ApacheDS155LdapServerAdapter.getServerLibrariesFolder(), (String[])libraries, (StudioProgressMonitor)monitor, (String)Messages.getString("ApacheDS155LdapServerAdapter.VerifyingAndCopyingLibraries"));
        LdapServersUtils.startConsolePrinterThread((LdapServer)server);
        ILaunch launch = LdapServersUtils.launchApacheDS((LdapServer)server, (IPath)ApacheDS155LdapServerAdapter.getServerLibrariesFolder(), (String[])libraries);
        LdapServersUtils.startTerminateListenerThread((LdapServer)server, (ILaunch)launch);
        LdapServersUtils.runStartupListenerWatchdog((LdapServer)server, (int)this.getTestingPort(server));
    }

    public void stop(LdapServer server, StudioProgressMonitor monitor) throws Exception {
        LdapServersUtils.stopConsolePrinterThread((LdapServer)server);
        LdapServersUtils.terminateLaunchConfiguration((LdapServer)server);
    }

    private static IPath getServerLibrariesFolder() {
        return ApacheDS155Plugin.getDefault().getStateLocation().append(LIBS);
    }

    public static ServerConfigurationV155 getServerConfiguration(LdapServer server) throws ServerXmlIOException, FileNotFoundException {
        FileInputStream fis = new FileInputStream(LdapServersManager.getServerFolder((LdapServer)server).append(CONF).append(SERVER_XML).toFile());
        ServerXmlIOV155 serverXmlIOV155 = new ServerXmlIOV155();
        return (ServerConfigurationV155)serverXmlIOV155.parse((InputStream)fis);
    }

    private int getTestingPort(LdapServer server) throws ServerXmlIOException, IOException {
        ServerConfigurationV155 configuration = ApacheDS155LdapServerAdapter.getServerConfiguration(server);
        if (configuration.isEnableLdap()) {
            return configuration.getLdapPort();
        }
        if (configuration.isEnableLdaps()) {
            return configuration.getLdapsPort();
        }
        if (configuration.isEnableKerberos()) {
            return configuration.getKerberosPort();
        }
        if (configuration.isEnableDns()) {
            return configuration.getDnsPort();
        }
        if (configuration.isEnableNtp()) {
            return configuration.getNtpPort();
        }
        if (configuration.isEnableChangePassword()) {
            return configuration.getChangePasswordPort();
        }
        return 0;
    }

    public String[] checkPortsBeforeServerStart(LdapServer server) throws Exception {
        ArrayList<String> alreadyInUseProtocolPortsList = new ArrayList<String>();
        ServerConfigurationV155 configuration = ApacheDS155LdapServerAdapter.getServerConfiguration(server);
        if (configuration.isEnableLdap() && !AvailablePortFinder.available((int)configuration.getLdapPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS155LdapServerAdapter.LDAPPort"), (Object[])new Object[]{configuration.getLdapPort()}));
        }
        if (configuration.isEnableLdaps() && !AvailablePortFinder.available((int)configuration.getLdapsPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS155LdapServerAdapter.LDAPSPort"), (Object[])new Object[]{configuration.getLdapsPort()}));
        }
        if (configuration.isEnableKerberos() && !AvailablePortFinder.available((int)configuration.getKerberosPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS155LdapServerAdapter.KerberosPort"), (Object[])new Object[]{configuration.getKerberosPort()}));
        }
        if (configuration.isEnableDns() && !AvailablePortFinder.available((int)configuration.getDnsPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS155LdapServerAdapter.DNSPort"), (Object[])new Object[]{configuration.getDnsPort()}));
        }
        if (configuration.isEnableNtp() && !AvailablePortFinder.available((int)configuration.getNtpPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS155LdapServerAdapter.NTPPort"), (Object[])new Object[]{configuration.getNtpPort()}));
        }
        if (configuration.isEnableChangePassword() && !AvailablePortFinder.available((int)configuration.getChangePasswordPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS155LdapServerAdapter.ChangePasswordPort"), (Object[])new Object[]{configuration.getChangePasswordPort()}));
        }
        return alreadyInUseProtocolPortsList.toArray(new String[0]);
    }
}

