/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.jobs;

import java.util.UUID;
import javax.naming.InvalidNameException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;

public class EntryBasedConfigurationPartition
extends AbstractLdifPartition {
    public EntryBasedConfigurationPartition(SchemaManager schemaManager) {
        super(schemaManager);
    }

    protected void doInit() throws InvalidNameException, Exception {
        this.setId("config");
        this.setSuffixDn(new Dn(new String[]{"ou=config"}));
        super.doInit();
    }

    public void addEntry(Entry entry) throws Exception {
        this.addMandatoryOpAt(entry);
        this.add(new AddOperationContext(null, entry));
    }

    private void addMandatoryOpAt(Entry entry) throws LdapException {
        if (entry.get("entryCSN") == null) {
            entry.add("entryCSN", new String[]{defaultCSNFactory.newInstance().toString()});
        }
        if (entry.get("entryUUID") == null) {
            String uuid = UUID.randomUUID().toString();
            entry.add("entryUUID", new String[]{uuid});
        }
    }
}

