/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.editor;

import org.apache.directory.server.config.beans.ConfigBean;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.studio.apacheds.configuration.v2.actions.EditorExportConfigurationAction;
import org.apache.directory.studio.apacheds.configuration.v2.actions.EditorImportConfigurationAction;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ConnectionServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.v2.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditor;
import org.apache.directory.studio.connection.core.Connection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class ServerConfigurationEditorPage
extends FormPage {
    protected static final Color GRAY_COLOR = new Color(null, 120, 120, 120);
    protected static final String TABULATION = "      ";
    private ModifyListener dirtyModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ServerConfigurationEditorPage.this.setEditorDirty();
        }
    };
    private SelectionListener dirtySelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ServerConfigurationEditorPage.this.setEditorDirty();
        }
    };
    private ISelectionChangedListener dirtySelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ServerConfigurationEditorPage.this.setEditorDirty();
        }
    };

    public ServerConfigurationEditorPage(ServerConfigurationEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
    }

    public ServerConfigurationEditor getServerConfigurationEditor() {
        return (ServerConfigurationEditor)this.getEditor();
    }

    protected void setEditorDirty() {
        this.getServerConfigurationEditor().setDirty(true);
    }

    public ConfigBean getConfigBean() {
        ConfigBean configBean = this.getServerConfigurationEditor().getConfigBean();
        if (configBean == null) {
            configBean = new ConfigBean();
            this.getServerConfigurationEditor().setConfiguration(configBean);
        }
        return configBean;
    }

    public DirectoryServiceBean getDirectoryServiceBean() {
        DirectoryServiceBean directoryServiceBean = this.getConfigBean().getDirectoryServiceBean();
        if (directoryServiceBean == null) {
            directoryServiceBean = new DirectoryServiceBean();
            this.getConfigBean().addDirectoryService(new DirectoryServiceBean[]{directoryServiceBean});
        }
        return directoryServiceBean;
    }

    public Connection getConnection() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof ConnectionServerConfigurationInput) {
            return ((ConnectionServerConfigurationInput)editorInput).getConnection();
        }
        return null;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setText(this.getTitle());
        Composite parent = form.getBody();
        parent.setLayout((Layout)new GridLayout());
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        ServerConfigurationEditor editor = (ServerConfigurationEditor)this.getEditor();
        IToolBarManager toolbarManager = form.getToolBarManager();
        toolbarManager.add((IAction)new EditorImportConfigurationAction(editor));
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)new EditorExportConfigurationAction(editor));
        toolbarManager.update(true);
        this.createFormContent(parent, toolkit);
    }

    protected abstract void createFormContent(Composite var1, FormToolkit var2);

    protected abstract void refreshUI();

    protected Text createPortText(FormToolkit toolkit, Composite parent) {
        Text portText = toolkit.createText(parent, "");
        GridData gd = new GridData(0, 0, false, false);
        gd.widthHint = 42;
        portText.setLayoutData((Object)gd);
        portText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        portText.setTextLimit(5);
        return portText;
    }

    protected Text createIntegerText(FormToolkit toolkit, Composite parent) {
        Text integerText = toolkit.createText(parent, "");
        integerText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        return integerText;
    }

    protected Label createDefaultValueLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, NLS.bind((String)Messages.getString("ServerConfigurationEditorPage.DefaultWithValue"), (Object)text), 64);
        label.setForeground(GRAY_COLOR);
        return label;
    }

    protected void addModifyListener(Text text, ModifyListener listener) {
        if (text != null && !text.isDisposed() && listener != null) {
            text.addModifyListener(listener);
        }
    }

    protected void addSelectionChangedListener(Viewer viewer, ISelectionChangedListener listener) {
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && listener != null) {
            viewer.addSelectionChangedListener(listener);
        }
    }

    protected void addDoubleClickListener(StructuredViewer viewer, IDoubleClickListener listener) {
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && listener != null) {
            viewer.addDoubleClickListener(listener);
        }
    }

    protected void addSelectionListener(Button button, SelectionListener listener) {
        if (button != null && !button.isDisposed() && listener != null) {
            button.addSelectionListener(listener);
        }
    }

    protected void removeModifyListener(Text text, ModifyListener listener) {
        if (text != null && !text.isDisposed() && listener != null) {
            text.removeModifyListener(listener);
        }
    }

    protected void removeSelectionChangedListener(Viewer viewer, ISelectionChangedListener listener) {
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && listener != null) {
            viewer.removeSelectionChangedListener(listener);
        }
    }

    protected void removeDoubleClickListener(StructuredViewer viewer, IDoubleClickListener listener) {
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && listener != null) {
            viewer.removeDoubleClickListener(listener);
        }
    }

    protected void removeSelectionListener(Button button, SelectionListener listener) {
        if (button != null && !button.isDisposed() && listener != null) {
            button.removeSelectionListener(listener);
        }
    }

    protected void addDirtyListener(Text text) {
        this.addModifyListener(text, this.dirtyModifyListener);
    }

    protected void addDirtyListener(Button button) {
        this.addSelectionListener(button, this.dirtySelectionListener);
    }

    protected void addDirtyListener(Viewer viewer) {
        this.addSelectionChangedListener(viewer, this.dirtySelectionChangedListener);
    }

    protected void removeDirtyListener(Text text) {
        this.removeModifyListener(text, this.dirtyModifyListener);
    }

    protected void removeDirtyListener(Button button) {
        this.removeSelectionListener(button, this.dirtySelectionListener);
    }

    protected void removeDirtyListener(Viewer viewer) {
        this.removeSelectionChangedListener(viewer, this.dirtySelectionChangedListener);
    }

    protected void setSelection(Button button, boolean selected) {
        if (button != null && !button.isDisposed()) {
            button.setSelection(selected);
        }
    }

    protected void setSelection(Viewer viewer, Object selection) {
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            viewer.setSelection((ISelection)new StructuredSelection(selection));
        }
    }

    protected void setText(Text text, String string) {
        if (text != null && !text.isDisposed()) {
            if (string == null) {
                string = "";
            }
            text.setText(string);
        }
    }

    protected void setFocus(Control control) {
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    protected void setEnabled(Control control, boolean enabled) {
        if (control != null && !control.isDisposed()) {
            control.setEnabled(enabled);
        }
    }

    protected void setGridDataWithDefaultWidth(Control control, GridData gd) {
        gd.widthHint = 50;
        control.setLayoutData((Object)gd);
    }
}

