/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.editor;

import java.io.File;
import java.util.List;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.server.config.beans.ExtendedOpHandlerBean;
import org.apache.directory.server.config.beans.InterceptorBean;
import org.apache.directory.server.config.beans.LdapServerBean;
import org.apache.directory.server.config.beans.SaslMechHandlerBean;
import org.apache.directory.server.config.beans.ServerBean;
import org.apache.directory.server.config.beans.TransportBean;
import org.apache.directory.studio.apacheds.configuration.v2.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditorPage;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LdapLdapsServersPage
extends ServerConfigurationEditorPage {
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private static final int DEFAULT_PORT_LDAPS = 10636;
    private static final int DEFAULT_PORT_LDAP = 10389;
    private static final String TRANSPORT_ID_LDAP = "ldap";
    private static final String TRANSPORT_ID_LDAPS = "ldaps";
    private static final String SASL_MECHANISMS_SIMPLE = "SIMPLE";
    private static final String START_TLS_HANDLER_ID = "starttlshandler";
    private static final String START_TLS_HANDLER_CLASS = "org.apache.directory.server.ldap.handlers.extended.StartTlsHandler";
    private static final String HASHING_PASSWORD_INTERCEPTOR_ID = "passwordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA512 = "org.apache.directory.server.core.hash.Ssha512PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA512 = "org.apache.directory.server.core.hash.Sha512PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA384 = "org.apache.directory.server.core.hash.Ssha384PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA384 = "org.apache.directory.server.core.hash.Sha384PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA256 = "org.apache.directory.server.core.hash.Ssha256PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA256 = "org.apache.directory.server.core.hash.Sha256PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_CRYPT = "org.apache.directory.server.core.hash.CryptPasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SMD5 = "org.apache.directory.server.core.hash.Smd5PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_MD5 = "org.apache.directory.server.core.hash.Md5PasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA = "org.apache.directory.server.core.hash.SshaPasswordHashingInterceptor";
    private static final String HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA = "org.apache.directory.server.core.hash.ShaPasswordHashingInterceptor";
    public static final String ID = LdapLdapsServersPage.class.getName();
    private static final String TITLE = Messages.getString("LdapLdapsServersPage.LdapLdapsServers");
    private Button enableLdapCheckbox;
    private Text ldapPortText;
    private Button enableLdapsCheckbox;
    private Text ldapsPortText;
    private Text maxTimeLimitText;
    private Text maxSizeLimitText;
    private Button authMechSimpleCheckbox;
    private Button authMechCramMd5Checkbox;
    private Button authMechDigestMd5Checkbox;
    private Button authMechGssapiCheckbox;
    private Button authMechNtlmCheckbox;
    private Text authMechNtlmText;
    private Button authMechGssSpnegoCheckbox;
    private Text authMechGssSpnegoText;
    private Text saslHostText;
    private Text saslPrincipalText;
    private Text saslSearchBaseDnText;
    private Button enableTlsCheckbox;
    private Button enableServerSidePasswordHashingCheckbox;
    private ComboViewer hashingMethodComboViewer;
    private Text keystoreFileText;
    private Button keystoreFileBrowseButton;
    private Text keystorePasswordText;
    private Button showPasswordCheckbox;
    private TableViewer cipherSuitesTableViewer;
    private Button addCipherSuiteButton;
    private Button editCipherSuiteButton;
    private Button deleteCipherSuiteButton;
    private Text replicationPingerSleepText;
    private Text diskSynchronizationDelayText;
    private SelectionAdapter enableLdapCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.getLdapServerTransportBean().setEnabled(LdapLdapsServersPage.this.enableLdapCheckbox.getSelection());
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.ldapPortText, LdapLdapsServersPage.this.enableLdapCheckbox.getSelection());
        }
    };
    private ModifyListener ldapPortTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LdapLdapsServersPage.this.getLdapServerTransportBean().setSystemPort(Integer.parseInt(LdapLdapsServersPage.this.ldapPortText.getText()));
        }
    };
    private SelectionAdapter enableLdapsCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.getLdapsServerTransportBean().setEnabled(LdapLdapsServersPage.this.enableLdapsCheckbox.getSelection());
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.ldapsPortText, LdapLdapsServersPage.this.enableLdapsCheckbox.getSelection());
        }
    };
    private ModifyListener ldapsPortTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LdapLdapsServersPage.this.getLdapsServerTransportBean().setSystemPort(Integer.parseInt(LdapLdapsServersPage.this.ldapsPortText.getText()));
        }
    };
    private ModifyListener saslHostTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LdapLdapsServersPage.this.getLdapServerBean().setLdapServerSaslHost(LdapLdapsServersPage.this.saslHostText.getText());
        }
    };
    private ModifyListener saslPrincipalTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LdapLdapsServersPage.this.getLdapServerBean().setLdapServerSaslPrincipal(LdapLdapsServersPage.this.saslPrincipalText.getText());
        }
    };
    private ModifyListener saslSearchBaseDnTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String searchBaseDnValue = LdapLdapsServersPage.this.saslSearchBaseDnText.getText();
            try {
                Dn searchBaseDn = new Dn(new String[]{searchBaseDnValue});
                LdapLdapsServersPage.this.getLdapServerBean().setSearchBaseDn(searchBaseDn);
            }
            catch (LdapInvalidDnException ldapInvalidDnException) {
                // empty catch block
            }
        }
    };
    private SelectionAdapter authMechSimpleCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism(LdapLdapsServersPage.SASL_MECHANISMS_SIMPLE, LdapLdapsServersPage.this.authMechSimpleCheckbox.getSelection());
        }
    };
    private SelectionAdapter authMechGssapiCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism("GSSAPI", LdapLdapsServersPage.this.authMechGssapiCheckbox.getSelection());
        }
    };
    private SelectionAdapter authMechCramMd5CheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism("CRAM-MD5", LdapLdapsServersPage.this.authMechCramMd5Checkbox.getSelection());
        }
    };
    private SelectionAdapter authMechDigestMd5CheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism("DIGEST-MD5", LdapLdapsServersPage.this.authMechDigestMd5Checkbox.getSelection());
        }
    };
    private SelectionAdapter authMechGssSpnegoCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism("GSS-SPNEGO", LdapLdapsServersPage.this.authMechGssSpnegoCheckbox.getSelection());
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.authMechGssSpnegoText, LdapLdapsServersPage.this.authMechGssSpnegoCheckbox.getSelection());
        }
    };
    private ModifyListener authMechGssSpnegoTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LdapLdapsServersPage.this.setNtlmMechProviderSupportedAuthenticationMechanism("GSS-SPNEGO", LdapLdapsServersPage.this.authMechGssSpnegoText.getText());
        }
    };
    private SelectionAdapter authMechNtlmCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableSupportedAuthenticationMechanism("NTLM", LdapLdapsServersPage.this.authMechNtlmCheckbox.getSelection());
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.authMechNtlmText, LdapLdapsServersPage.this.authMechNtlmCheckbox.getSelection());
        }
    };
    private ModifyListener authMechNtlmTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LdapLdapsServersPage.this.setNtlmMechProviderSupportedAuthenticationMechanism("NTLM", LdapLdapsServersPage.this.authMechNtlmText.getText());
        }
    };
    private ModifyListener maxTimeLimitTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LdapLdapsServersPage.this.getLdapServerBean().setLdapServerMaxTimeLimit(Integer.parseInt(LdapLdapsServersPage.this.maxTimeLimitText.getText()));
        }
    };
    private ModifyListener maxSizeLimitTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LdapLdapsServersPage.this.getLdapServerBean().setLdapServerMaxSizeLimit(Integer.parseInt(LdapLdapsServersPage.this.maxSizeLimitText.getText()));
        }
    };
    private SelectionAdapter enableTlsCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.setEnableTls(LdapLdapsServersPage.this.enableTlsCheckbox.getSelection());
        }
    };
    private SelectionAdapter enableServerSidePasswordHashingCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (LdapLdapsServersPage.this.enableServerSidePasswordHashingCheckbox.getSelection()) {
                LdapLdapsServersPage.this.enableHashingPasswordInterceptor();
            } else {
                LdapLdapsServersPage.this.disableHashingPasswordInterceptor();
            }
            LdapLdapsServersPage.this.setEnabled((Control)LdapLdapsServersPage.this.hashingMethodComboViewer.getCombo(), LdapLdapsServersPage.this.enableServerSidePasswordHashingCheckbox.getSelection());
        }
    };
    private ISelectionChangedListener hashingMethodComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            LdapLdapsServersPage.this.updateHashingMethod();
        }
    };
    private ModifyListener keystoreFileTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String keystoreFile = LdapLdapsServersPage.this.keystoreFileText.getText();
            if (!"".equals(keystoreFile)) {
                LdapLdapsServersPage.this.getLdapServerBean().setLdapServerKeystoreFile(keystoreFile);
            } else {
                LdapLdapsServersPage.this.getLdapServerBean().setLdapServerKeystoreFile(null);
            }
        }
    };
    private SelectionListener keystoreFileBrowseButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            FileDialog fileDialog = new FileDialog(LdapLdapsServersPage.this.keystoreFileBrowseButton.getShell(), 4096);
            File file = new File(LdapLdapsServersPage.this.keystoreFileText.getText());
            if (file.isFile()) {
                fileDialog.setFilterPath(file.getParent());
                fileDialog.setFileName(file.getName());
            } else if (file.isDirectory()) {
                fileDialog.setFilterPath(file.getPath());
            } else {
                fileDialog.setFilterPath(null);
            }
            String returnedFileName = fileDialog.open();
            if (returnedFileName != null) {
                LdapLdapsServersPage.this.keystoreFileText.setText(returnedFileName);
                LdapLdapsServersPage.this.setEditorDirty();
            }
        }
    };
    private ModifyListener keystorePasswordTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String keystorePassword = LdapLdapsServersPage.this.keystorePasswordText.getText();
            if (!"".equals(keystorePassword)) {
                LdapLdapsServersPage.this.getLdapServerBean().setLdapServerCertificatePassword(keystorePassword);
            } else {
                LdapLdapsServersPage.this.getLdapServerBean().setLdapServerCertificatePassword(null);
            }
        }
    };
    private SelectionListener showPasswordCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (LdapLdapsServersPage.this.showPasswordCheckbox.getSelection()) {
                LdapLdapsServersPage.this.keystorePasswordText.setEchoChar('\u0000');
            } else {
                LdapLdapsServersPage.this.keystorePasswordText.setEchoChar('\u2022');
            }
        }
    };
    private ISelectionChangedListener cipherSuitesTableViewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection selection = (StructuredSelection)LdapLdapsServersPage.this.cipherSuitesTableViewer.getSelection();
            LdapLdapsServersPage.this.editCipherSuiteButton.setEnabled(!selection.isEmpty());
            LdapLdapsServersPage.this.deleteCipherSuiteButton.setEnabled(!selection.isEmpty());
        }
    };
    private IDoubleClickListener cipherSuitesTableViewerDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            LdapLdapsServersPage.this.editCipherSuiteAction();
        }
    };
    private SelectionListener addCipherSuiteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            InputDialog dialog = new InputDialog(LdapLdapsServersPage.this.editCipherSuiteButton.getShell(), Messages.getString("LdapLdapsServersPage.Add"), Messages.getString("LdapLdapsServersPage.CipherSuite"), null, null);
            if (dialog.open() == 0) {
                String newCipherSuite = dialog.getValue();
                LdapLdapsServersPage.this.getLdapServerBean().addEnabledCipherSuites(new String[]{newCipherSuite});
                LdapLdapsServersPage.this.cipherSuitesTableViewer.refresh();
                LdapLdapsServersPage.this.cipherSuitesTableViewer.setSelection((ISelection)new StructuredSelection((Object)newCipherSuite));
                LdapLdapsServersPage.this.setEditorDirty();
            }
        }
    };
    private SelectionListener editCipherSuiteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            LdapLdapsServersPage.this.editCipherSuiteAction();
        }
    };
    private SelectionListener deleteCipherSuiteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            String selectedCipherSuite = LdapLdapsServersPage.this.getSelectedSslStartTlsCipherSuite();
            if (selectedCipherSuite != null) {
                LdapLdapsServersPage.this.getLdapServerBean().getEnabledCipherSuites().remove(selectedCipherSuite);
                LdapLdapsServersPage.this.cipherSuitesTableViewer.refresh();
                LdapLdapsServersPage.this.setEditorDirty();
            }
        }
    };
    private ModifyListener replicationPingerSleepTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LdapLdapsServersPage.this.getLdapServerBean().setReplPingerSleep(Integer.parseInt(LdapLdapsServersPage.this.replicationPingerSleepText.getText()));
        }
    };
    private ModifyListener diskSynchronizationDelayTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LdapLdapsServersPage.this.getDirectoryServiceBean().setDsSyncPeriodMillis(Long.parseLong(LdapLdapsServersPage.this.diskSynchronizationDelayText.getText()));
        }
    };

    public LdapLdapsServersPage(ServerConfigurationEditor editor) {
        super(editor, ID, TITLE);
    }

    @Override
    protected void createFormContent(Composite parent, FormToolkit toolkit) {
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        twl.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)twl);
        Composite leftComposite = toolkit.createComposite(parent);
        leftComposite.setLayout((Layout)new GridLayout());
        TableWrapData leftCompositeTableWrapData = new TableWrapData(128, 16);
        leftCompositeTableWrapData.grabHorizontal = true;
        leftComposite.setLayoutData((Object)leftCompositeTableWrapData);
        Composite rightComposite = toolkit.createComposite(parent);
        rightComposite.setLayout((Layout)new GridLayout());
        TableWrapData rightCompositeTableWrapData = new TableWrapData(128, 16);
        rightCompositeTableWrapData.grabHorizontal = true;
        rightComposite.setLayoutData((Object)rightCompositeTableWrapData);
        this.createLdapServerSection(toolkit, leftComposite);
        this.createLimitsSection(toolkit, leftComposite);
        this.createSslStartTlsKeystoreSection(toolkit, leftComposite);
        this.createSslStartTlsCipherSuitesSection(toolkit, leftComposite);
        this.createAdvancedSection(toolkit, leftComposite);
        this.createSupportedAuthenticationMechanismsSection(toolkit, rightComposite);
        this.createSaslSettingsSection(toolkit, rightComposite);
        this.refreshUI();
    }

    private void createLdapServerSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("LdapLdapsServersPage.LdapLdapsServers"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        this.enableLdapCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.EnableLdapServer"), 32);
        this.enableLdapCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, gridLayout.numColumns, 1));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.Port"));
        this.ldapPortText = this.createPortText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, "10389");
        this.enableLdapsCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.EnableLdapsServer"), 32);
        this.enableLdapsCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, gridLayout.numColumns, 1));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.Port"));
        this.ldapsPortText = this.createPortText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, "10636");
    }

    private void createLimitsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("LdapLdapsServersPage.Limits"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(2, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.MaxTimeLimit"));
        this.maxTimeLimitText = this.createIntegerText(toolkit, composite);
        this.maxTimeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.MaxSizeLimit"));
        this.maxSizeLimitText = this.createIntegerText(toolkit, composite);
        this.maxSizeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createSslStartTlsKeystoreSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("LdapLdapsServersPage.SslStartTlsKeystore"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(3, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.Keystore"));
        this.keystoreFileText = toolkit.createText(composite, "");
        this.setGridDataWithDefaultWidth((Control)this.keystoreFileText, new GridData(4, 0x1000000, true, false));
        this.keystoreFileBrowseButton = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.Browse"), 8);
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.Password"));
        this.keystorePasswordText = toolkit.createText(composite, "");
        this.keystorePasswordText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.keystorePasswordText.setEchoChar('\u2022');
        toolkit.createLabel(composite, "");
        this.showPasswordCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.ShowPassword"), 32);
        this.showPasswordCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.showPasswordCheckbox.setSelection(false);
    }

    private void createSslStartTlsCipherSuitesSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 290);
        section.setText(Messages.getString("LdapLdapsServersPage.SslStartTlsCipherSuites"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(2, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        this.cipherSuitesTableViewer = new TableViewer(composite);
        this.cipherSuitesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData cipherSuitesTableViewerGridData = new GridData(4, 0x1000000, true, false, 1, 3);
        cipherSuitesTableViewerGridData.heightHint = 60;
        this.cipherSuitesTableViewer.getControl().setLayoutData((Object)cipherSuitesTableViewerGridData);
        this.addCipherSuiteButton = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.Add"), 8);
        this.addCipherSuiteButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.editCipherSuiteButton = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.Edit"), 8);
        this.editCipherSuiteButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.editCipherSuiteButton.setEnabled(false);
        this.deleteCipherSuiteButton = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.Delete"), 8);
        this.deleteCipherSuiteButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deleteCipherSuiteButton.setEnabled(false);
    }

    private void createAdvancedSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 290);
        section.setText(Messages.getString("LdapLdapsServersPage.Advanced"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(2, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        this.enableTlsCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.EnableTls"), 32);
        this.enableTlsCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.enableServerSidePasswordHashingCheckbox = toolkit.createButton(composite, Messages.getString("LdapLdapsServersPage.EnableServerSidePasswordHashing"), 32);
        this.enableServerSidePasswordHashingCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        Composite hashingMethodComposite = toolkit.createComposite(composite);
        hashingMethodComposite.setLayout((Layout)new GridLayout(3, false));
        hashingMethodComposite.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(hashingMethodComposite, "   ");
        toolkit.createLabel(hashingMethodComposite, Messages.getString("LdapLdapsServersPage.HashingMethod"));
        Combo hashingMethodCombo = new Combo(hashingMethodComposite, 12);
        hashingMethodCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.adapt((Composite)hashingMethodCombo);
        this.hashingMethodComboViewer = new ComboViewer(hashingMethodCombo);
        this.hashingMethodComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.hashingMethodComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof LdapSecurityConstants) {
                    LdapSecurityConstants hashingMethod = (LdapSecurityConstants)element;
                    switch (hashingMethod) {
                        case HASH_METHOD_SHA: {
                            return "SHA";
                        }
                        case HASH_METHOD_SSHA: {
                            return "SSHA";
                        }
                        case HASH_METHOD_MD5: {
                            return "MD5";
                        }
                        case HASH_METHOD_SMD5: {
                            return "SMD5";
                        }
                        case HASH_METHOD_CRYPT: {
                            return "CRYPT";
                        }
                        case HASH_METHOD_SHA256: {
                            return "SHA-256";
                        }
                        case HASH_METHOD_SSHA256: {
                            return "SSHA-256";
                        }
                        case HASH_METHOD_SHA384: {
                            return "SHA-384";
                        }
                        case HASH_METHOD_SSHA384: {
                            return "SSHA-384";
                        }
                        case HASH_METHOD_SHA512: {
                            return "SHA-512";
                        }
                        case HASH_METHOD_SSHA512: {
                            return "SSHA-512";
                        }
                    }
                }
                return super.getText(element);
            }
        });
        Object[] hashingMethods = new Object[]{LdapSecurityConstants.HASH_METHOD_SHA, LdapSecurityConstants.HASH_METHOD_SSHA, LdapSecurityConstants.HASH_METHOD_MD5, LdapSecurityConstants.HASH_METHOD_SMD5, LdapSecurityConstants.HASH_METHOD_CRYPT, LdapSecurityConstants.HASH_METHOD_SHA256, LdapSecurityConstants.HASH_METHOD_SSHA256, LdapSecurityConstants.HASH_METHOD_SHA384, LdapSecurityConstants.HASH_METHOD_SSHA384, LdapSecurityConstants.HASH_METHOD_SHA512, LdapSecurityConstants.HASH_METHOD_SSHA512};
        this.hashingMethodComboViewer.setInput((Object)hashingMethods);
        this.setSelection((Viewer)this.hashingMethodComboViewer, LdapSecurityConstants.HASH_METHOD_SSHA);
        toolkit.createLabel(hashingMethodComposite, "   ");
        Label defaultLabel = this.createDefaultValueLabel(toolkit, hashingMethodComposite, "SSHA");
        defaultLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(composite, "Replication Pinger Sleep (sec):");
        this.replicationPingerSleepText = this.createIntegerText(toolkit, composite);
        this.replicationPingerSleepText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, "Disk Synchronization Delay (ms):");
        this.diskSynchronizationDelayText = this.createIntegerText(toolkit, composite);
        this.diskSynchronizationDelayText.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createSupportedAuthenticationMechanismsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("LdapLdapsServersPage.SupportedAuthenticationMechanisms"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(2, true));
        section.setClient((Control)composite);
        this.authMechSimpleCheckbox = toolkit.createButton(composite, "Simple", 32);
        this.authMechSimpleCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.authMechGssapiCheckbox = toolkit.createButton(composite, "GSSAPI", 32);
        this.authMechGssapiCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.authMechCramMd5Checkbox = toolkit.createButton(composite, "CRAM-MD5", 32);
        this.authMechCramMd5Checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.authMechDigestMd5Checkbox = toolkit.createButton(composite, "DIGEST-MD5", 32);
        this.authMechDigestMd5Checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.authMechNtlmCheckbox = toolkit.createButton(composite, "NTLM", 32);
        this.authMechNtlmCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(composite, "");
        Composite authMechNtlmComposite = toolkit.createComposite(composite);
        authMechNtlmComposite.setLayout((Layout)new GridLayout(3, false));
        toolkit.createLabel(authMechNtlmComposite, "   ");
        toolkit.createLabel(authMechNtlmComposite, Messages.getString("LdapLdapsServersPage.Provider"));
        this.authMechNtlmText = toolkit.createText(authMechNtlmComposite, "");
        this.authMechNtlmText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        authMechNtlmComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.authMechGssSpnegoCheckbox = toolkit.createButton(composite, "GSS-SPNEGO", 32);
        this.authMechGssSpnegoCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(composite, "");
        Composite authMechGssSpnegoComposite = toolkit.createComposite(composite);
        authMechGssSpnegoComposite.setLayout((Layout)new GridLayout(3, false));
        toolkit.createLabel(authMechGssSpnegoComposite, "   ");
        toolkit.createLabel(authMechGssSpnegoComposite, Messages.getString("LdapLdapsServersPage.Provider"));
        this.authMechGssSpnegoText = toolkit.createText(authMechGssSpnegoComposite, "");
        this.authMechGssSpnegoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        authMechGssSpnegoComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
    }

    private void createSaslSettingsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("LdapLdapsServersPage.SaslSettings"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(2, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.SaslHost"));
        this.saslHostText = toolkit.createText(composite, "");
        this.setGridDataWithDefaultWidth((Control)this.saslHostText, new GridData(4, 0, true, false));
        Label defaultSaslHostLabel = this.createDefaultValueLabel(toolkit, composite, "ldap.example.com");
        defaultSaslHostLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.SaslPrincipal"));
        this.saslPrincipalText = toolkit.createText(composite, "");
        this.setGridDataWithDefaultWidth((Control)this.saslPrincipalText, new GridData(4, 0, true, false));
        Label defaultSaslPrincipalLabel = this.createDefaultValueLabel(toolkit, composite, "ldap/ldap.example.com@EXAMPLE.COM");
        defaultSaslPrincipalLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(composite, Messages.getString("LdapLdapsServersPage.SearchBaseDn"));
        this.saslSearchBaseDnText = toolkit.createText(composite, "");
        this.setGridDataWithDefaultWidth((Control)this.saslSearchBaseDnText, new GridData(4, 0, true, false));
        Label defaultSaslSearchBaseDnLabel = this.createDefaultValueLabel(toolkit, composite, "ou=users,dc=example,dc=com");
        defaultSaslSearchBaseDnLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
    }

    private void addListeners() {
        this.addDirtyListener(this.enableLdapCheckbox);
        this.addSelectionListener(this.enableLdapCheckbox, (SelectionListener)this.enableLdapCheckboxListener);
        this.addDirtyListener(this.ldapPortText);
        this.addModifyListener(this.ldapPortText, this.ldapPortTextListener);
        this.addDirtyListener(this.enableLdapsCheckbox);
        this.addSelectionListener(this.enableLdapsCheckbox, (SelectionListener)this.enableLdapsCheckboxListener);
        this.addDirtyListener(this.ldapsPortText);
        this.addModifyListener(this.ldapsPortText, this.ldapsPortTextListener);
        this.addDirtyListener(this.authMechSimpleCheckbox);
        this.addSelectionListener(this.authMechSimpleCheckbox, (SelectionListener)this.authMechSimpleCheckboxListener);
        this.addDirtyListener(this.authMechGssapiCheckbox);
        this.addSelectionListener(this.authMechGssapiCheckbox, (SelectionListener)this.authMechGssapiCheckboxListener);
        this.addDirtyListener(this.authMechCramMd5Checkbox);
        this.addSelectionListener(this.authMechCramMd5Checkbox, (SelectionListener)this.authMechCramMd5CheckboxListener);
        this.addDirtyListener(this.authMechDigestMd5Checkbox);
        this.addSelectionListener(this.authMechDigestMd5Checkbox, (SelectionListener)this.authMechDigestMd5CheckboxListener);
        this.addDirtyListener(this.authMechNtlmCheckbox);
        this.addSelectionListener(this.authMechNtlmCheckbox, (SelectionListener)this.authMechNtlmCheckboxListener);
        this.addDirtyListener(this.authMechNtlmText);
        this.addModifyListener(this.authMechNtlmText, this.authMechNtlmTextListener);
        this.addDirtyListener(this.authMechGssSpnegoCheckbox);
        this.addSelectionListener(this.authMechGssSpnegoCheckbox, (SelectionListener)this.authMechGssSpnegoCheckboxListener);
        this.addModifyListener(this.authMechGssSpnegoText, this.authMechGssSpnegoTextListener);
        this.addDirtyListener(this.authMechGssSpnegoText);
        this.addModifyListener(this.authMechGssSpnegoText, this.authMechGssSpnegoTextListener);
        this.addDirtyListener(this.keystoreFileText);
        this.addModifyListener(this.keystoreFileText, this.keystoreFileTextListener);
        this.addSelectionListener(this.keystoreFileBrowseButton, this.keystoreFileBrowseButtonSelectionListener);
        this.addDirtyListener(this.keystorePasswordText);
        this.addModifyListener(this.keystorePasswordText, this.keystorePasswordTextListener);
        this.addSelectionListener(this.showPasswordCheckbox, this.showPasswordCheckboxSelectionListener);
        this.addDirtyListener(this.saslHostText);
        this.addModifyListener(this.saslHostText, this.saslHostTextListener);
        this.addDirtyListener(this.saslPrincipalText);
        this.addModifyListener(this.saslPrincipalText, this.saslPrincipalTextListener);
        this.addDirtyListener(this.saslSearchBaseDnText);
        this.addModifyListener(this.saslSearchBaseDnText, this.saslSearchBaseDnTextListener);
        this.addDirtyListener(this.maxTimeLimitText);
        this.addModifyListener(this.maxTimeLimitText, this.maxTimeLimitTextListener);
        this.addDirtyListener(this.maxSizeLimitText);
        this.addModifyListener(this.maxSizeLimitText, this.maxSizeLimitTextListener);
        this.addDirtyListener(this.enableTlsCheckbox);
        this.addSelectionListener(this.enableTlsCheckbox, (SelectionListener)this.enableTlsCheckboxListener);
        this.addDirtyListener(this.enableServerSidePasswordHashingCheckbox);
        this.addSelectionListener(this.enableServerSidePasswordHashingCheckbox, (SelectionListener)this.enableServerSidePasswordHashingCheckboxListener);
        this.addDirtyListener((Viewer)this.hashingMethodComboViewer);
        this.addSelectionChangedListener((Viewer)this.hashingMethodComboViewer, this.hashingMethodComboViewerListener);
        this.addSelectionChangedListener((Viewer)this.cipherSuitesTableViewer, this.cipherSuitesTableViewerSelectionChangedListener);
        this.addDoubleClickListener((StructuredViewer)this.cipherSuitesTableViewer, this.cipherSuitesTableViewerDoubleClickListener);
        this.addSelectionListener(this.addCipherSuiteButton, this.addCipherSuiteButtonListener);
        this.addSelectionListener(this.editCipherSuiteButton, this.editCipherSuiteButtonListener);
        this.addSelectionListener(this.deleteCipherSuiteButton, this.deleteCipherSuiteButtonListener);
        this.addDirtyListener(this.replicationPingerSleepText);
        this.addModifyListener(this.replicationPingerSleepText, this.replicationPingerSleepTextListener);
        this.addDirtyListener(this.diskSynchronizationDelayText);
        this.addModifyListener(this.diskSynchronizationDelayText, this.diskSynchronizationDelayTextListener);
    }

    private void removeListeners() {
        this.removeDirtyListener(this.enableLdapCheckbox);
        this.removeSelectionListener(this.enableLdapCheckbox, (SelectionListener)this.enableLdapCheckboxListener);
        this.removeDirtyListener(this.ldapPortText);
        this.removeModifyListener(this.ldapPortText, this.ldapPortTextListener);
        this.removeDirtyListener(this.enableLdapsCheckbox);
        this.removeSelectionListener(this.enableLdapsCheckbox, (SelectionListener)this.enableLdapsCheckboxListener);
        this.removeDirtyListener(this.ldapsPortText);
        this.removeModifyListener(this.ldapsPortText, this.ldapsPortTextListener);
        this.removeDirtyListener(this.authMechSimpleCheckbox);
        this.removeSelectionListener(this.authMechSimpleCheckbox, (SelectionListener)this.authMechSimpleCheckboxListener);
        this.removeDirtyListener(this.authMechCramMd5Checkbox);
        this.removeSelectionListener(this.authMechCramMd5Checkbox, (SelectionListener)this.authMechCramMd5CheckboxListener);
        this.removeDirtyListener(this.authMechDigestMd5Checkbox);
        this.removeSelectionListener(this.authMechDigestMd5Checkbox, (SelectionListener)this.authMechDigestMd5CheckboxListener);
        this.removeDirtyListener(this.authMechGssapiCheckbox);
        this.removeSelectionListener(this.authMechGssapiCheckbox, (SelectionListener)this.authMechGssapiCheckboxListener);
        this.removeDirtyListener(this.authMechNtlmCheckbox);
        this.removeSelectionListener(this.authMechNtlmCheckbox, (SelectionListener)this.authMechNtlmCheckboxListener);
        this.removeModifyListener(this.authMechNtlmText, this.authMechNtlmTextListener);
        this.removeDirtyListener(this.authMechNtlmText);
        this.removeModifyListener(this.authMechNtlmText, this.authMechNtlmTextListener);
        this.removeDirtyListener(this.authMechGssSpnegoCheckbox);
        this.removeSelectionListener(this.authMechGssSpnegoCheckbox, (SelectionListener)this.authMechGssSpnegoCheckboxListener);
        this.removeModifyListener(this.authMechGssSpnegoText, this.authMechGssSpnegoTextListener);
        this.removeDirtyListener(this.authMechGssSpnegoText);
        this.removeModifyListener(this.authMechGssSpnegoText, this.authMechGssSpnegoTextListener);
        this.removeDirtyListener(this.keystoreFileText);
        this.removeModifyListener(this.keystoreFileText, this.keystoreFileTextListener);
        this.removeSelectionListener(this.keystoreFileBrowseButton, this.keystoreFileBrowseButtonSelectionListener);
        this.removeDirtyListener(this.keystorePasswordText);
        this.removeModifyListener(this.keystorePasswordText, this.keystorePasswordTextListener);
        this.removeSelectionListener(this.showPasswordCheckbox, this.showPasswordCheckboxSelectionListener);
        this.removeDirtyListener(this.saslHostText);
        this.removeModifyListener(this.saslHostText, this.saslHostTextListener);
        this.removeDirtyListener(this.saslPrincipalText);
        this.removeModifyListener(this.saslPrincipalText, this.saslPrincipalTextListener);
        this.removeDirtyListener(this.saslSearchBaseDnText);
        this.removeModifyListener(this.saslSearchBaseDnText, this.saslSearchBaseDnTextListener);
        this.removeDirtyListener(this.maxTimeLimitText);
        this.removeModifyListener(this.maxTimeLimitText, this.maxTimeLimitTextListener);
        this.removeDirtyListener(this.maxSizeLimitText);
        this.removeModifyListener(this.maxSizeLimitText, this.maxSizeLimitTextListener);
        this.removeDirtyListener(this.enableServerSidePasswordHashingCheckbox);
        this.removeSelectionListener(this.enableServerSidePasswordHashingCheckbox, (SelectionListener)this.enableServerSidePasswordHashingCheckboxListener);
        this.removeDirtyListener((Viewer)this.hashingMethodComboViewer);
        this.removeSelectionChangedListener((Viewer)this.hashingMethodComboViewer, this.hashingMethodComboViewerListener);
        this.removeSelectionChangedListener((Viewer)this.cipherSuitesTableViewer, this.cipherSuitesTableViewerSelectionChangedListener);
        this.removeDoubleClickListener((StructuredViewer)this.cipherSuitesTableViewer, this.cipherSuitesTableViewerDoubleClickListener);
        this.removeSelectionListener(this.addCipherSuiteButton, this.addCipherSuiteButtonListener);
        this.removeSelectionListener(this.editCipherSuiteButton, this.editCipherSuiteButtonListener);
        this.removeSelectionListener(this.deleteCipherSuiteButton, this.deleteCipherSuiteButtonListener);
        this.removeDirtyListener(this.replicationPingerSleepText);
        this.removeModifyListener(this.replicationPingerSleepText, this.replicationPingerSleepTextListener);
        this.removeDirtyListener(this.diskSynchronizationDelayText);
        this.removeModifyListener(this.diskSynchronizationDelayText, this.diskSynchronizationDelayTextListener);
    }

    @Override
    protected void refreshUI() {
        this.removeListeners();
        TransportBean ldapServerTransportBean = this.getLdapServerTransportBean();
        this.setSelection(this.enableLdapCheckbox, ldapServerTransportBean.isEnabled());
        this.setEnabled((Control)this.ldapPortText, this.enableLdapCheckbox.getSelection());
        this.setText(this.ldapPortText, ldapServerTransportBean.getSystemPort() + "");
        TransportBean ldapsServerTransportBean = this.getLdapsServerTransportBean();
        this.setSelection(this.enableLdapsCheckbox, ldapsServerTransportBean.isEnabled());
        this.setEnabled((Control)this.enableLdapsCheckbox, this.enableLdapsCheckbox.getSelection());
        this.setText(this.ldapsPortText, ldapsServerTransportBean.getSystemPort() + "");
        LdapServerBean ldapServerBean = this.getLdapServerBean();
        this.setText(this.saslHostText, ldapServerBean.getLdapServerSaslHost());
        this.setText(this.saslPrincipalText, ldapServerBean.getLdapServerSaslPrincipal());
        this.setText(this.saslSearchBaseDnText, ldapServerBean.getSearchBaseDn().toString());
        this.setText(this.keystoreFileText, ldapServerBean.getLdapServerKeystoreFile());
        this.setText(this.keystorePasswordText, ldapServerBean.getLdapServerCertificatePassword());
        List saslMechHandlers = ldapServerBean.getSaslMechHandlers();
        this.uncheckAllSupportedAuthenticationMechanisms();
        for (SaslMechHandlerBean saslMechHandler : saslMechHandlers) {
            if (SASL_MECHANISMS_SIMPLE.equalsIgnoreCase(saslMechHandler.getSaslMechName())) {
                this.setSelection(this.authMechSimpleCheckbox, saslMechHandler.isEnabled());
                continue;
            }
            if ("GSSAPI".equalsIgnoreCase(saslMechHandler.getSaslMechName())) {
                this.setSelection(this.authMechGssapiCheckbox, saslMechHandler.isEnabled());
                continue;
            }
            if ("CRAM-MD5".equalsIgnoreCase(saslMechHandler.getSaslMechName())) {
                this.setSelection(this.authMechCramMd5Checkbox, saslMechHandler.isEnabled());
                continue;
            }
            if ("DIGEST-MD5".equalsIgnoreCase(saslMechHandler.getSaslMechName())) {
                this.setSelection(this.authMechDigestMd5Checkbox, saslMechHandler.isEnabled());
                continue;
            }
            if ("GSS-SPNEGO".equalsIgnoreCase(saslMechHandler.getSaslMechName())) {
                this.setSelection(this.authMechGssSpnegoCheckbox, saslMechHandler.isEnabled());
                this.setEnabled((Control)this.authMechGssSpnegoText, saslMechHandler.isEnabled());
                this.setText(this.authMechGssSpnegoText, saslMechHandler.getNtlmMechProvider());
                continue;
            }
            if (!"NTLM".equalsIgnoreCase(saslMechHandler.getSaslMechName())) continue;
            this.setSelection(this.authMechNtlmCheckbox, saslMechHandler.isEnabled());
            this.setEnabled((Control)this.authMechNtlmText, saslMechHandler.isEnabled());
            this.setText(this.authMechNtlmText, saslMechHandler.getNtlmMechProvider());
        }
        this.setText(this.maxTimeLimitText, "" + ldapServerBean.getLdapServerMaxTimeLimit());
        this.setText(this.maxSizeLimitText, "" + ldapServerBean.getLdapServerMaxSizeLimit());
        this.setSelection(this.enableTlsCheckbox, this.getTlsExtendedOpHandlerBean().isEnabled());
        InterceptorBean hashingMethodInterceptor = this.getHashingPasswordInterceptor();
        if (hashingMethodInterceptor == null) {
            this.setSelection(this.enableServerSidePasswordHashingCheckbox, false);
            this.setEnabled((Control)this.hashingMethodComboViewer.getCombo(), this.enableServerSidePasswordHashingCheckbox.getSelection());
            this.setSelection((Viewer)this.hashingMethodComboViewer, LdapSecurityConstants.HASH_METHOD_SSHA);
        } else {
            LdapSecurityConstants hashingMethod = this.getHashingMethodFromInterceptor(hashingMethodInterceptor);
            if (hashingMethod != null) {
                this.setSelection(this.enableServerSidePasswordHashingCheckbox, hashingMethodInterceptor.isEnabled());
                this.setEnabled((Control)this.hashingMethodComboViewer.getCombo(), this.enableServerSidePasswordHashingCheckbox.getSelection());
                this.setSelection((Viewer)this.hashingMethodComboViewer, hashingMethod);
            } else {
                this.setSelection(this.enableServerSidePasswordHashingCheckbox, false);
                this.setEnabled((Control)this.hashingMethodComboViewer.getCombo(), this.enableServerSidePasswordHashingCheckbox.getSelection());
                this.setSelection((Viewer)this.hashingMethodComboViewer, LdapSecurityConstants.HASH_METHOD_SSHA);
            }
        }
        this.cipherSuitesTableViewer.setInput((Object)ldapServerBean.getEnabledCipherSuites());
        this.cipherSuitesTableViewer.refresh();
        this.setText(this.replicationPingerSleepText, "" + ldapServerBean.getReplPingerSleep());
        this.setText(this.diskSynchronizationDelayText, "" + this.getDirectoryServiceBean().getDsSyncPeriodMillis());
        this.addListeners();
    }

    private void uncheckAllSupportedAuthenticationMechanisms() {
        this.setSelection(this.authMechSimpleCheckbox, false);
        this.setSelection(this.authMechCramMd5Checkbox, false);
        this.setSelection(this.authMechDigestMd5Checkbox, false);
        this.setSelection(this.authMechGssapiCheckbox, false);
        this.setSelection(this.authMechNtlmCheckbox, false);
        this.setEnabled((Control)this.authMechNtlmText, false);
        this.setSelection(this.authMechGssSpnegoCheckbox, false);
        this.setEnabled((Control)this.authMechGssSpnegoText, false);
    }

    private void setEnableSupportedAuthenticationMechanism(String mechanismName, boolean enabled) {
        List saslMechHandlers = this.getLdapServerBean().getSaslMechHandlers();
        for (SaslMechHandlerBean saslMechHandler : saslMechHandlers) {
            if (!mechanismName.equalsIgnoreCase(saslMechHandler.getSaslMechName())) continue;
            saslMechHandler.setEnabled(enabled);
            return;
        }
    }

    private void setNtlmMechProviderSupportedAuthenticationMechanism(String mechanismName, String ntlmMechProvider) {
        List saslMechHandlers = this.getLdapServerBean().getSaslMechHandlers();
        for (SaslMechHandlerBean saslMechHandler : saslMechHandlers) {
            if (!mechanismName.equalsIgnoreCase(saslMechHandler.getSaslMechName())) continue;
            saslMechHandler.setNtlmMechProvider(ntlmMechProvider);
            return;
        }
    }

    private LdapServerBean getLdapServerBean() {
        return LdapLdapsServersPage.getLdapServerBean(this.getDirectoryServiceBean());
    }

    public static LdapServerBean getLdapServerBean(DirectoryServiceBean directoryServiceBean) {
        LdapServerBean ldapServerBean = directoryServiceBean.getLdapServerBean();
        if (ldapServerBean == null) {
            ldapServerBean = new LdapServerBean();
            directoryServiceBean.addServers(new ServerBean[]{ldapServerBean});
        }
        return ldapServerBean;
    }

    private TransportBean getLdapServerTransportBean() {
        return this.getTransportBean(TRANSPORT_ID_LDAP);
    }

    public static TransportBean getLdapServerTransportBean(DirectoryServiceBean directoryServiceBean) {
        return LdapLdapsServersPage.getTransportBean(directoryServiceBean, TRANSPORT_ID_LDAP);
    }

    private TransportBean getLdapsServerTransportBean() {
        return this.getTransportBean(TRANSPORT_ID_LDAPS);
    }

    public static TransportBean getLdapsServerTransportBean(DirectoryServiceBean directoryServiceBean) {
        return LdapLdapsServersPage.getTransportBean(directoryServiceBean, TRANSPORT_ID_LDAPS);
    }

    private TransportBean getTransportBean(String id) {
        return LdapLdapsServersPage.getTransportBean(this.getDirectoryServiceBean(), id);
    }

    public static TransportBean getTransportBean(DirectoryServiceBean directoryServiceBean, String id) {
        LdapServerBean ldapServerBean = LdapLdapsServersPage.getLdapServerBean(directoryServiceBean);
        TransportBean transportBean = null;
        TransportBean[] ldapServerTransportBeans = ldapServerBean.getTransports();
        if (ldapServerTransportBeans != null) {
            for (TransportBean ldapServerTransportBean : ldapServerTransportBeans) {
                if (!id.equals(ldapServerTransportBean.getTransportId())) continue;
                transportBean = ldapServerTransportBean;
                break;
            }
        }
        if (transportBean == null) {
            transportBean = new TransportBean();
            ldapServerBean.addTransports(new TransportBean[]{transportBean});
            transportBean.setTransportId(id);
            transportBean.setTransportAddress(DEFAULT_ADDRESS);
            if (TRANSPORT_ID_LDAP.equals(id)) {
                transportBean.setSystemPort(10389);
            } else if (TRANSPORT_ID_LDAPS.equals(id)) {
                transportBean.setSystemPort(10636);
            }
            if (TRANSPORT_ID_LDAPS.equals(id)) {
                transportBean.setTransportEnableSSL(true);
            }
        }
        return transportBean;
    }

    private void setEnableTls(boolean enabled) {
        this.getTlsExtendedOpHandlerBean().setEnabled(enabled);
    }

    private ExtendedOpHandlerBean getTlsExtendedOpHandlerBean() {
        LdapServerBean ldapServerBean = this.getLdapServerBean();
        List extendedOpHandlers = ldapServerBean.getExtendedOps();
        for (ExtendedOpHandlerBean extendedOpHandlerBean : extendedOpHandlers) {
            if (!START_TLS_HANDLER_ID.equalsIgnoreCase(extendedOpHandlerBean.getExtendedOpId())) continue;
            return extendedOpHandlerBean;
        }
        ExtendedOpHandlerBean extendedOpHandlerBean = new ExtendedOpHandlerBean();
        extendedOpHandlerBean.setExtendedOpId(START_TLS_HANDLER_ID);
        extendedOpHandlerBean.setExtendedOpHandlerClass(START_TLS_HANDLER_CLASS);
        extendedOpHandlerBean.setEnabled(false);
        extendedOpHandlers.add(extendedOpHandlerBean);
        return extendedOpHandlerBean;
    }

    private InterceptorBean getHashingPasswordInterceptor() {
        for (InterceptorBean interceptor : this.getDirectoryServiceBean().getInterceptors()) {
            if (!HASHING_PASSWORD_INTERCEPTOR_ID.equalsIgnoreCase(interceptor.getInterceptorId())) continue;
            return interceptor;
        }
        return null;
    }

    private LdapSecurityConstants getHashingMethodFromInterceptor(InterceptorBean interceptor) {
        if (interceptor != null) {
            String interceptorClassName = interceptor.getInterceptorClassName();
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA)) {
                return LdapSecurityConstants.HASH_METHOD_SHA;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA)) {
                return LdapSecurityConstants.HASH_METHOD_SSHA;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_MD5)) {
                return LdapSecurityConstants.HASH_METHOD_MD5;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SMD5)) {
                return LdapSecurityConstants.HASH_METHOD_SMD5;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_CRYPT)) {
                return LdapSecurityConstants.HASH_METHOD_SMD5;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA256)) {
                return LdapSecurityConstants.HASH_METHOD_SHA256;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA256)) {
                return LdapSecurityConstants.HASH_METHOD_SSHA256;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA384)) {
                return LdapSecurityConstants.HASH_METHOD_SHA384;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA384)) {
                return LdapSecurityConstants.HASH_METHOD_SSHA384;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA512)) {
                return LdapSecurityConstants.HASH_METHOD_SHA512;
            }
            if (interceptorClassName.equalsIgnoreCase(HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA512)) {
                return LdapSecurityConstants.HASH_METHOD_SSHA512;
            }
        }
        return null;
    }

    private int getKeyDerivationInterceptorOrder() {
        for (InterceptorBean interceptor : this.getDirectoryServiceBean().getInterceptors()) {
            if (!"keyDerivationInterceptor".equalsIgnoreCase(interceptor.getInterceptorId())) continue;
            return interceptor.getInterceptorOrder();
        }
        return 0;
    }

    private void enableHashingPasswordInterceptor() {
        InterceptorBean hashingPasswordInterceptor = this.getHashingPasswordInterceptor();
        if (hashingPasswordInterceptor == null) {
            hashingPasswordInterceptor = this.createHashingPasswordInterceptor();
        }
        hashingPasswordInterceptor.setEnabled(true);
    }

    private InterceptorBean createHashingPasswordInterceptor() {
        InterceptorBean hashingPasswordInterceptor = new InterceptorBean();
        hashingPasswordInterceptor.setInterceptorId(HASHING_PASSWORD_INTERCEPTOR_ID);
        hashingPasswordInterceptor.setInterceptorClassName(this.getFqcnForHashingMethod(this.getSelectedHashingMethod()));
        int keyDerivationInterceptorOrder = this.getKeyDerivationInterceptorOrder();
        hashingPasswordInterceptor.setInterceptorOrder(keyDerivationInterceptorOrder + 1);
        for (InterceptorBean interceptor : this.getDirectoryServiceBean().getInterceptors()) {
            if (interceptor.getInterceptorOrder() <= keyDerivationInterceptorOrder) continue;
            interceptor.setInterceptorOrder(interceptor.getInterceptorOrder() + 1);
        }
        this.getDirectoryServiceBean().addInterceptors(new InterceptorBean[]{hashingPasswordInterceptor});
        return hashingPasswordInterceptor;
    }

    private void disableHashingPasswordInterceptor() {
        InterceptorBean hashingPasswordInterceptor = this.getHashingPasswordInterceptor();
        if (hashingPasswordInterceptor != null) {
            hashingPasswordInterceptor.setEnabled(false);
        }
    }

    private void updateHashingMethod() {
        InterceptorBean hashingPasswordInterceptor = this.getHashingPasswordInterceptor();
        if (hashingPasswordInterceptor != null) {
            hashingPasswordInterceptor.setInterceptorClassName(this.getFqcnForHashingMethod(this.getSelectedHashingMethod()));
        }
    }

    private String getFqcnForHashingMethod(LdapSecurityConstants hashingMethod) {
        switch (hashingMethod) {
            case HASH_METHOD_MD5: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_MD5;
            }
            case HASH_METHOD_SMD5: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SMD5;
            }
            case HASH_METHOD_CRYPT: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_CRYPT;
            }
            case HASH_METHOD_SHA256: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA256;
            }
            case HASH_METHOD_SSHA256: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA256;
            }
            case HASH_METHOD_SHA384: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA384;
            }
            case HASH_METHOD_SSHA384: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA384;
            }
            case HASH_METHOD_SHA512: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA512;
            }
            case HASH_METHOD_SSHA512: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA512;
            }
            case HASH_METHOD_SHA: {
                return HASHING_PASSWORD_INTERCEPTOR_FQCN_SHA;
            }
        }
        return HASHING_PASSWORD_INTERCEPTOR_FQCN_SSHA;
    }

    private LdapSecurityConstants getSelectedHashingMethod() {
        StructuredSelection selection = (StructuredSelection)this.hashingMethodComboViewer.getSelection();
        if (!selection.isEmpty()) {
            return (LdapSecurityConstants)selection.getFirstElement();
        }
        return null;
    }

    private String getSelectedSslStartTlsCipherSuite() {
        StructuredSelection selection = (StructuredSelection)this.cipherSuitesTableViewer.getSelection();
        if (!selection.isEmpty()) {
            return (String)selection.getFirstElement();
        }
        return null;
    }

    private void editCipherSuiteAction() {
        InputDialog dialog;
        String selectedCipherSuite = this.getSelectedSslStartTlsCipherSuite();
        if (selectedCipherSuite != null && (dialog = new InputDialog(this.editCipherSuiteButton.getShell(), Messages.getString("LdapLdapsServersPage.Edit"), Messages.getString("LdapLdapsServersPage.CipherSuite"), selectedCipherSuite, null)).open() == 0) {
            String newCipherSuite = dialog.getValue();
            this.getLdapServerBean().getEnabledCipherSuites().remove(selectedCipherSuite);
            this.getLdapServerBean().addEnabledCipherSuites(new String[]{newCipherSuite});
            this.cipherSuitesTableViewer.refresh();
            this.cipherSuitesTableViewer.setSelection((ISelection)new StructuredSelection((Object)newCipherSuite));
            this.setEditorDirty();
        }
    }
}

