/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.editor;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.config.beans.ChangePasswordServerBean;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.server.config.beans.InterceptorBean;
import org.apache.directory.server.config.beans.KdcServerBean;
import org.apache.directory.server.config.beans.ServerBean;
import org.apache.directory.server.config.beans.TransportBean;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.studio.apacheds.configuration.v2.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditorPage;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class KerberosServerPage
extends ServerConfigurationEditorPage {
    public static final String ID = KerberosServerPage.class.getName();
    private static final String TITLE = Messages.getString("KerberosServerPage.KerberosServer");
    private static final EncryptionType[] SUPPORTED_ENCRYPTION_TYPES = new EncryptionType[]{EncryptionType.DES_CBC_MD5, EncryptionType.DES3_CBC_SHA1_KD, EncryptionType.AES128_CTS_HMAC_SHA1_96, EncryptionType.AES256_CTS_HMAC_SHA1_96, EncryptionType.RC4_HMAC};
    private Button enableKerberosCheckbox;
    private Text kerberosPortText;
    private Button enableChangePasswordCheckbox;
    private Text changePasswordPortText;
    private Text primaryKdcRealmText;
    private Text kdcSearchBaseDnText;
    private CheckboxTableViewer encryptionTypesTableViewer;
    private Button verifyBodyChecksumCheckbox;
    private Button allowEmptyAddressesCheckbox;
    private Button allowForwardableAddressesCheckbox;
    private Button requirePreAuthByEncryptedTimestampCheckbox;
    private Button allowPostdatedTicketsCheckbox;
    private Button allowRenewableTicketsCheckbox;
    private Text maximumRenewableLifetimeText;
    private Text maximumTicketLifetimeText;
    private Text allowableClockSkewText;
    private SelectionAdapter enableKerberosCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            KerberosServerPage.enableKerberosServer(KerberosServerPage.this.getDirectoryServiceBean(), KerberosServerPage.this.enableKerberosCheckbox.getSelection());
            KerberosServerPage.this.setEnabled((Control)KerberosServerPage.this.kerberosPortText, KerberosServerPage.this.enableKerberosCheckbox.getSelection());
        }
    };
    private ModifyListener kerberosPortTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            KerberosServerPage.this.getKdcServerTransportBean().setSystemPort(Integer.parseInt(KerberosServerPage.this.kerberosPortText.getText()));
        }
    };
    private SelectionAdapter enableChangePasswordCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            KerberosServerPage.this.getChangePasswordServerBean().setEnabled(KerberosServerPage.this.enableChangePasswordCheckbox.getSelection());
            KerberosServerPage.this.setEnabled((Control)KerberosServerPage.this.changePasswordPortText, KerberosServerPage.this.enableChangePasswordCheckbox.getSelection());
        }
    };
    private ModifyListener changePasswordPortTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            KerberosServerPage.this.getChangePasswordServerTransportBean().setSystemPort(Integer.parseInt(KerberosServerPage.this.changePasswordPortText.getText()));
        }
    };
    private ModifyListener primaryKdcRealmTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            KerberosServerPage.this.getKdcServerBean().setKrbPrimaryRealm(KerberosServerPage.this.primaryKdcRealmText.getText());
        }
    };
    private ModifyListener kdcSearchBaseDnTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String searchBaseDnValue = KerberosServerPage.this.kdcSearchBaseDnText.getText();
            try {
                Dn searchBaseDn = new Dn(new String[]{searchBaseDnValue});
                KerberosServerPage.this.getKdcServerBean().setSearchBaseDn(searchBaseDn);
            }
            catch (LdapInvalidDnException ldapInvalidDnException) {
                // empty catch block
            }
        }
    };
    private ICheckStateListener encryptionTypesTableViewerListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object[] selectedEncryptionTypeObjects;
            if (KerberosServerPage.this.getKdcServerBean().getKrbEncryptionTypes().size() == 1 && !event.getChecked()) {
                CommonUIUtils.openErrorDialog((String)Messages.getString("KerberosServerPage.AtLeastOneEncryptionTypeMustBeSelected"));
                KerberosServerPage.this.encryptionTypesTableViewer.setChecked(event.getElement(), !event.getChecked());
                return;
            }
            KerberosServerPage.this.setEditorDirty();
            KerberosServerPage.this.getKdcServerBean().getKrbEncryptionTypes().clear();
            for (Object encryptionTypeObject : selectedEncryptionTypeObjects = KerberosServerPage.this.encryptionTypesTableViewer.getCheckedElements()) {
                if (!(encryptionTypeObject instanceof EncryptionType)) continue;
                EncryptionType encryptionType = (EncryptionType)encryptionTypeObject;
                KerberosServerPage.this.getKdcServerBean().addKrbEncryptionTypes(new String[]{encryptionType.getName()});
            }
        }
    };
    private SelectionAdapter verifyBodyChecksumCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            KerberosServerPage.this.getKdcServerBean().setKrbBodyChecksumVerified(KerberosServerPage.this.verifyBodyChecksumCheckbox.getSelection());
        }
    };
    private SelectionAdapter allowEmptyAddressesCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            KerberosServerPage.this.getKdcServerBean().setKrbEmptyAddressesAllowed(KerberosServerPage.this.allowEmptyAddressesCheckbox.getSelection());
        }
    };
    private SelectionAdapter allowForwardableAddressesCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            KerberosServerPage.this.getKdcServerBean().setKrbForwardableAllowed(KerberosServerPage.this.allowForwardableAddressesCheckbox.getSelection());
        }
    };
    private SelectionAdapter requirePreAuthByEncryptedTimestampCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            KerberosServerPage.this.getKdcServerBean().setKrbPaEncTimestampRequired(KerberosServerPage.this.requirePreAuthByEncryptedTimestampCheckbox.getSelection());
        }
    };
    private SelectionAdapter allowPostdatedTicketsCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            KerberosServerPage.this.getKdcServerBean().setKrbPostdatedAllowed(KerberosServerPage.this.allowPostdatedTicketsCheckbox.getSelection());
        }
    };
    private SelectionAdapter allowRenewableTicketsCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            KerberosServerPage.this.getKdcServerBean().setKrbRenewableAllowed(KerberosServerPage.this.allowRenewableTicketsCheckbox.getSelection());
        }
    };
    private ModifyListener maximumRenewableLifetimeTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            KerberosServerPage.this.getKdcServerBean().setKrbMaximumRenewableLifetime(Long.parseLong(KerberosServerPage.this.maximumRenewableLifetimeText.getText()));
        }
    };
    private ModifyListener maximumTicketLifetimeTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            KerberosServerPage.this.getKdcServerBean().setKrbMaximumTicketLifetime(Long.parseLong(KerberosServerPage.this.maximumTicketLifetimeText.getText()));
        }
    };
    private ModifyListener allowableClockSkewTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            KerberosServerPage.this.getKdcServerBean().setKrbAllowableClockSkew(Long.parseLong(KerberosServerPage.this.allowableClockSkewText.getText()));
        }
    };

    public KerberosServerPage(ServerConfigurationEditor editor) {
        super(editor, ID, TITLE);
    }

    @Override
    protected void createFormContent(Composite parent, FormToolkit toolkit) {
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        parent.setLayout((Layout)twl);
        Composite leftComposite = toolkit.createComposite(parent);
        leftComposite.setLayout((Layout)new GridLayout());
        TableWrapData leftCompositeTableWrapData = new TableWrapData(128, 16);
        leftCompositeTableWrapData.grabHorizontal = true;
        leftComposite.setLayoutData((Object)leftCompositeTableWrapData);
        Composite rightComposite = toolkit.createComposite(parent);
        rightComposite.setLayout((Layout)new GridLayout());
        TableWrapData rightCompositeTableWrapData = new TableWrapData(128, 16);
        rightCompositeTableWrapData.grabHorizontal = true;
        rightComposite.setLayoutData((Object)rightCompositeTableWrapData);
        this.createKerberosServerSection(toolkit, leftComposite);
        this.createKerberosSettingsSection(toolkit, leftComposite);
        this.createTicketSettingsSection(toolkit, rightComposite);
        this.refreshUI();
    }

    private void createKerberosServerSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("KerberosServerPage.KerberosServer"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        this.enableKerberosCheckbox = toolkit.createButton(composite, Messages.getString("KerberosServerPage.EnableKerberosServer"), 32);
        this.enableKerberosCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, gridLayout.numColumns, 1));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("KerberosServerPage.Port"));
        this.kerberosPortText = this.createPortText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, "60088");
        this.enableChangePasswordCheckbox = toolkit.createButton(composite, Messages.getString("KerberosServerPage.EnableKerberosChangePassword"), 32);
        this.enableChangePasswordCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, gridLayout.numColumns, 1));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("KerberosServerPage.Port"));
        this.changePasswordPortText = this.createPortText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, "60464");
    }

    private void createKerberosSettingsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("KerberosServerPage.KerberosSettings"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(2, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, Messages.getString("KerberosServerPage.PrimaryKdcRealm"));
        this.primaryKdcRealmText = toolkit.createText(composite, "");
        this.setGridDataWithDefaultWidth((Control)this.primaryKdcRealmText, new GridData(4, 0, true, false));
        Label defaultSaslPrincipalLabel = this.createDefaultValueLabel(toolkit, composite, "EXAMPLE.COM");
        defaultSaslPrincipalLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(composite, Messages.getString("KerberosServerPage.SearchBaseDn"));
        this.kdcSearchBaseDnText = toolkit.createText(composite, "");
        this.setGridDataWithDefaultWidth((Control)this.kdcSearchBaseDnText, new GridData(4, 0, true, false));
        Label defaultSaslSearchBaseDnLabel = this.createDefaultValueLabel(toolkit, composite, "ou=users,dc=example,dc=com");
        defaultSaslSearchBaseDnLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        Label encryptionTypesLabel = toolkit.createLabel(composite, Messages.getString("KerberosServerPage.EncryptionTypes"));
        encryptionTypesLabel.setLayoutData((Object)new GridData(1, 128, false, false));
        this.encryptionTypesTableViewer = new CheckboxTableViewer(new Table(composite, 2080));
        this.encryptionTypesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.encryptionTypesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EncryptionType) {
                    EncryptionType encryptionType = (EncryptionType)element;
                    return encryptionType.getName().toUpperCase();
                }
                return super.getText(element);
            }
        });
        this.encryptionTypesTableViewer.setInput((Object)SUPPORTED_ENCRYPTION_TYPES);
        GridData encryptionTypesTableViewerGridData = new GridData(4, 0, true, false);
        encryptionTypesTableViewerGridData.heightHint = 60;
        this.encryptionTypesTableViewer.getControl().setLayoutData((Object)encryptionTypesTableViewerGridData);
    }

    private void createTicketSettingsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("KerberosServerPage.TicketSettings"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.verifyBodyChecksumCheckbox = toolkit.createButton(composite, Messages.getString("KerberosServerPage.VerifyBodyChecksum"), 32);
        this.verifyBodyChecksumCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, layout.numColumns, 1));
        this.allowEmptyAddressesCheckbox = toolkit.createButton(composite, Messages.getString("KerberosServerPage.AllowEmptyAddresses"), 32);
        this.allowEmptyAddressesCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, layout.numColumns, 1));
        this.allowForwardableAddressesCheckbox = toolkit.createButton(composite, Messages.getString("KerberosServerPage.AllowForwadableAddresses"), 32);
        this.allowForwardableAddressesCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, layout.numColumns, 1));
        this.requirePreAuthByEncryptedTimestampCheckbox = toolkit.createButton(composite, Messages.getString("KerberosServerPage.RequirePreAuthentication"), 32);
        this.requirePreAuthByEncryptedTimestampCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, layout.numColumns, 1));
        this.allowPostdatedTicketsCheckbox = toolkit.createButton(composite, Messages.getString("KerberosServerPage.AllowPostdatedTickets"), 32);
        this.allowPostdatedTicketsCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, layout.numColumns, 1));
        this.allowRenewableTicketsCheckbox = toolkit.createButton(composite, Messages.getString("KerberosServerPage.AllowRenewableTickets"), 32);
        this.allowRenewableTicketsCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, layout.numColumns, 1));
        toolkit.createLabel(composite, Messages.getString("KerberosServerPage.MaxRenewableLifetime"));
        this.maximumRenewableLifetimeText = this.createIntegerText(toolkit, composite);
        this.setGridDataWithDefaultWidth((Control)this.maximumRenewableLifetimeText, new GridData(4, 0, true, false));
        toolkit.createLabel(composite, Messages.getString("KerberosServerPage.MaxTicketLifetime"));
        this.maximumTicketLifetimeText = this.createIntegerText(toolkit, composite);
        this.setGridDataWithDefaultWidth((Control)this.maximumTicketLifetimeText, new GridData(4, 0, true, false));
        toolkit.createLabel(composite, Messages.getString("KerberosServerPage.AllowableClockSkew"));
        this.allowableClockSkewText = this.createIntegerText(toolkit, composite);
        this.setGridDataWithDefaultWidth((Control)this.allowableClockSkewText, new GridData(4, 0, true, false));
    }

    @Override
    protected void refreshUI() {
        this.removeListeners();
        KdcServerBean kdcServerBean = this.getKdcServerBean();
        this.setSelection(this.enableKerberosCheckbox, kdcServerBean.isEnabled());
        this.setEnabled((Control)this.kerberosPortText, this.enableKerberosCheckbox.getSelection());
        this.setText(this.kerberosPortText, "" + this.getKdcServerTransportBean().getSystemPort());
        ChangePasswordServerBean changePasswordServerBean = this.getChangePasswordServerBean();
        this.setSelection(this.enableChangePasswordCheckbox, changePasswordServerBean.isEnabled());
        this.setEnabled((Control)this.changePasswordPortText, this.enableChangePasswordCheckbox.getSelection());
        this.setText(this.changePasswordPortText, "" + this.getChangePasswordServerTransportBean().getSystemPort());
        this.setText(this.primaryKdcRealmText, kdcServerBean.getKrbPrimaryRealm());
        this.setText(this.kdcSearchBaseDnText, kdcServerBean.getSearchBaseDn().toString());
        List encryptionTypesNames = kdcServerBean.getKrbEncryptionTypes();
        ArrayList<EncryptionType> encryptionTypes = new ArrayList<EncryptionType>();
        for (String encryptionTypesName : encryptionTypesNames) {
            EncryptionType encryptionType = EncryptionType.getByName((String)encryptionTypesName);
            if (EncryptionType.UNKNOWN.equals((Object)encryptionType)) continue;
            encryptionTypes.add(encryptionType);
        }
        this.encryptionTypesTableViewer.setCheckedElements(encryptionTypes.toArray());
        this.setSelection(this.verifyBodyChecksumCheckbox, kdcServerBean.isKrbBodyChecksumVerified());
        this.setSelection(this.allowEmptyAddressesCheckbox, kdcServerBean.isKrbEmptyAddressesAllowed());
        this.setSelection(this.allowForwardableAddressesCheckbox, kdcServerBean.isKrbForwardableAllowed());
        this.setSelection(this.requirePreAuthByEncryptedTimestampCheckbox, kdcServerBean.isKrbPaEncTimestampRequired());
        this.setSelection(this.allowPostdatedTicketsCheckbox, kdcServerBean.isKrbPostdatedAllowed());
        this.setSelection(this.allowRenewableTicketsCheckbox, kdcServerBean.isKrbRenewableAllowed());
        this.setText(this.maximumRenewableLifetimeText, kdcServerBean.getKrbMaximumRenewableLifetime() + "");
        this.setText(this.maximumTicketLifetimeText, kdcServerBean.getKrbMaximumTicketLifetime() + "");
        this.setText(this.allowableClockSkewText, kdcServerBean.getKrbAllowableClockSkew() + "");
        this.addListeners();
    }

    private void addListeners() {
        this.addDirtyListener(this.enableKerberosCheckbox);
        this.addSelectionListener(this.enableKerberosCheckbox, (SelectionListener)this.enableKerberosCheckboxListener);
        this.addDirtyListener(this.kerberosPortText);
        this.addModifyListener(this.kerberosPortText, this.kerberosPortTextListener);
        this.addDirtyListener(this.enableChangePasswordCheckbox);
        this.addSelectionListener(this.enableChangePasswordCheckbox, (SelectionListener)this.enableChangePasswordCheckboxListener);
        this.addDirtyListener(this.changePasswordPortText);
        this.addModifyListener(this.changePasswordPortText, this.changePasswordPortTextListener);
        this.addDirtyListener(this.primaryKdcRealmText);
        this.addModifyListener(this.primaryKdcRealmText, this.primaryKdcRealmTextListener);
        this.addDirtyListener(this.kdcSearchBaseDnText);
        this.addModifyListener(this.kdcSearchBaseDnText, this.kdcSearchBaseDnTextListener);
        this.encryptionTypesTableViewer.addCheckStateListener(this.encryptionTypesTableViewerListener);
        this.addDirtyListener(this.verifyBodyChecksumCheckbox);
        this.addSelectionListener(this.verifyBodyChecksumCheckbox, (SelectionListener)this.verifyBodyChecksumCheckboxListener);
        this.addDirtyListener(this.allowEmptyAddressesCheckbox);
        this.addSelectionListener(this.allowEmptyAddressesCheckbox, (SelectionListener)this.allowEmptyAddressesCheckboxListener);
        this.addDirtyListener(this.allowForwardableAddressesCheckbox);
        this.addSelectionListener(this.allowForwardableAddressesCheckbox, (SelectionListener)this.allowForwardableAddressesCheckboxListener);
        this.addDirtyListener(this.requirePreAuthByEncryptedTimestampCheckbox);
        this.addSelectionListener(this.requirePreAuthByEncryptedTimestampCheckbox, (SelectionListener)this.requirePreAuthByEncryptedTimestampCheckboxListener);
        this.addDirtyListener(this.allowPostdatedTicketsCheckbox);
        this.addSelectionListener(this.allowPostdatedTicketsCheckbox, (SelectionListener)this.allowPostdatedTicketsCheckboxListener);
        this.addDirtyListener(this.allowRenewableTicketsCheckbox);
        this.addSelectionListener(this.allowRenewableTicketsCheckbox, (SelectionListener)this.allowRenewableTicketsCheckboxListener);
        this.addDirtyListener(this.maximumRenewableLifetimeText);
        this.addModifyListener(this.maximumRenewableLifetimeText, this.maximumRenewableLifetimeTextListener);
        this.addDirtyListener(this.maximumTicketLifetimeText);
        this.addModifyListener(this.maximumTicketLifetimeText, this.maximumTicketLifetimeTextListener);
        this.addDirtyListener(this.allowableClockSkewText);
        this.addModifyListener(this.allowableClockSkewText, this.allowableClockSkewTextListener);
    }

    private void removeListeners() {
        this.removeDirtyListener(this.enableKerberosCheckbox);
        this.removeSelectionListener(this.enableKerberosCheckbox, (SelectionListener)this.enableKerberosCheckboxListener);
        this.removeDirtyListener(this.kerberosPortText);
        this.removeModifyListener(this.kerberosPortText, this.kerberosPortTextListener);
        this.removeDirtyListener(this.enableChangePasswordCheckbox);
        this.removeSelectionListener(this.enableChangePasswordCheckbox, (SelectionListener)this.enableChangePasswordCheckboxListener);
        this.removeDirtyListener(this.changePasswordPortText);
        this.removeModifyListener(this.changePasswordPortText, this.changePasswordPortTextListener);
        this.removeDirtyListener(this.primaryKdcRealmText);
        this.removeModifyListener(this.primaryKdcRealmText, this.primaryKdcRealmTextListener);
        this.removeDirtyListener(this.kdcSearchBaseDnText);
        this.removeModifyListener(this.kdcSearchBaseDnText, this.kdcSearchBaseDnTextListener);
        this.encryptionTypesTableViewer.removeCheckStateListener(this.encryptionTypesTableViewerListener);
        this.removeDirtyListener(this.verifyBodyChecksumCheckbox);
        this.removeSelectionListener(this.verifyBodyChecksumCheckbox, (SelectionListener)this.verifyBodyChecksumCheckboxListener);
        this.removeDirtyListener(this.allowEmptyAddressesCheckbox);
        this.removeSelectionListener(this.allowEmptyAddressesCheckbox, (SelectionListener)this.allowEmptyAddressesCheckboxListener);
        this.removeDirtyListener(this.allowForwardableAddressesCheckbox);
        this.removeSelectionListener(this.allowForwardableAddressesCheckbox, (SelectionListener)this.allowForwardableAddressesCheckboxListener);
        this.removeDirtyListener(this.requirePreAuthByEncryptedTimestampCheckbox);
        this.removeSelectionListener(this.requirePreAuthByEncryptedTimestampCheckbox, (SelectionListener)this.requirePreAuthByEncryptedTimestampCheckboxListener);
        this.removeDirtyListener(this.allowPostdatedTicketsCheckbox);
        this.removeSelectionListener(this.allowPostdatedTicketsCheckbox, (SelectionListener)this.allowPostdatedTicketsCheckboxListener);
        this.removeDirtyListener(this.allowRenewableTicketsCheckbox);
        this.removeSelectionListener(this.allowRenewableTicketsCheckbox, (SelectionListener)this.allowRenewableTicketsCheckboxListener);
        this.removeDirtyListener(this.maximumRenewableLifetimeText);
        this.removeModifyListener(this.maximumRenewableLifetimeText, this.maximumRenewableLifetimeTextListener);
        this.removeDirtyListener(this.maximumTicketLifetimeText);
        this.removeModifyListener(this.maximumTicketLifetimeText, this.maximumTicketLifetimeTextListener);
        this.removeDirtyListener(this.allowableClockSkewText);
        this.removeModifyListener(this.allowableClockSkewText, this.allowableClockSkewTextListener);
    }

    private KdcServerBean getKdcServerBean() {
        return KerberosServerPage.getKdcServerBean(this.getDirectoryServiceBean());
    }

    public static KdcServerBean getKdcServerBean(DirectoryServiceBean directoryServiceBean) {
        KdcServerBean kdcServerBean = directoryServiceBean.getKdcServerBean();
        if (kdcServerBean == null) {
            kdcServerBean = new KdcServerBean();
            directoryServiceBean.addServers(new ServerBean[]{kdcServerBean});
        }
        return kdcServerBean;
    }

    public static void enableKerberosServer(DirectoryServiceBean directoryServiceBean, boolean enableKerberosServer) {
        KerberosServerPage.getKdcServerBean(directoryServiceBean).setEnabled(enableKerberosServer);
        InterceptorBean keyDerivationInterceptor = KerberosServerPage.getKeyDerivationInterceptor(directoryServiceBean);
        if (keyDerivationInterceptor != null) {
            keyDerivationInterceptor.setEnabled(enableKerberosServer);
        }
    }

    private ChangePasswordServerBean getChangePasswordServerBean() {
        return KerberosServerPage.getChangePasswordServerBean(this.getDirectoryServiceBean());
    }

    public static ChangePasswordServerBean getChangePasswordServerBean(DirectoryServiceBean directoryServiceBean) {
        ChangePasswordServerBean changePasswordServerBean = directoryServiceBean.getChangePasswordServerBean();
        if (changePasswordServerBean == null) {
            changePasswordServerBean = new ChangePasswordServerBean();
            directoryServiceBean.addServers(new ServerBean[]{changePasswordServerBean});
        }
        return changePasswordServerBean;
    }

    private TransportBean getKdcServerTransportBean() {
        KdcServerBean kdcServerBean = this.getKdcServerBean();
        TransportBean transportBean = null;
        TransportBean[] kdcServerTransportBeans = kdcServerBean.getTransports();
        if (kdcServerTransportBeans != null) {
            for (TransportBean kdcServerTransportBean : kdcServerTransportBeans) {
                if (!"tcp".equals(kdcServerTransportBean.getTransportId()) && !"udp".equals(kdcServerTransportBean.getTransportId())) continue;
                transportBean = kdcServerTransportBean;
                break;
            }
        }
        if (transportBean == null) {
            transportBean = new TransportBean();
            transportBean.setTransportId("tcp");
            kdcServerBean.addTransports(new TransportBean[]{transportBean});
        }
        return transportBean;
    }

    private TransportBean getChangePasswordServerTransportBean() {
        ChangePasswordServerBean changePasswordServerBean = this.getChangePasswordServerBean();
        TransportBean transportBean = null;
        TransportBean[] changePasswordServerTransportBeans = changePasswordServerBean.getTransports();
        if (changePasswordServerTransportBeans != null) {
            for (TransportBean changePasswordServerTransportBean : changePasswordServerTransportBeans) {
                if (!"tcp".equals(changePasswordServerTransportBean.getTransportId())) continue;
                transportBean = changePasswordServerTransportBean;
                break;
            }
        }
        if (transportBean == null) {
            transportBean = new TransportBean();
            transportBean.setTransportId("tcp");
            changePasswordServerBean.addTransports(new TransportBean[]{transportBean});
        }
        return transportBean;
    }

    private static InterceptorBean getKeyDerivationInterceptor(DirectoryServiceBean directoryServiceBean) {
        if (directoryServiceBean != null) {
            List interceptors = directoryServiceBean.getInterceptors();
            for (InterceptorBean interceptor : interceptors) {
                if (!"org.apache.directory.server.core.kerberos.KeyDerivationInterceptor".equalsIgnoreCase(interceptor.getInterceptorClassName())) continue;
                return interceptor;
            }
        }
        return null;
    }
}

