/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.AttributesInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeRootDSERunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;

public class InitializeAttributesRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IEntry[] entries;

    public InitializeAttributesRunnable(IEntry ... entries) {
        this.entries = entries;
    }

    public Connection[] getConnections() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (IEntry entry : this.entries) {
            if (entry == null) continue;
            connections.add(entry.getBrowserConnection().getConnection());
        }
        return connections.toArray(new Connection[0]);
    }

    public String getName() {
        return BrowserCoreMessages.jobs__init_entries_title_attonly;
    }

    public Object[] getLockedObjects() {
        ArrayList<IEntry> l = new ArrayList<IEntry>();
        l.addAll(Arrays.asList(this.entries));
        return l.toArray();
    }

    public String getErrorMessage() {
        return this.entries.length == 1 ? BrowserCoreMessages.jobs__init_entries_error_1 : BrowserCoreMessages.jobs__init_entries_error_n;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(" ", this.entries.length + 2);
        monitor.reportProgress(" ");
        for (int pi = 0; pi < this.entries.length && !monitor.isCanceled(); ++pi) {
            IEntry entry = this.entries[pi];
            if (entry == null) continue;
            monitor.setTaskName(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__init_entries_task, (Object[])new String[]{entry.getDn().getName()}));
            monitor.worked(1);
            if (entry.getBrowserConnection() == null) continue;
            InitializeAttributesRunnable.initializeAttributes(entry, monitor);
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        for (IEntry entry : this.entries) {
            if (entry == null || entry.getBrowserConnection() == null || !entry.isAttributesInitialized()) continue;
            if (entry.getBrowserConnection().getEntryFromCache(entry.getDn()) != null) {
                entry = entry.getBrowserConnection().getEntryFromCache(entry.getDn());
            }
            EventRegistry.fireEntryUpdated(new AttributesInitializedEvent(entry), this);
        }
    }

    public static synchronized void initializeAttributes(IEntry entry, StudioProgressMonitor monitor) {
        boolean initOperationalAttributes;
        String[] returningAttributes = null;
        LinkedHashSet<String> raSet = new LinkedHashSet<String>();
        raSet.add("*");
        boolean bl = initOperationalAttributes = entry.getBrowserConnection().isFetchOperationalAttributes() || entry.isInitOperationalAttributes();
        if (initOperationalAttributes) {
            if (entry.getBrowserConnection().getRootDSE().isFeatureSupported("1.3.6.1.4.1.4203.1.5.1")) {
                raSet.add("+");
            } else {
                Collection<AttributeType> opAtds = SchemaUtils.getOperationalAttributeDescriptions(entry.getBrowserConnection().getSchema());
                Collection<String> atdNames = SchemaUtils.getNames(opAtds);
                raSet.addAll(atdNames);
            }
        }
        if (entry.isReferral()) {
            raSet.add("ref");
        }
        returningAttributes = raSet.toArray(new String[raSet.size()]);
        InitializeAttributesRunnable.initializeAttributes(entry, returningAttributes, true, monitor);
    }

    public static synchronized void initializeAttributes(IEntry entry, String[] attributes, boolean clearAllAttributes, StudioProgressMonitor monitor) {
        monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__init_entries_progress_att, (Object[])new String[]{entry.getDn().getName()}));
        if (entry instanceof IRootDSE) {
            InitializeRootDSERunnable.loadRootDSE(entry.getBrowserConnection(), monitor);
        } else {
            IAttribute[] oldAttributes;
            Connection.AliasDereferencingMethod aliasesDereferencingMethod = entry.getBrowserConnection().getAliasesDereferencingMethod();
            if (entry.isAlias()) {
                aliasesDereferencingMethod = Connection.AliasDereferencingMethod.NEVER;
            }
            Connection.ReferralHandlingMethod referralsHandlingMethod = entry.getBrowserConnection().getReferralsHandlingMethod();
            if (clearAllAttributes && (oldAttributes = entry.getAttributes()) != null) {
                for (IAttribute oldAttribute : oldAttributes) {
                    entry.deleteAttribute(oldAttribute);
                }
            }
            Search search = new Search(null, entry.getBrowserConnection(), entry.getDn(), entry.isSubentry() ? "(|(objectClass=subentry)(objectClass=ldapSubentry))" : "(objectClass=*)", attributes, SearchScope.OBJECT, 0, 0, aliasesDereferencingMethod, referralsHandlingMethod, false, null);
            if (entry.isReferral()) {
                search.getControls().add(StudioControl.MANAGEDSAIT_CONTROL);
            }
            SearchRunnable.searchAndUpdateModel(entry.getBrowserConnection(), search, monitor);
            entry.setAttributesInitialized(true);
        }
    }
}

