/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifEnumeration;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeDeleteRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModDnRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifCommentLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecTypeLine;
import org.apache.directory.studio.ldifparser.parser.LdifParser;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImportLdifRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IBrowserConnection browserConnection;
    private File ldifFile;
    private File logFile;
    private boolean updateIfEntryExists;
    private boolean continueOnError;

    public ImportLdifRunnable(IBrowserConnection browserConnection, File ldifFile, File logFile, boolean updateIfEntryExists, boolean continueOnError) {
        this.browserConnection = browserConnection;
        this.ldifFile = ldifFile;
        this.logFile = logFile;
        this.continueOnError = continueOnError;
        this.updateIfEntryExists = updateIfEntryExists;
    }

    public ImportLdifRunnable(IBrowserConnection connection, File ldifFile, boolean updateIfEntryExists, boolean continueOnError) {
        this(connection, ldifFile, null, updateIfEntryExists, continueOnError);
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__import_ldif_name;
    }

    public Object[] getLockedObjects() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.ldifFile.toString()));
        return l.toArray();
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__import_ldif_error;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__import_ldif_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        try {
            BufferedReader ldifReader = new BufferedReader(new FileReader(this.ldifFile));
            LdifParser parser = new LdifParser();
            LdifEnumeration enumeration = parser.parse((Reader)ldifReader);
            Writer logWriter = this.logFile != null ? new BufferedWriter(new FileWriter(this.logFile)) : new Writer(){

                @Override
                public void close() throws IOException {
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                }
            };
            ImportLdifRunnable.importLdif(this.browserConnection, enumeration, logWriter, this.updateIfEntryExists, this.continueOnError, monitor);
            logWriter.close();
            ((Reader)ldifReader).close();
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        EventRegistry.fireEntryUpdated(new BulkModificationEvent(this.browserConnection), this);
    }

    static void importLdif(IBrowserConnection browserConnection, LdifEnumeration enumeration, Writer logWriter, boolean updateIfEntryExists, boolean continueOnError, StudioProgressMonitor monitor) {
        if (browserConnection == null) {
            return;
        }
        StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
        int importedCount = 0;
        int errorCount = 0;
        try {
            while (!monitor.isCanceled() && enumeration.hasNext()) {
                LdifContainer container = enumeration.next();
                if (container instanceof LdifRecord) {
                    block26: {
                        LdifRecord record = (LdifRecord)container;
                        try {
                            dummyMonitor.reset();
                            ImportLdifRunnable.importLdifRecord(browserConnection, record, updateIfEntryExists, dummyMonitor);
                            if (dummyMonitor.errorsReported()) {
                                ++errorCount;
                                ImportLdifRunnable.logModificationError(browserConnection, logWriter, record, dummyMonitor.getException(), monitor);
                                if (!continueOnError) {
                                    monitor.reportError(dummyMonitor.getException());
                                    return;
                                }
                            } else {
                                ++importedCount;
                                ImportLdifRunnable.logModification(browserConnection, logWriter, record, monitor);
                                Dn dn = new Dn(new String[]{record.getDnLine().getValueAsString()});
                                IEntry entry = browserConnection.getEntryFromCache(dn);
                                IEntry parentEntry = null;
                                for (Dn parentDn = dn.getParent(); parentEntry == null && parentDn != null; parentDn = parentDn.getParent()) {
                                    parentEntry = browserConnection.getEntryFromCache(parentDn);
                                }
                                if (record instanceof LdifChangeDeleteRecord) {
                                    if (entry != null) {
                                        entry.setAttributesInitialized(false);
                                        browserConnection.uncacheEntryRecursive(entry);
                                    }
                                    if (parentEntry != null) {
                                        parentEntry.setChildrenInitialized(false);
                                    }
                                } else if (record instanceof LdifChangeModDnRecord) {
                                    Dn newSuperiorDn;
                                    IEntry newSuperiorEntry;
                                    LdifChangeModDnRecord modDnRecord;
                                    if (entry != null) {
                                        entry.setAttributesInitialized(false);
                                        browserConnection.uncacheEntryRecursive(entry);
                                    }
                                    if (parentEntry != null) {
                                        parentEntry.setChildrenInitialized(false);
                                    }
                                    if ((modDnRecord = (LdifChangeModDnRecord)record).getNewsuperiorLine() != null && (newSuperiorEntry = browserConnection.getEntryFromCache(newSuperiorDn = new Dn(new String[]{modDnRecord.getNewsuperiorLine().getValueAsString()}))) != null) {
                                        newSuperiorEntry.setChildrenInitialized(false);
                                    }
                                } else if (record instanceof LdifChangeAddRecord || record instanceof LdifContentRecord) {
                                    if (entry != null) {
                                        entry.setAttributesInitialized(false);
                                    }
                                    if (parentEntry != null) {
                                        parentEntry.setChildrenInitialized(false);
                                        parentEntry.setHasChildrenHint(true);
                                    }
                                } else if (entry != null) {
                                    entry.setAttributesInitialized(false);
                                }
                            }
                        }
                        catch (Exception e) {
                            ImportLdifRunnable.logModificationError(browserConnection, logWriter, record, e, monitor);
                            ++errorCount;
                            if (continueOnError) break block26;
                            monitor.reportError(e);
                            return;
                        }
                    }
                    monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.ldif__imported_n_entries_m_errors, (Object[])new String[]{"" + importedCount, "" + errorCount}));
                    continue;
                }
                logWriter.write(container.toRawString());
            }
            if (errorCount > 0) {
                monitor.reportError(BrowserCoreMessages.bind((String)BrowserCoreMessages.ldif__n_errors_see_logfile, (Object[])new String[]{"" + errorCount}));
            }
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    static void importLdifRecord(IBrowserConnection browserConnection, LdifRecord record, boolean updateIfEntryExists, StudioProgressMonitor monitor) throws NamingException, LdapInvalidDnException {
        LdifChangeModDnRecord modDnRecord;
        if (!record.isValid()) {
            throw new NamingException(BrowserCoreMessages.bind((String)BrowserCoreMessages.model__invalid_record, (Object)record.getInvalidString()));
        }
        String dn = record.getDnLine().getValueAsString();
        if (record instanceof LdifContentRecord || record instanceof LdifChangeAddRecord) {
            DummyEntry dummyEntry;
            LdifAttrValLine[] attrVals;
            if (record instanceof LdifContentRecord) {
                LdifContentRecord attrValRecord = (LdifContentRecord)record;
                attrVals = attrValRecord.getAttrVals();
                try {
                    dummyEntry = ModelConverter.ldifContentRecordToEntry(attrValRecord, browserConnection);
                }
                catch (LdapInvalidDnException e) {
                    monitor.reportError((Exception)((Object)e));
                    return;
                }
            }
            LdifChangeAddRecord changeAddRecord = (LdifChangeAddRecord)record;
            attrVals = changeAddRecord.getAttrVals();
            try {
                dummyEntry = ModelConverter.ldifChangeAddRecordToEntry(changeAddRecord, browserConnection);
            }
            catch (LdapInvalidDnException e) {
                monitor.reportError((Exception)((Object)e));
                return;
            }
            BasicAttributes jndiAttributes = new BasicAttributes();
            for (LdifAttrValLine attrVal : attrVals) {
                String attributeName = attrVal.getUnfoldedAttributeDescription();
                Object realValue = attrVal.getValueAsObject();
                if (jndiAttributes.get(attributeName) != null) {
                    jndiAttributes.get(attributeName).add(realValue);
                    continue;
                }
                jndiAttributes.put(attributeName, realValue);
            }
            browserConnection.getConnection().getConnectionWrapper().createEntry(dn, (Attributes)jndiAttributes, ImportLdifRunnable.getControls(record), monitor, null);
            if (monitor.errorsReported() && updateIfEntryExists && monitor.getException() instanceof NameAlreadyBoundException) {
                monitor.reset();
                ModificationItem[] mis = ModelConverter.entryToReplaceModificationItems(dummyEntry);
                browserConnection.getConnection().getConnectionWrapper().modifyEntry(dn, mis, ImportLdifRunnable.getControls(record), monitor, null);
            }
        } else if (record instanceof LdifChangeDeleteRecord) {
            LdifChangeDeleteRecord changeDeleteRecord = (LdifChangeDeleteRecord)record;
            browserConnection.getConnection().getConnectionWrapper().deleteEntry(dn, ImportLdifRunnable.getControls((LdifRecord)changeDeleteRecord), monitor, null);
        } else if (record instanceof LdifChangeModifyRecord) {
            LdifChangeModifyRecord modifyRecord = (LdifChangeModifyRecord)record;
            LdifModSpec[] modSpecs = modifyRecord.getModSpecs();
            ModificationItem[] mis = new ModificationItem[modSpecs.length];
            for (int ii = 0; ii < modSpecs.length; ++ii) {
                LdifModSpecTypeLine modSpecType = modSpecs[ii].getModSpecType();
                LdifAttrValLine[] attrVals = modSpecs[ii].getAttrVals();
                BasicAttribute attribute = new BasicAttribute(modSpecType.getUnfoldedAttributeDescription());
                for (int x = 0; x < attrVals.length; ++x) {
                    attribute.add(attrVals[x].getValueAsObject());
                }
                if (modSpecType.isAdd()) {
                    mis[ii] = new ModificationItem(1, attribute);
                    continue;
                }
                if (modSpecType.isDelete()) {
                    mis[ii] = new ModificationItem(3, attribute);
                    continue;
                }
                if (!modSpecType.isReplace()) continue;
                mis[ii] = new ModificationItem(2, attribute);
            }
            browserConnection.getConnection().getConnectionWrapper().modifyEntry(dn, mis, ImportLdifRunnable.getControls((LdifRecord)modifyRecord), monitor, null);
        } else if (record instanceof LdifChangeModDnRecord && (modDnRecord = (LdifChangeModDnRecord)record).getNewrdnLine() != null && modDnRecord.getDeloldrdnLine() != null) {
            Dn newDn;
            String newRdn = modDnRecord.getNewrdnLine().getValueAsString();
            boolean deleteOldRdn = modDnRecord.getDeloldrdnLine().isDeleteOldRdn();
            if (modDnRecord.getNewsuperiorLine() != null) {
                newDn = new Dn(new String[]{newRdn, modDnRecord.getNewsuperiorLine().getValueAsString()});
            } else {
                Dn dnObject = new Dn(new String[]{dn});
                Dn parent = dnObject.getParent();
                newDn = new Dn(new String[]{newRdn, parent.getName()});
            }
            browserConnection.getConnection().getConnectionWrapper().renameEntry(dn, newDn.toString(), deleteOldRdn, ImportLdifRunnable.getControls((LdifRecord)modDnRecord), monitor, null);
        }
    }

    private static Control[] getControls(LdifRecord record) {
        Control[] controls = null;
        if (record instanceof LdifChangeRecord) {
            LdifChangeRecord changeRecord = (LdifChangeRecord)record;
            LdifControlLine[] controlLines = changeRecord.getControls();
            controls = new Control[controlLines.length];
            for (int i = 0; i < controlLines.length; ++i) {
                LdifControlLine line = controlLines[i];
                controls[i] = new BasicControl(line.getUnfoldedOid(), line.isCritical(), line.getControlValueAsBinary());
            }
        }
        return controls;
    }

    private static void logModificationError(IBrowserConnection browserConnection, Writer logWriter, LdifRecord record, Throwable exception, StudioProgressMonitor monitor) {
        try {
            LdifFormatParameters ldifFormatParameters = Utils.getLdifFormatParameters();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            String errorComment = "#!ERROR " + exception.getMessage();
            errorComment = errorComment.replaceAll("\r", " ");
            errorComment = errorComment.replaceAll("\n", " ");
            LdifCommentLine errorCommentLine = LdifCommentLine.create((String)errorComment);
            logWriter.write(LdifCommentLine.create((String)"#!RESULT ERROR").toFormattedString(LdifFormatParameters.DEFAULT));
            logWriter.write(LdifCommentLine.create((String)("#!CONNECTION ldap://" + browserConnection.getConnection().getHost() + ":" + browserConnection.getConnection().getPort())).toFormattedString(LdifFormatParameters.DEFAULT));
            logWriter.write(LdifCommentLine.create((String)("#!DATE " + df.format(new Date()))).toFormattedString(LdifFormatParameters.DEFAULT));
            logWriter.write(errorCommentLine.toFormattedString(LdifFormatParameters.DEFAULT));
            logWriter.write(record.toFormattedString(ldifFormatParameters));
        }
        catch (IOException ioe) {
            monitor.reportError(BrowserCoreMessages.model__error_logging_modification, (Exception)ioe);
        }
    }

    private static void logModification(IBrowserConnection browserConnection, Writer logWriter, LdifRecord record, StudioProgressMonitor monitor) {
        try {
            LdifFormatParameters ldifFormatParameters = Utils.getLdifFormatParameters();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            logWriter.write(LdifCommentLine.create((String)"#!RESULT OK").toFormattedString(ldifFormatParameters));
            logWriter.write(LdifCommentLine.create((String)("#!CONNECTION ldap://" + browserConnection.getConnection().getHost() + ":" + browserConnection.getConnection().getPort())).toFormattedString(ldifFormatParameters));
            logWriter.write(LdifCommentLine.create((String)("#!DATE " + df.format(new Date()))).toFormattedString(ldifFormatParameters));
            logWriter.write(record.toFormattedString(ldifFormatParameters));
        }
        catch (IOException ioe) {
            monitor.reportError(BrowserCoreMessages.model__error_logging_modification, (Exception)ioe);
        }
    }
}

