/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.constants.SaslQoP;
import org.apache.directory.api.ldap.model.constants.SaslSecurityStrength;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.io.ConnectionIOException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ConnectionIO {
    private static final String CONNECTIONS_TAG = "connections";
    private static final String CONNECTION_TAG = "connection";
    private static final String ID_TAG = "id";
    private static final String NAME_TAG = "name";
    private static final String HOST_TAG = "host";
    private static final String PORT_TAG = "port";
    private static final String ENCRYPTION_METHOD_TAG = "encryptionMethod";
    private static final String NETWORK_PROVIDER_TAG = "networkProvider";
    private static final String AUTH_METHOD_TAG = "authMethod";
    private static final String BIND_PRINCIPAL_TAG = "bindPrincipal";
    private static final String BIND_PASSWORD_TAG = "bindPassword";
    private static final String SASL_REALM_TAG = "saslRealm";
    private static final String SASL_QOP_TAG = "saslQop";
    private static final String SASL_SEC_STRENGTH_TAG = "saslSecStrenght";
    private static final String SASL_MUTUAL_AUTH_TAG = "saslMutualAuth";
    private static final String KRB5_CREDENTIALS_CONF_TAG = "krb5CredentialsConf";
    private static final String KRB5_CONFIG_TAG = "krb5Config";
    private static final String KRB5_CONFIG_FILE_TAG = "krb5ConfigFile";
    private static final String KRB5_REALM_TAG = "krb5Realm";
    private static final String KRB5_KDC_HOST_TAG = "krb5KdcHost";
    private static final String KRB5_KDC_PORT_TAG = "krb5KdcPort";
    private static final String READ_ONLY_TAG = "readOnly";
    private static final String EXTENDED_PROPERTIES_TAG = "extendedProperties";
    private static final String EXTENDED_PROPERTY_TAG = "extendedProperty";
    private static final String KEY_TAG = "key";
    private static final String VALUE_TAG = "value";
    private static final String CONNECTION_FOLDERS_TAG = "connectionFolders";
    private static final String CONNECTION_FOLDER_TAG = "connectionFolder";
    private static final String SUB_FOLDERS_TAG = "subFolders";
    private static final String SUB_FOLDER_TAG = "subFolder";

    public static Set<ConnectionParameter> load(InputStream stream) throws ConnectionIOException {
        HashSet<ConnectionParameter> connections = new HashSet<ConnectionParameter>();
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(stream);
        }
        catch (DocumentException e) {
            throw new ConnectionIOException(e.getMessage());
        }
        Element rootElement = document.getRootElement();
        if (!rootElement.getName().equals(CONNECTIONS_TAG)) {
            throw new ConnectionIOException("The file does not seem to be a valid Connections file.");
        }
        Iterator i = rootElement.elementIterator(CONNECTION_TAG);
        while (i.hasNext()) {
            Element connectionElement = (Element)i.next();
            connections.add(ConnectionIO.readConnection(connectionElement));
        }
        return connections;
    }

    private static ConnectionParameter readConnection(Element element) throws ConnectionIOException {
        Element extendedPropertiesElement;
        Attribute readOnly;
        Attribute krb5KdcPort;
        Attribute krb5KdcHost;
        Attribute krb5Realm;
        Attribute krb5ConfigFile;
        Attribute krb5Config;
        Attribute krb5CredentialsConf;
        Attribute saslMutualAuthAttribute;
        Attribute saslSecStrengthAttribute;
        Attribute saslQopAttribute;
        Attribute saslRealmAttribute;
        Attribute bindPasswordAttribute;
        Attribute bindPrincipalAttribute;
        Attribute networkProviderAttribute;
        Attribute encryptionMethodAttribute;
        Attribute portAttribute;
        Attribute hostAttribute;
        Attribute nameAttribute;
        ConnectionParameter connection = new ConnectionParameter();
        Attribute idAttribute = element.attribute(ID_TAG);
        if (idAttribute != null) {
            connection.setId(idAttribute.getValue());
        }
        if ((nameAttribute = element.attribute(NAME_TAG)) != null) {
            connection.setName(nameAttribute.getValue());
        }
        if ((hostAttribute = element.attribute(HOST_TAG)) != null) {
            connection.setHost(hostAttribute.getValue());
        }
        if ((portAttribute = element.attribute(PORT_TAG)) != null) {
            try {
                connection.setPort(Integer.parseInt(portAttribute.getValue()));
            }
            catch (NumberFormatException e) {
                throw new ConnectionIOException("Unable to parse 'Port' of connection '" + connection.getName() + "' as int value. Port value :" + portAttribute.getValue());
            }
        }
        if ((encryptionMethodAttribute = element.attribute(ENCRYPTION_METHOD_TAG)) != null) {
            try {
                connection.setEncryptionMethod(ConnectionParameter.EncryptionMethod.valueOf(encryptionMethodAttribute.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ConnectionIOException("Unable to parse 'Encryption Method' of connection '" + connection.getName() + "' as int value. Encryption Method value :" + encryptionMethodAttribute.getValue());
            }
        }
        if ((networkProviderAttribute = element.attribute(NETWORK_PROVIDER_TAG)) != null) {
            try {
                connection.setNetworkProvider(ConnectionParameter.NetworkProvider.valueOf(networkProviderAttribute.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ConnectionIOException("Unable to parse 'Network Provider' of connection '" + connection.getName() + "' as int value. Network Provider value :" + networkProviderAttribute.getValue());
            }
        } else {
            connection.setNetworkProvider(ConnectionCorePlugin.getDefault().getDefaultNetworkProvider());
        }
        Attribute authMethodAttribute = element.attribute(AUTH_METHOD_TAG);
        if (authMethodAttribute != null) {
            try {
                connection.setAuthMethod(ConnectionParameter.AuthenticationMethod.valueOf(authMethodAttribute.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ConnectionIOException("Unable to parse 'Authentication Method' of connection '" + connection.getName() + "' as int value. Authentication Method value :" + authMethodAttribute.getValue());
            }
        }
        if ((bindPrincipalAttribute = element.attribute(BIND_PRINCIPAL_TAG)) != null) {
            connection.setBindPrincipal(bindPrincipalAttribute.getValue());
        }
        if ((bindPasswordAttribute = element.attribute(BIND_PASSWORD_TAG)) != null) {
            connection.setBindPassword(bindPasswordAttribute.getValue());
        }
        if ((saslRealmAttribute = element.attribute(SASL_REALM_TAG)) != null) {
            connection.setSaslRealm(saslRealmAttribute.getValue());
        }
        if ((saslQopAttribute = element.attribute(SASL_QOP_TAG)) != null) {
            if ("AUTH_INT_PRIV".equals(saslQopAttribute.getValue())) {
                connection.setSaslQop(SaslQoP.AUTH_CONF);
            } else {
                try {
                    connection.setSaslQop(SaslQoP.valueOf((String)saslQopAttribute.getValue()));
                }
                catch (IllegalArgumentException e) {
                    throw new ConnectionIOException("Unable to parse 'SASL Quality of Protection' of connection '" + connection.getName() + "' as int value. SASL Quality of Protection value :" + saslQopAttribute.getValue());
                }
            }
        }
        if ((saslSecStrengthAttribute = element.attribute(SASL_SEC_STRENGTH_TAG)) != null) {
            try {
                connection.setSaslSecurityStrength(SaslSecurityStrength.valueOf((String)saslSecStrengthAttribute.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ConnectionIOException("Unable to parse 'SASL Security Strength' of connection '" + connection.getName() + "' as int value. SASL Security Strength value :" + saslSecStrengthAttribute.getValue());
            }
        }
        if ((saslMutualAuthAttribute = element.attribute(SASL_MUTUAL_AUTH_TAG)) != null) {
            connection.setSaslMutualAuthentication(Boolean.parseBoolean(saslMutualAuthAttribute.getValue()));
        }
        if ((krb5CredentialsConf = element.attribute(KRB5_CREDENTIALS_CONF_TAG)) != null) {
            try {
                connection.setKrb5CredentialConfiguration(ConnectionParameter.Krb5CredentialConfiguration.valueOf(krb5CredentialsConf.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ConnectionIOException("Unable to parse 'KRB5 Credentials Conf' of connection '" + connection.getName() + "' as int value. KRB5 Credentials Conf value :" + krb5CredentialsConf.getValue());
            }
        }
        if ((krb5Config = element.attribute(KRB5_CONFIG_TAG)) != null) {
            try {
                connection.setKrb5Configuration(ConnectionParameter.Krb5Configuration.valueOf(krb5Config.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ConnectionIOException("Unable to parse 'KRB5 Configuration' of connection '" + connection.getName() + "' as int value. KRB5 Configuration value :" + krb5Config.getValue());
            }
        }
        if ((krb5ConfigFile = element.attribute(KRB5_CONFIG_FILE_TAG)) != null) {
            connection.setKrb5ConfigurationFile(krb5ConfigFile.getValue());
        }
        if ((krb5Realm = element.attribute(KRB5_REALM_TAG)) != null) {
            connection.setKrb5Realm(krb5Realm.getValue());
        }
        if ((krb5KdcHost = element.attribute(KRB5_KDC_HOST_TAG)) != null) {
            connection.setKrb5KdcHost(krb5KdcHost.getValue());
        }
        if ((krb5KdcPort = element.attribute(KRB5_KDC_PORT_TAG)) != null) {
            try {
                connection.setKrb5KdcPort(Integer.valueOf(krb5KdcPort.getValue()));
            }
            catch (NumberFormatException e) {
                throw new ConnectionIOException("Unable to parse 'KRB5 KDC Port' of connection '" + connection.getName() + "' as int value. KRB5 KDC Port value :" + krb5KdcPort.getValue());
            }
        }
        if ((readOnly = element.attribute(READ_ONLY_TAG)) != null) {
            connection.setReadOnly(Boolean.parseBoolean(readOnly.getValue()));
        }
        if ((extendedPropertiesElement = element.element(EXTENDED_PROPERTIES_TAG)) != null) {
            Iterator i = extendedPropertiesElement.elementIterator(EXTENDED_PROPERTY_TAG);
            while (i.hasNext()) {
                Element extendedPropertyElement = (Element)i.next();
                Attribute keyAttribute = extendedPropertyElement.attribute(KEY_TAG);
                Attribute valueAttribute = extendedPropertyElement.attribute(VALUE_TAG);
                if (keyAttribute == null || valueAttribute == null) continue;
                connection.setExtendedProperty(keyAttribute.getValue(), valueAttribute.getValue());
            }
        }
        return connection;
    }

    public static void save(Set<ConnectionParameter> connections, OutputStream stream) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(CONNECTIONS_TAG);
        if (connections != null) {
            for (ConnectionParameter connection : connections) {
                ConnectionIO.addConnection(root, connection);
            }
        }
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter(stream, outformat);
        writer.write(document);
        writer.flush();
    }

    private static void addConnection(Element parent, ConnectionParameter connection) {
        Element connectionElement = parent.addElement(CONNECTION_TAG);
        connectionElement.addAttribute(ID_TAG, connection.getId());
        connectionElement.addAttribute(NAME_TAG, connection.getName());
        connectionElement.addAttribute(HOST_TAG, connection.getHost());
        connectionElement.addAttribute(PORT_TAG, "" + connection.getPort());
        connectionElement.addAttribute(ENCRYPTION_METHOD_TAG, connection.getEncryptionMethod().toString());
        connectionElement.addAttribute(NETWORK_PROVIDER_TAG, connection.getNetworkProvider().toString());
        connectionElement.addAttribute(AUTH_METHOD_TAG, connection.getAuthMethod().toString());
        connectionElement.addAttribute(BIND_PRINCIPAL_TAG, connection.getBindPrincipal());
        connectionElement.addAttribute(BIND_PASSWORD_TAG, connection.getBindPassword());
        connectionElement.addAttribute(SASL_REALM_TAG, connection.getSaslRealm());
        connectionElement.addAttribute(SASL_QOP_TAG, connection.getSaslQop().toString());
        connectionElement.addAttribute(SASL_SEC_STRENGTH_TAG, connection.getSaslSecurityStrength().toString());
        connectionElement.addAttribute(SASL_MUTUAL_AUTH_TAG, "" + connection.isSaslMutualAuthentication());
        connectionElement.addAttribute(KRB5_CREDENTIALS_CONF_TAG, connection.getKrb5CredentialConfiguration().toString());
        connectionElement.addAttribute(KRB5_CONFIG_TAG, connection.getKrb5Configuration().toString());
        connectionElement.addAttribute(KRB5_CONFIG_FILE_TAG, connection.getKrb5ConfigurationFile());
        connectionElement.addAttribute(KRB5_REALM_TAG, connection.getKrb5Realm());
        connectionElement.addAttribute(KRB5_KDC_HOST_TAG, connection.getKrb5KdcHost());
        connectionElement.addAttribute(KRB5_KDC_PORT_TAG, "" + connection.getKrb5KdcPort());
        connectionElement.addAttribute(READ_ONLY_TAG, "" + connection.isReadOnly());
        Element extendedPropertiesElement = connectionElement.addElement(EXTENDED_PROPERTIES_TAG);
        Map<String, String> extendedProperties = connection.getExtendedProperties();
        if (extendedProperties != null) {
            for (Map.Entry<String, String> element : extendedProperties.entrySet()) {
                Element extendedPropertyElement = extendedPropertiesElement.addElement(EXTENDED_PROPERTY_TAG);
                extendedPropertyElement.addAttribute(KEY_TAG, element.getKey());
                extendedPropertyElement.addAttribute(VALUE_TAG, element.getValue());
            }
        }
    }

    public static Set<ConnectionFolder> loadConnectionFolders(InputStream stream) throws ConnectionIOException {
        HashSet<ConnectionFolder> connectionFolders = new HashSet<ConnectionFolder>();
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(stream);
        }
        catch (DocumentException e) {
            throw new ConnectionIOException(e.getMessage());
        }
        Element rootElement = document.getRootElement();
        if (!rootElement.getName().equals(CONNECTION_FOLDERS_TAG)) {
            throw new ConnectionIOException("The file does not seem to be a valid ConnectionFolders file.");
        }
        Iterator i = rootElement.elementIterator(CONNECTION_FOLDER_TAG);
        while (i.hasNext()) {
            Element connectionFolderElement = (Element)i.next();
            connectionFolders.add(ConnectionIO.readConnectionFolder(connectionFolderElement));
        }
        return connectionFolders;
    }

    private static ConnectionFolder readConnectionFolder(Element element) throws ConnectionIOException {
        Element foldersElement;
        Element connectionsElement;
        Attribute nameAttribute;
        ConnectionFolder connectionFolder = new ConnectionFolder();
        Attribute idAttribute = element.attribute(ID_TAG);
        if (idAttribute != null) {
            connectionFolder.setId(idAttribute.getValue());
        }
        if ((nameAttribute = element.attribute(NAME_TAG)) != null) {
            connectionFolder.setName(nameAttribute.getValue());
        }
        if ((connectionsElement = element.element(CONNECTIONS_TAG)) != null) {
            Iterator i = connectionsElement.elementIterator(CONNECTION_TAG);
            while (i.hasNext()) {
                Element connectionElement = (Element)i.next();
                Attribute connectionIdAttribute = connectionElement.attribute(ID_TAG);
                if (connectionIdAttribute == null) continue;
                connectionFolder.addConnectionId(connectionIdAttribute.getValue());
            }
        }
        if ((foldersElement = element.element(SUB_FOLDERS_TAG)) != null) {
            Iterator i = foldersElement.elementIterator(SUB_FOLDER_TAG);
            while (i.hasNext()) {
                Element folderElement = (Element)i.next();
                Attribute folderIdAttribute = folderElement.attribute(ID_TAG);
                if (folderIdAttribute == null) continue;
                connectionFolder.addSubFolderId(folderIdAttribute.getValue());
            }
        }
        return connectionFolder;
    }

    public static void saveConnectionFolders(Set<ConnectionFolder> connectionFolders, OutputStream stream) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(CONNECTION_FOLDERS_TAG);
        if (connectionFolders != null) {
            for (ConnectionFolder connectionFolder : connectionFolders) {
                ConnectionIO.addFolderConnection(root, connectionFolder);
            }
        }
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter(stream, outformat);
        writer.write(document);
        writer.flush();
    }

    private static void addFolderConnection(Element parent, ConnectionFolder connectionFolder) {
        Element connectionFolderElement = parent.addElement(CONNECTION_FOLDER_TAG);
        connectionFolderElement.addAttribute(ID_TAG, connectionFolder.getId());
        connectionFolderElement.addAttribute(NAME_TAG, connectionFolder.getName());
        Element connectionsElement = connectionFolderElement.addElement(CONNECTIONS_TAG);
        for (String connectionId : connectionFolder.getConnectionIds()) {
            Element connectionElement = connectionsElement.addElement(CONNECTION_TAG);
            connectionElement.addAttribute(ID_TAG, connectionId);
        }
        Element foldersElement = connectionFolderElement.addElement(SUB_FOLDERS_TAG);
        for (String folderId : connectionFolder.getSubFolderIds()) {
            Element folderElement = foldersElement.addElement(SUB_FOLDER_TAG);
            folderElement.addAttribute(ID_TAG, folderId);
        }
    }
}

