/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportXlsRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportBaseWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportExcelFromWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportExcelToWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ExportExcelWizard
extends ExportBaseWizard {
    private ExportExcelFromWizardPage fromPage;
    private ExportExcelToWizardPage toPage;

    public ExportExcelWizard() {
        super(Messages.getString("ExportExcelWizard.ExcelExport"));
    }

    public static String getId() {
        return BrowserUIConstants.WIZARD_EXPORT_EXCEL;
    }

    public void addPages() {
        this.fromPage = new ExportExcelFromWizardPage(ExportExcelFromWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.fromPage);
        this.toPage = new ExportExcelToWizardPage(ExportExcelToWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.toPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fromPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_excelexport_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.toPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_excelexport_wizard");
    }

    public boolean performFinish() {
        this.fromPage.saveDialogSettings();
        this.toPage.saveDialogSettings();
        boolean exportDn = this.fromPage.isExportDn();
        new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new ExportXlsRunnable(this.exportFilename, this.search.getBrowserConnection(), this.search.getSearchParameter(), exportDn)}).execute();
        return true;
    }
}

