/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import org.apache.directory.studio.ldapbrowser.common.widgets.ModWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.parser.LdifParser;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BatchOperationModifyWizardPage
extends WizardPage
implements WidgetModifyListener {
    private BatchOperationWizard wizard;
    private ModWidget modWidget;

    public BatchOperationModifyWizardPage(String pageName, BatchOperationWizard wizard) {
        super(pageName);
        super.setTitle(Messages.getString("BatchOperationModifyWizardPage.DefineModification"));
        super.setDescription(Messages.getString("BatchOperationModifyWizardPage.PleaseDefineModifications"));
        super.setPageComplete(false);
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.modWidget = new ModWidget(this.wizard.getConnection() != null ? this.wizard.getConnection().getSchema() : Schema.DEFAULT_SCHEMA);
        this.modWidget.createContents(composite);
        this.modWidget.addWidgetModifyListener((WidgetModifyListener)this);
        this.validate();
        this.setControl((Control)composite);
    }

    public String getLdifFragment() {
        return this.modWidget.getLdifFragment();
    }

    public void widgetModified(WidgetModifyEvent event) {
        this.validate();
    }

    private void validate() {
        String dummyLdif = "dn: cn=dummy" + BrowserCoreConstants.LINE_SEPARATOR + this.modWidget.getLdifFragment();
        LdifFile model = new LdifParser().parse(dummyLdif);
        LdifContainer[] containers = model.getContainers();
        if (containers.length == 0) {
            this.setPageComplete(false);
            return;
        }
        for (int i = 0; i < containers.length; ++i) {
            if (containers[i].isValid()) continue;
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }
}

