/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.searchlogs;

import java.io.File;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.io.jndi.LdifSearchLogger;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.views.searchlogs.Messages;
import org.apache.directory.studio.ldapbrowser.ui.views.searchlogs.SearchLogsView;
import org.apache.directory.studio.ldapbrowser.ui.views.searchlogs.SearchLogsViewInput;
import org.eclipse.jface.resource.ImageDescriptor;

public class OlderAction
extends BrowserAction {
    private SearchLogsView view;

    public OlderAction(SearchLogsView view) {
        this.view = view;
    }

    public void dispose() {
        super.dispose();
    }

    public void run() {
        SearchLogsViewInput oldInput = (SearchLogsViewInput)this.getInput();
        SearchLogsViewInput newInput = new SearchLogsViewInput(oldInput.getBrowserConnection(), oldInput.getIndex() + 1);
        this.view.getUniversalListener().setInput(newInput);
        this.view.getUniversalListener().scrollToNewest();
    }

    public String getText() {
        return Messages.getString("OlderAction.Older");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/previous.gif");
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        SearchLogsViewInput input;
        if (this.getInput() != null && this.getInput() instanceof SearchLogsViewInput && (input = (SearchLogsViewInput)this.getInput()).getBrowserConnection().getConnection() != null) {
            LdifSearchLogger searchLogger = ConnectionCorePlugin.getDefault().getLdifSearchLogger();
            File[] files = searchLogger.getFiles(input.getBrowserConnection().getConnection());
            int i = input.getIndex() + 1;
            if (0 <= i && i < files.length && files[i] != null && files[i].exists() && files[i].canRead()) {
                return true;
            }
        }
        return false;
    }
}

